/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.UnaggregatedDataTensor;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.MergeVisitor;
import com.dataiku.dip.pivot.backend.dss.aggregators.UnaggregatedMeasureFlushableAggregatorImpl;
import com.dataiku.dip.pivot.backend.dss.aggregators.UnaggregatedMeasureOverlayAggregatorImpl;
import com.dataiku.dip.pivot.backend.dss.aggregators.UnaggregatedMeasureStackedAggregatorImpl;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.utils.NotImplementedException;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;

public class UnaggregatedDoubleMeasureAggregator
extends AbstractAggregator<double[]> {
    protected final UnaggregatedMeasureFlushableAggregatorImpl aggregator;
    protected final UnaggregatedMeasureFlushableAggregatorImpl[] axes;
    protected UnaggregatedMeasureFlushableAggregatorImpl mergeAggregator;

    public UnaggregatedDoubleMeasureAggregator(Aggregation uaAggregation) {
        this(uaAggregation, 1);
    }

    public UnaggregatedDoubleMeasureAggregator(Aggregation uaAggregation, int[] numBins) {
        super(uaAggregation, new UnaggregatedDataTensor.Builder().axisLengths(numBins).initNonNullCounts(true).build());
        this.aggregator = this.newFlushableInstance(new double[this.getOutDT().tensorSize], this.getOutDT().nonNullCounts, this.req.column);
        this.axes = this.newFlushableArrayInstance(this.getOutDT().numAxes);
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i] = this.newFlushableInstance(new double[this.getOutDT().axisLengths[i]], null, this.req.column + "_axis_" + i);
        }
    }

    public UnaggregatedDoubleMeasureAggregator(Aggregation uaAggregation, int bins) {
        super(uaAggregation, new UnaggregatedDataTensor.Builder().axisLengths(bins).initNonNullCounts(true).build());
        this.axes = this.newFlushableArrayInstance(0);
        this.aggregator = this.newFlushableInstance(new double[this.getOutDT().tensorSize], this.getOutDT().nonNullCounts, this.req.column);
    }

    @Override
    public void handleBlock(ColumnBlock aggrColumn, int start, int rows, int[] coords, int[] bins, boolean[] filters, boolean fillAxes) throws IOException {
        for (int row = start; row < rows; ++row) {
            if (filters != null && !filters[row]) continue;
            int[] destBin = this.extractDestBin(row, coords, bins);
            if (destBin != null) {
                if (aggrColumn.doubles != null) {
                    this.handle(aggrColumn.doubles[row], destBin, fillAxes);
                } else {
                    this.handle(aggrColumn.getAsStringSlow(row), destBin, fillAxes);
                }
                if (fillAxes) {
                    this.getOutDT().incrementAxesNonNullCount(destBin);
                }
            }
            this.getOutDT().hasNullValues = this.aggregator.hasNullValues;
        }
    }

    @Override
    protected void handle(double value, int[] coords, boolean fillAxes) throws IOException {
        this.aggregator.handle(value, this.getOutDT().loc(coords));
        for (int i = 0; fillAxes && i < this.axes.length; ++i) {
            this.axes[i].handle(value, coords[i]);
        }
    }

    @Override
    protected void handle(Object value, int[] coords, boolean fillAxes) throws IOException {
        this.aggregator.handle(value, this.getOutDT().loc(coords));
        for (int i = 0; fillAxes && i < this.axes.length; ++i) {
            this.axes[i].handle(value, coords[i]);
        }
    }

    @Override
    public void end() throws IOException {
        super.end();
        this.aggregator.onEnd();
        for (UnaggregatedMeasureFlushableAggregatorImpl axe : this.axes) {
            axe.onEnd();
        }
        UnaggregatedDataTensor outDT = (UnaggregatedDataTensor)this.getOutDT();
        outDT.setUAData(this.aggregator.uaData, this.aggregator.uaDataCounts, this.aggregator.uaDataNegativeExtents, this.aggregator.uaDataPositiveExtents);
    }

    @Override
    public void close() throws Exception {
        this.aggregator.close();
        for (UnaggregatedMeasureFlushableAggregatorImpl axesDistinctCount : this.axes) {
            axesDistinctCount.close();
        }
        if (this.mergeAggregator != null) {
            this.mergeAggregator.close();
        }
    }

    @Override
    public void initMerge() {
        this.setMergeDT(this.getOutDT().createMergeDT(this.getOutDT().axisLengths, this.aggregator.hasNullValues));
    }

    @Override
    public double[] mergeValues(double[] v1, double[] v2) {
        throw new NotImplementedException("Should not be used for unaggregated measure");
    }

    @Override
    public void mergeEnd(AxisHandler.Axis[] axes, LongDataTensor countTensor) throws IOException {
        if (this.mergeAggregator == null) {
            return;
        }
        this.mergeAggregator.onEnd(false);
    }

    @Override
    public void postProcessEndPhase2() {
        ((UnaggregatedDataTensor)this.getMergeDT()).fillDataTensor();
        super.postProcessEndPhase2();
    }

    public UnaggregatedMeasureFlushableAggregatorImpl newFlushableInstance(double[] data, long[] nonNullCounts, String column) {
        return switch (this.req.uaComputeMode) {
            case Aggregation.UnaggregatedComputeMode.STACK -> new UnaggregatedMeasureStackedAggregatorImpl(data, nonNullCounts, column, this.req.maxUAValuesPerTensorElement);
            case Aggregation.UnaggregatedComputeMode.OVERLAY -> new UnaggregatedMeasureOverlayAggregatorImpl(data, nonNullCounts, column, this.req.maxUAValuesPerTensorElement);
            default -> throw new UnsupportedOperation("Incompatible compute mode: " + String.valueOf((Object)this.req.uaComputeMode));
        };
    }

    public UnaggregatedMeasureFlushableAggregatorImpl[] newFlushableArrayInstance(int size) {
        return switch (this.req.uaComputeMode) {
            case Aggregation.UnaggregatedComputeMode.STACK -> new UnaggregatedMeasureStackedAggregatorImpl[size];
            case Aggregation.UnaggregatedComputeMode.OVERLAY -> new UnaggregatedMeasureOverlayAggregatorImpl[size];
            default -> throw new UnsupportedOperation("Incompatible compute mode: " + String.valueOf((Object)this.req.uaComputeMode));
        };
    }

    @Override
    protected void transferBinToMergeDT(int originBin, int targetBin, LongDataList countList) {
        UnaggregatedDataTensor mergeDT = (UnaggregatedDataTensor)this.getMergeDT();
        UnaggregatedDataTensor outDT = (UnaggregatedDataTensor)this.getOutDT();
        mergeDT.uaData[targetBin] = outDT.uaData[originBin];
        mergeDT.uaDataCounts[targetBin] = outDT.uaDataCounts[originBin];
        mergeDT.uaDataNegativeExtent[targetBin] = outDT.uaDataNegativeExtent[originBin];
        mergeDT.uaDataPositiveExtent[targetBin] = outDT.uaDataPositiveExtent[originBin];
    }

    @Override
    public void applyOtherCategoryToTensor(AbstractAggregator.OtherCategoryProperties<double[]> ocp, int index) {
        UnaggregatedDataTensor mergeDT = (UnaggregatedDataTensor)this.getMergeDT();
        mergeDT.uaData[index] = ((UnaggregatedOtherCategoryProperties)ocp).uaData;
        mergeDT.uaDataCounts[index] = ((UnaggregatedOtherCategoryProperties)ocp).uaDataCounts;
        mergeDT.uaDataNegativeExtent[index] = ((UnaggregatedOtherCategoryProperties)ocp).uaDataNegativeExtent;
        mergeDT.uaDataPositiveExtent[index] = ((UnaggregatedOtherCategoryProperties)ocp).uaDataPositiveExtent;
    }

    @Override
    public AbstractAggregator.OtherCategoryProperties<double[]> retrieveOthersCategoryProperties(AxisHandler.Axis axis) {
        UnaggregatedOtherCategoryProperties otherCategoryProperties = new UnaggregatedOtherCategoryProperties();
        if (axis.nbNotCutoff == this.getOutDT().nonNullCounts.length) {
            otherCategoryProperties.uaData = new TDoubleArrayList();
            otherCategoryProperties.uaDataCounts = new TIntArrayList();
            otherCategoryProperties.uaDataNegativeExtent = 0.0;
            otherCategoryProperties.uaDataPositiveExtent = 0.0;
            return otherCategoryProperties;
        }
        double[] otherData = new double[this.getOutDT().nonNullCounts.length];
        try (UnaggregatedMeasureFlushableAggregatorImpl localMergeAggregator = this.newFlushableInstance(otherData, this.getOutDT().nonNullCounts, "merge_" + this.req.column);){
            for (int x = 0; x < axis.elts.size(); ++x) {
                if (!axis.elts.get((int)x).cutoffed) continue;
                int origBin = axis.elts.get((int)x).binIndex;
                this.aggregator.readValues(origBin, this.getMergeVisitor(localMergeAggregator, axis.nbNotCutoff));
                otherCategoryProperties.nonNullCountOfOthersColumn += this.getOutDT().nonNullCounts[origBin];
            }
            localMergeAggregator.onEnd(false);
            otherCategoryProperties.uaData = localMergeAggregator.uaData[axis.nbNotCutoff];
            otherCategoryProperties.uaDataCounts = localMergeAggregator.uaDataCounts[axis.nbNotCutoff];
            otherCategoryProperties.uaDataNegativeExtent = localMergeAggregator.uaDataNegativeExtents[axis.nbNotCutoff];
            otherCategoryProperties.uaDataPositiveExtent = localMergeAggregator.uaDataPositiveExtents[axis.nbNotCutoff];
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred", (Throwable)e);
        }
        return otherCategoryProperties;
    }

    @Override
    public boolean mergeTensorAndAxes(PivotTableTensorRequest request, int[] origCoordinates, int[] targetCoordinates, AxisHandler.Axis[] axes) throws IOException {
        if (this.mergeAggregator == null) {
            this.mergeAggregator = this.newFlushableInstance(new double[this.getMergeDT().tensorSize], this.getMergeDT().nonNullCounts, "merge_" + this.req.column);
            UnaggregatedDataTensor mergeDT = (UnaggregatedDataTensor)this.getMergeDT();
            this.mergeAggregator.uaData = mergeDT.uaData;
            this.mergeAggregator.uaDataCounts = mergeDT.uaDataCounts;
            this.mergeAggregator.uaDataNegativeExtents = mergeDT.uaDataNegativeExtent;
            this.mergeAggregator.uaDataPositiveExtents = mergeDT.uaDataPositiveExtent;
        }
        ArrayList<FlushableAggregator.Visitor> visitors = new ArrayList<FlushableAggregator.Visitor>();
        for (int i = 0; i < axes.length; ++i) {
            if (targetCoordinates[i] != axes[i].nbNotCutoff || request.axes[i].sortPrune.generateOthersCategory) continue;
            return false;
        }
        int destLoc = this.getMergeDT().loc(targetCoordinates);
        visitors.add(this.getMergeVisitor(this.mergeAggregator, destLoc));
        this.aggregator.readValues(this.getOutDT().loc(origCoordinates), new FlushableAggregator.VisitorManager(visitors));
        if (this.getOutDT().hasNullValues) {
            this.getMergeDT().incrementNonNullCount(targetCoordinates, this.getOutDT().getNonNullCount(origCoordinates));
        }
        return true;
    }

    @Override
    public void sortAxis(AxisHandler.Axis ret, int asc, LongDataList countList) {
        ret.elts.sort((o1, o2) -> {
            double v1 = this.aggregator.uaDataPositiveExtents[o1.binIndex];
            double v2 = this.aggregator.uaDataPositiveExtents[o2.binIndex];
            if (v1 == 0.0 && v2 == 0.0) {
                v1 = this.aggregator.uaDataNegativeExtents[o1.binIndex];
                v2 = this.aggregator.uaDataNegativeExtents[o2.binIndex];
            }
            return this.compareAxisDoubleValues(v1, v2, (AxisElt)o1, (AxisElt)o2, asc, this.getOutDT().nonNullCounts);
        });
    }

    @Override
    public void sortAxis(AxisHandler.Axis ret, int asc, int axisIdx) {
        long[] nnc = this.getOutDT().axesNonNullCounts[axisIdx];
        ret.elts.sort((o1, o2) -> {
            UnaggregatedMeasureFlushableAggregatorImpl axisAggregator = this.axes[axisIdx];
            double v1 = axisAggregator.uaDataPositiveExtents[o1.binIndex];
            double v2 = axisAggregator.uaDataPositiveExtents[o2.binIndex];
            if (v1 == 0.0 && v2 == 0.0) {
                v1 = this.aggregator.uaDataNegativeExtents[o1.binIndex];
                v2 = this.aggregator.uaDataNegativeExtents[o2.binIndex];
            }
            return this.compareAxisDoubleValues(v1, v2, (AxisElt)o1, (AxisElt)o2, asc, nnc);
        });
    }

    public MergeVisitor<TDoubleArrayList, ArrayList<String>> getMergeVisitor(UnaggregatedMeasureFlushableAggregatorImpl aggregator, int destination) {
        return new UnaggregatedMeasureMergeVisitor(aggregator, destination);
    }

    public static class UnaggregatedOtherCategoryProperties
    extends AbstractAggregator.OtherCategoryProperties<double[]> {
        public TDoubleArrayList uaData;
        public TIntArrayList uaDataCounts;
        public double uaDataNegativeExtent;
        public double uaDataPositiveExtent;
    }

    public static class UnaggregatedMeasureMergeVisitor
    extends MergeVisitor<TDoubleArrayList, ArrayList<String>> {
        public UnaggregatedMeasureMergeVisitor(UnaggregatedMeasureFlushableAggregatorImpl aggregator, int destination) {
            super(aggregator, destination);
        }

        @Override
        public void handleString(String value) throws IOException {
            this.aggregator.handle(value, this.destination);
        }

        @Override
        public void handleDouble(double value) throws IOException {
            this.aggregator.handle(value, this.destination);
        }

        @Override
        public void beginRead(int location, int length) {
            this.aggregator.beginRead(location, length);
        }

        @Override
        public void endRead(int location) {
            this.aggregator.endRead(this.destination);
        }
    }
}

