/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel.xssf;

import com.dataiku.dip.pivot.frontend.excel.xssf.ChartTextSource;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Cell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellValue;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.FormulaEvaluator;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Row;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Sheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;

public class ChartSources {
    private static final DKULogger logger = DKULogger.getLogger(ChartSources.class);

    public static ChartTextSource fromString(String element) {
        return new LiteralTextSource(element);
    }

    public static ChartTextSource fromCellRange(XSSFSheet sheet, CellRangeAddress cellRangeAddress) {
        return new CellRangeTextSource((Sheet)sheet, cellRangeAddress);
    }

    private static class LiteralTextSource
    implements ChartTextSource {
        private final String element;

        public LiteralTextSource(String element) {
            this.element = element;
        }

        public boolean isNumeric() {
            return false;
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public String getFormulaString() {
            throw new UnsupportedOperationException("Literal data source can not be expressed by reference.");
        }

        @Override
        public void renameSheet(String oldname, String newname) {
        }

        @Override
        public String getTextString() {
            return this.element;
        }
    }

    private static class CellRangeTextSource
    implements ChartTextSource {
        private final Sheet sheet;
        private final CellRangeAddress cellRangeAddress;
        private final int numOfCells;
        private final FormulaEvaluator evaluator;

        protected CellRangeTextSource(Sheet sheet, CellRangeAddress cellRangeAddress) {
            this.sheet = sheet;
            this.cellRangeAddress = cellRangeAddress.copy();
            this.numOfCells = this.cellRangeAddress.getNumberOfCells();
            this.evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public String getFormulaString() {
            return this.cellRangeAddress.formatAsString(this.sheet.getSheetName(), true);
        }

        protected CellValue getCellValueAt(int index) {
            if (index < 0 || index >= this.numOfCells) {
                throw new IndexOutOfBoundsException("Index must be between 0 and " + (this.numOfCells - 1) + " (inclusive), given: " + index);
            }
            int firstRow = this.cellRangeAddress.getFirstRow();
            int firstCol = this.cellRangeAddress.getFirstColumn();
            int lastCol = this.cellRangeAddress.getLastColumn();
            int width = lastCol - firstCol + 1;
            int rowIndex = firstRow + index / width;
            int cellIndex = firstCol + index % width;
            Row row = this.sheet.getRow(rowIndex);
            Cell cell = row.getCell(cellIndex);
            try {
                return this.evaluator.evaluate(cell);
            }
            catch (RuntimeException e) {
                logger.warn((Object)e);
                return CellValue.getError((int)cell.getErrorCellValue());
            }
        }

        @Override
        public void renameSheet(String oldname, String newname) {
        }

        @Override
        public String getTextString() {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.numOfCells; ++j) {
                CellValue cellValue = this.getCellValueAt(j);
                if (cellValue == null) continue;
                sb.append(cellValue.getStringValue());
            }
            return sb.length() == 0 ? null : sb.toString();
        }
    }
}

