/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugin.tools;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.plugin.CustomFormat;
import com.dataiku.dip.plugin.CustomFormatOutput;
import com.dataiku.dip.plugin.tools.RunBase;
import com.dataiku.dip.plugin.tools.SchemaFromCli;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RunOutput
extends RunBase {
    private final Schema schema;

    public RunOutput(CommandLine cmdLine, int formatClassPos) {
        super(cmdLine, formatClassPos);
        this.schema = SchemaFromCli.getSchema(cmdLine);
    }

    RunOutput(String formatClass, String classesDir, String jarFilePath, String libPath, Schema schema, String config, String pluginConfig) {
        super(formatClass, classesDir, jarFilePath, libPath, config, pluginConfig);
        this.schema = schema;
    }

    public void run() throws Exception {
        RFC4180CSVParser parser = new RFC4180CSVParser((LineReader)new InputStreamLineReader(System.in, StandardCharsets.UTF_8), '\t');
        ArrayList line = Lists.newArrayList();
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        if (this.schema == null) {
            throw new Exception("No schema specified");
        }
        ArrayList columns = Lists.newArrayList();
        for (SchemaColumn column : this.schema.getColumns()) {
            columns.add(cf.column(column.getName()));
        }
        CustomFormat format = this.getFormat();
        try (CustomFormatOutput writer = format.getWriter(this.config, this.pluginConfig);){
            writer.setOutputSchema(this.schema);
            writer.header((ColumnFactory)cf, (OutputStream)System.out);
            while (parser.next(line)) {
                Row row = rf.row();
                for (int i = 0; i < Math.min(line.size(), columns.size()); ++i) {
                    row.put((Column)columns.get(i), (String)line.get(i));
                }
                writer.format(row, (ColumnFactory)cf, (OutputStream)System.out);
            }
            writer.footer((ColumnFactory)cf, (OutputStream)System.out);
        }
    }

    public static void main(String[] args) throws Exception {
        RunBase.init();
        Options opts = new Options();
        RunBase.fillOptions(opts);
        SchemaFromCli.fillOptions(opts);
        try {
            CommandLine cmdLine = new DefaultParser().parse(opts, args);
            if (cmdLine.getArgs().length == 0) {
                RunOutput.usage(opts);
            } else {
                new RunOutput(cmdLine, 0).run();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            RunOutput.usage(opts);
            System.exit(1);
        }
    }

    private static void usage(Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("test-output", "Test a format output on the standard input (read as tab-separated csv) and writes the output to the standard output", opts, "", true);
    }
}

