/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.interactivemodel.InteractiveModelKernel;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelInfo;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.ml.shared.EvaluationLabelsHelper;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.prediction.MLflowOrigin;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.connections.HuggingFaceLocalConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalml.mlflow.ImportMLFlowModelInfo;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.externalml.mlflow.MLflowModelDeployResult;
import com.dataiku.dip.externalml.mlflow.MLflowModelOperationsService;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMRefEnricherService;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.savedmodels.proxymodels.ProxyModelConfiguration;
import com.dataiku.dip.savedmodels.proxymodelversions.ProxyModelVersionConfiguration;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionChangedEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionDeletedEvent;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Service
public class SavedModelsService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ManagedFolderDAO managedFolderDao;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private MLflowModelOperationsService mlflowModelOperationsService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private PredictionSMMgmtService psmmService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private DSSInternalCodeEnvsService dssInternalCodeEnvsService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private LLMRefEnricherService llmRefEnricherService;
    public static final Set<String> ALLOWED_SAVED_MODEL_PROTOCOLS = ImmutableSet.of((Object)"sagemaker", (Object)"azure-ml", (Object)"vertex-ai", (Object)"databricks", (Object)"dss-api-node");
    static DKULogger logger = DKULogger.getLogger((String)"dku.savedmodels.api");

    public SavedModel createExternalSavedModel(AuthCtx authCtx, String projectKey, SavedModel.SavedModelType savedModelType, PredictionMLTask.PredictionType predictionType, String name, @Nullable ProxyModelConfiguration proxyModelConfiguration) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("Name of Saved Model can not be empty");
        }
        if (predictionType != PredictionMLTask.PredictionType.BINARY_CLASSIFICATION && predictionType != PredictionMLTask.PredictionType.MULTICLASS && predictionType != PredictionMLTask.PredictionType.REGRESSION && predictionType != null) {
            throw new IllegalArgumentException(String.format("Cannot use prediction type \"%s\" with external models.", new Object[]{predictionType}));
        }
        if (savedModelType != SavedModel.SavedModelType.PROXY_MODEL && savedModelType != SavedModel.SavedModelType.MLFLOW_PYFUNC && savedModelType != SavedModel.SavedModelType.LLM_GENERIC) {
            throw new IllegalArgumentException(String.format("Invalid external saved model type: %s", new Object[]{savedModelType}));
        }
        if (savedModelType == SavedModel.SavedModelType.PROXY_MODEL) {
            if (proxyModelConfiguration == null) {
                throw new IllegalArgumentException("External models must have a proxy model configuration");
            }
            if (!ALLOWED_SAVED_MODEL_PROTOCOLS.contains(proxyModelConfiguration.protocol)) {
                throw new IllegalArgumentException(String.format("Invalid proxy model protocol: %s", proxyModelConfiguration.protocol));
            }
            proxyModelConfiguration.validate();
        } else if (proxyModelConfiguration != null) {
            throw new IllegalArgumentException("MLflow models cannot have a proxy model configuration");
        }
        SavedModel sm = new SavedModel();
        sm.projectKey = projectKey;
        sm.id = SecretKeyGenerator.generate((int)8);
        sm.name = name;
        sm.savedModelType = savedModelType;
        sm.proxyModelConfiguration = proxyModelConfiguration;
        if (sm.savedModelType != SavedModel.SavedModelType.LLM_GENERIC) {
            PredictionMLTask.ClassicalPredictionMLTask task = new PredictionMLTask.ClassicalPredictionMLTask();
            task.taskType = MLTask.MLTaskType.PREDICTION;
            task.predictionType = predictionType;
            task.modeling = PredictionModelingParams.newWithoutAnyAlgorithmSettings();
            task.modeling.metrics = new MetricParams();
            if (predictionType != null) {
                switch (predictionType) {
                    case BINARY_CLASSIFICATION: 
                    case MULTICLASS: {
                        task.modeling.metrics.evaluationMetric = MetricParams.EvaluationMetric.ROC_AUC;
                        task.modeling.metrics.thresholdOptimizationMetric = MetricParams.ThresholdOptimizationMetric.F1;
                        break;
                    }
                    case REGRESSION: {
                        task.modeling.metrics.evaluationMetric = MetricParams.EvaluationMetric.R2;
                        break;
                    }
                    default: {
                        throw new Error("Cannot use prediction type \"" + String.valueOf((Object)predictionType) + "\" with external models.");
                    }
                }
            }
            sm.miniTask = task;
        }
        MLPaths.createIfNeededSavedModelFolderAndRestrictPermissions(sm);
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, MLPaths.savedModelBaseFolder(sm.projectKey, sm.id));
        ArrayList contentTypeChunks = Lists.newArrayList();
        if (sm.savedModelType == SavedModel.SavedModelType.MLFLOW_PYFUNC) {
            contentTypeChunks.add(InteractiveModelKernel.KernelType.MLFLOW_KERNEL_TYPE.displayName());
            contentTypeChunks.add(sm.miniTask.taskType.name().toLowerCase());
            contentTypeChunks.add(sm.miniTask.backendType.name().toLowerCase());
        }
        if (sm.savedModelType == SavedModel.SavedModelType.PROXY_MODEL) {
            contentTypeChunks.add(InteractiveModelKernel.KernelType.PROXY_MODEL_KERNEL_TYPE.displayName());
            contentTypeChunks.add(sm.miniTask.taskType.name().toLowerCase());
            contentTypeChunks.add(sm.miniTask.backendType.name().toLowerCase());
        }
        if (sm.savedModelType == SavedModel.SavedModelType.LLM_GENERIC) {
            contentTypeChunks.add(SavedModel.llmFinetuningContentType);
        }
        sm.contentType = Joiner.on((String)"/").join((Iterable)contentTypeChunks);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) != null) {
                throw new IllegalArgumentException("Saved model " + sm.id + " already exists");
            }
            this.savedModelsCRUDService.save(sm, true, false);
            t.commit("Created external saved model " + String.valueOf((Object)savedModelType) + " : " + sm.id);
            SavedModel savedModel = sm;
            return savedModel;
        }
    }

    public FullModelId createProxySavedModelVersion_NT(AuthCtx authCtx, SavedModel sm, String projectKey, String versionId, ProxyModelVersionConfiguration proxyModelVersionConfiguration, double binaryClassificationThreshold, String evaluationDatasetSmartName, SamplingParam evaluationDatasetSamplingParam) throws Exception {
        FullModelId fmi = new FullModelId(sm.projectKey, sm.id, versionId);
        if (proxyModelVersionConfiguration == null) {
            throw new IllegalArgumentException("Missing proxy model version configuration");
        }
        if (proxyModelVersionConfiguration.proxyModelConfiguration == null) {
            throw new IllegalArgumentException("Missing proxy model configuration");
        }
        if (!StringUtils.equals((String)proxyModelVersionConfiguration.protocol, (String)proxyModelVersionConfiguration.proxyModelConfiguration.protocol)) {
            throw new IllegalArgumentException("Can't create a " + proxyModelVersionConfiguration.protocol + " version for external model protocol " + sm.proxyModelConfiguration.protocol);
        }
        try {
            proxyModelVersionConfiguration.validate();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The provided proxy model version configuration is invalid", e);
        }
        if (sm.savedModelType != SavedModel.SavedModelType.PROXY_MODEL) {
            throw new IllegalArgumentException("Can't manually create a " + String.valueOf((Object)SavedModel.SavedModelType.PROXY_MODEL) + " version for saved model type " + String.valueOf((Object)sm.savedModelType));
        }
        if (sm.proxyModelConfiguration == null) {
            throw new IllegalArgumentException("Missing proxy model configuration in saved model");
        }
        try {
            sm.proxyModelConfiguration.validate();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The existing saved model's proxy configuration is invalid", e);
        }
        if (StringUtils.isNotEmpty((String)sm.proxyModelConfiguration.connection)) {
            this.connectionsService.checkUserForConnection(authCtx, sm.proxyModelConfiguration.connection);
        }
        String codeEnvName = DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.PROXY_MODELS_CODE_ENV);
        this.codeEnvResolutionService.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, codeEnvName);
        logger.info((Object)"Preparing Proxy model SMV folder");
        if (DKUFileUtils.exists((File)fmi.getModelFolder(), (String[])new String[0])) {
            DKUFileUtils.forceDelete((File)fmi.getModelFolder());
        }
        MLPaths.createIfNeededSavedModelFolderAndRestrictPermissions(sm);
        DKUFileUtils.mkdirs((File)fmi.getModelFolder());
        String modelFolder = fmi.getModelFolder().getPath();
        String mlmodelContent = FileUtils.readFileToString((File)new File(ApplicationConfigurator.getInstallFolder() + "/resources/saved-models/proxy-models/MLmodel.tmpl")).replace("${PROTOCOL}", sm.proxyModelConfiguration.protocol);
        FileUtils.writeStringToFile((File)new File(modelFolder, "MLmodel"), (String)mlmodelContent);
        FilesystemACLUtils.grantFSReadACLs(authCtx, projectKey, fmi.getFolderEnsuringSecurity());
        FilesystemACLUtils.grantFSFullACLs(authCtx, projectKey, true, fmi.getModelFolder());
        this.createAndSaveMLflowImportedModelMetadata_NT(authCtx, projectKey, sm, fmi, codeEnvName, binaryClassificationThreshold, null, proxyModelVersionConfiguration, evaluationDatasetSmartName, evaluationDatasetSamplingParam);
        this.createAndSaveMLflowModelUserMeta(fmi, versionId, binaryClassificationThreshold);
        logger.info((Object)"Proxy model created");
        return fmi;
    }

    public File downloadModelFromDatabricks(DSSAuthCtx authCtx, DatabricksModelDeploymentConnection connection, boolean useUnityCatalog, String modelName, String modelVersion, File targetDirectory) throws Exception {
        logger.infoV("Downloading MLflow model %s version %s using DBX connection %s", new Object[]{modelName, modelVersion, connection.name});
        File f = DatabricksUtils.downloadModelFromDatabricks(authCtx, connection, useUnityCatalog, modelName, modelVersion, targetDirectory, List.of());
        logger.infoV("MLflow model downloaded in %s", new Object[]{f.getAbsolutePath()});
        return f;
    }

    public FullModelId createMLflowSavedModelVersion_NT(AuthCtx authCtx, SavedModel sm, String projectKey, String versionId, MultipartFile filePart, String folderRef, String path, String codeEnvName, ContainerExecSelection containerExecSelection, MLflowOrigin origin, double binaryClassificationThreshold, String evaluationDatasetSmartName, SamplingParam evaluationDatasetSamplingParam) throws Exception {
        FullModelId fmi = new FullModelId(sm.projectKey, sm.id, versionId);
        if (sm.savedModelType != SavedModel.SavedModelType.MLFLOW_PYFUNC) {
            throw new IllegalArgumentException("Can't manually create a " + String.valueOf((Object)SavedModel.SavedModelType.MLFLOW_PYFUNC) + " version for saved model type " + String.valueOf((Object)sm.savedModelType));
        }
        logger.info((Object)"Preparing MLflow SMV folder");
        MLPaths.createIfNeededSavedModelFolderAndRestrictPermissions(sm);
        if (DKUFileUtils.exists((File)fmi.getModelFolder(), (String[])new String[0])) {
            DKUFileUtils.forceDelete((File)fmi.getModelFolder());
        }
        DKUFileUtils.mkdirs((File)fmi.getModelFolder());
        if (filePart != null && folderRef == null && path == null) {
            logger.info((Object)("Uploading archive " + filePart.getOriginalFilename()));
            DKUFileUtils.unzipInputStream((File)fmi.getModelFolder(), (InputStream)filePart.getInputStream());
        } else if (filePart == null && folderRef != null && path != null) {
            ManagedFolderHandler managedFolderHandler;
            logger.info((Object)("Uploading model from managed_folder " + folderRef + " with path " + path));
            try (Transaction t = this.transactionService.beginRead();){
                AnyLoc manageFolderLoc = AnyLoc.resolveSmart(projectKey, folderRef);
                this.projectsService.failIfNoManagedFolderReadUseAccess(authCtx, manageFolderLoc, sm.projectKey);
                ManagedFolder managedFolder = (ManagedFolder)this.managedFolderDao.getMandatoryUnsafe(manageFolderLoc.getProjectKey(), manageFolderLoc.getId());
                managedFolderHandler = (ManagedFolderHandler)managedFolder.buildHandler(authCtx);
            }
            managedFolderHandler.recursiveDownload(path, fmi.getModelFolder());
        } else if (filePart == null && folderRef == null && path != null) {
            File fromDirectory = new File(path);
            if (!fromDirectory.exists()) {
                throw new IllegalArgumentException("Directory " + path + " does not exist.");
            }
            DKUFileUtils.copyDirectory((File)fromDirectory, (File)fmi.getModelFolder());
        } else {
            throw new IllegalArgumentException("Need to send either a file containing the model or specify a managed folder and a path.");
        }
        logger.info((Object)("MLflow saved model \"" + sm.id + "\": Creating version \"" + versionId + "\""));
        FilesystemACLUtils.grantFSReadACLs(authCtx, projectKey, fmi.getFolderEnsuringSecurity());
        FilesystemACLUtils.grantFSFullACLs(authCtx, projectKey, true, fmi.getModelFolder());
        this.createAndSaveMLflowImportedModelMetadata_NT(authCtx, projectKey, sm, fmi, codeEnvName, binaryClassificationThreshold, origin, null, evaluationDatasetSmartName, evaluationDatasetSamplingParam);
        this.mlflowModelOperationsService.readMeta(authCtx, fmi, containerExecSelection);
        try {
            this.warnIfMismatchedPythonVersions(fmi, codeEnvName, projectKey);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Error when comparing the Python versions of the code environment and the MLflow model", new Object[0]);
        }
        this.createAndSaveMLflowModelUserMeta(fmi, versionId, binaryClassificationThreshold);
        logger.info((Object)"MLflow External model imported");
        return fmi;
    }

    private void warnIfMismatchedPythonVersions(FullModelId fmi, String codeEnvName, String projectKey) throws IOException {
        StandardPythonInterpreter codeEnvInterpreter = this.codeEnvResolutionService.getPythonInterpreterVersion(codeEnvName, projectKey);
        String patchlessCodeEnvPythonVersion = String.format("%d.%d", codeEnvInterpreter.getMajor(), codeEnvInterpreter.getMinor());
        Optional<String> mlmodelPythonVersion = fmi.getMLflowImportedModelMetadata().pyfuncLabels.stream().filter(kv -> "python_function:python_version".equals(kv.key)).map(kv -> kv.value).findFirst();
        if (mlmodelPythonVersion.isEmpty()) {
            throw new IllegalArgumentException("The imported model metadata does not contain the Python version of the model");
        }
        String patchlessMlflowPythonVersion = Arrays.stream(mlmodelPythonVersion.get().split("\\.")).limit(2L).collect(Collectors.joining("."));
        if (!patchlessCodeEnvPythonVersion.equals(patchlessMlflowPythonVersion)) {
            logger.warnV("The Python version declared in the MLmodel file of MLflow model %s (%s) does not match the Python version of the code environment %s (%s). This may cause compatibility issues", new Object[]{fmi.toString(), patchlessMlflowPythonVersion, codeEnvName, patchlessCodeEnvPythonVersion});
        }
    }

    private void createAndSaveMLflowImportedModelMetadata_NT(AuthCtx authCtx, String projectKey, SavedModel externalSavedModel, FullModelId fullModelId, String codeEnvName, double binaryClassificationThreshold, MLflowOrigin origin, @Nullable ProxyModelVersionConfiguration proxyModelVersionConfiguration, String evaluationDatasetSmartName, SamplingParam evaluationDatasetSamplingParam) throws Exception {
        CodeEnvSelector selector = new CodeEnvSelector();
        String resolvedCodeEnvName = "INHERIT".equals(codeEnvName) ? selector.selectForPythonRecipe(projectKey, CodeEnvSelection.inherit()) : selector.selectForPythonRecipe(projectKey, CodeEnvSelection.explicitEnv(codeEnvName));
        MLFlowModelVersionInfo mvi = new MLFlowModelVersionInfo();
        mvi.importedOn = System.currentTimeMillis();
        if (externalSavedModel.savedModelType == SavedModel.SavedModelType.PROXY_MODEL) {
            mvi.timeCreated = mvi.importedOn;
        }
        mvi.predictionType = ((PredictionMLTask)externalSavedModel.miniTask).predictionType;
        mvi.metricParams = ((PredictionMLTask.ClassicalPredictionMLTask)externalSavedModel.miniTask).modeling.metrics;
        mvi.pythonCodeEnvName = resolvedCodeEnvName;
        mvi.origin = origin;
        mvi.binaryClassificationThreshold = binaryClassificationThreshold;
        mvi.evaluationDatasetSmartName = evaluationDatasetSmartName;
        mvi.evaluationSamplingParam = evaluationDatasetSamplingParam;
        if (externalSavedModel.savedModelType == SavedModel.SavedModelType.PROXY_MODEL) {
            if (externalSavedModel.proxyModelConfiguration == null || proxyModelVersionConfiguration == null) {
                throw new IllegalArgumentException("Cannot create a proxy model version without a proxy configuration");
            }
            mvi.proxyModelVersionConfiguration = proxyModelVersionConfiguration;
            try {
                mvi.proxyModelEndpointInfo = mvi.proxyModelVersionConfiguration.getConsolidatedEndpointInfo_NT(authCtx);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Error when retrieving info on external model endpoint %s", new Object[]{JSON.pretty((Object)mvi.proxyModelVersionConfiguration.proxyModelConfiguration)});
                ProxyModelVersionConfiguration.ErrorEndpointInfo errorEndpointInfo = new ProxyModelVersionConfiguration.ErrorEndpointInfo();
                errorEndpointInfo.errorMessage = "An error occurred when retrieving info on the endpoint when the saved model version was created";
                errorEndpointInfo.stackTraceStr = ExceptionUtils.getFullStackTrace((Throwable)e);
                mvi.proxyModelEndpointInfo = errorEndpointInfo;
            }
        } else if (externalSavedModel.proxyModelConfiguration != null || proxyModelVersionConfiguration != null) {
            throw new IllegalArgumentException("Cannot set a proxy configuration for a non-proxy model (savedModelType=" + String.valueOf((Object)externalSavedModel.savedModelType));
        }
        fullModelId.writeMLflowImportedModelMetadata(mvi);
    }

    private void createAndSaveMLflowModelUserMeta(FullModelId fullModelId, String versionId, double binaryClassificationThreshold) throws IOException {
        ModelUserMeta mum = new ModelUserMeta();
        mum.name = versionId;
        mum.labels = EvaluationLabelsHelper.getMLflowSMVLabels(versionId);
        mum.activeClassifierThreshold = binaryClassificationThreshold;
        fullModelId.saveUserMeta(mum);
    }

    public FutureResponse<MLflowModelDeployResult> deployProxyModelInFuture(final AuthCtx authCtx, final String projectKey, String smId, final String versionId, final MLFlowModelVersionInfo modelVersionInfo, StreamableDatasetSelection sds, final ContainerExecSelection containerExecSelection, boolean activate, final double binaryClassificationThreshold, boolean useOptimalThreshold, boolean skipExpensiveReports) throws Exception {
        return this.futureService.runFuture(new ExternalModelDeployFutureThread(authCtx, "proxy", projectKey, smId, modelVersionInfo, versionId, activate, sds, useOptimalThreshold, skipExpensiveReports){

            @Override
            public ContainerExecSelection getContainerExecSelection() {
                return containerExecSelection;
            }

            @Override
            public FullModelId createSavedModelVersion_NT(SavedModel savedModel) throws Exception {
                return SavedModelsService.this.createProxySavedModelVersion_NT(authCtx, savedModel, projectKey, versionId, modelVersionInfo.proxyModelVersionConfiguration, binaryClassificationThreshold, modelVersionInfo.evaluationDatasetSmartName, modelVersionInfo.evaluationSamplingParam);
            }

            @Override
            public String getInferSignatureStepMessage() throws Exception {
                return "Calling endpoint and inferring model signature";
            }
        }, 0L, new TypeToken<FutureResponse<MLflowModelDeployResult>>(){});
    }

    public FutureResponse<MLflowModelDeployResult> deployMLflowModelInFuture(final AuthCtx authCtx, final String projectKey, String smId, final String folderRef, final String path, final String versionId, final MLFlowModelVersionInfo modelVersionInfo, final MLflowOrigin origin, StreamableDatasetSelection sds, Boolean activate, final double binaryClassificationThreshold, Boolean useOptimalThreshold, Boolean skipExpensiveReports) throws Exception {
        final ContainerExecSelection containerExecSelection = new ContainerExecSelection();
        containerExecSelection.containerMode = ContainerExecSelection.ContainerExecMode.INHERIT;
        return this.futureService.runFuture(new ExternalModelDeployFutureThread(authCtx, "MLflow", projectKey, smId, modelVersionInfo, versionId, activate, sds, useOptimalThreshold, skipExpensiveReports){

            @Override
            public ContainerExecSelection getContainerExecSelection() {
                return containerExecSelection;
            }

            @Override
            public FullModelId createSavedModelVersion_NT(SavedModel savedModel) throws Exception {
                return SavedModelsService.this.createMLflowSavedModelVersion_NT(authCtx, savedModel, projectKey, versionId, null, folderRef, path, modelVersionInfo.pythonCodeEnvName, containerExecSelection, origin, binaryClassificationThreshold, modelVersionInfo.evaluationDatasetSmartName, modelVersionInfo.evaluationSamplingParam);
            }

            @Override
            public String getInferSignatureStepMessage() throws Exception {
                return "Inferring model signature";
            }
        }, 0L, new TypeToken<FutureResponse<MLflowModelDeployResult>>(){});
    }

    public ImportMLFlowModelInfo importModelFromArchive(MultipartFile filePart) throws IOException {
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"saved_model", (String)"importModelFromArchive", (boolean)true);){
            ImportMLFlowModelInfo importMLFlowModelInfo;
            File tempPackageArchive = new File((File)tmpDir, "package.zip");
            FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)tempPackageArchive);
            Validate.isTrue((boolean)tempPackageArchive.exists(), (String)("Archive to import does not exist: " + String.valueOf(tempPackageArchive)));
            LoaderOptions options = new LoaderOptions();
            options.setAllowDuplicateKeys(false);
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(Map.class, options));
            ImportMLFlowModelInfo result = new ImportMLFlowModelInfo();
            ZipFile zipFile = new ZipFile(tempPackageArchive);
            try {
                ZipEntry entry = zipFile.getEntry("MLmodel");
                if (entry == null) {
                    logger.trace(() -> "File MLmodel not found within archive " + String.valueOf(tempPackageArchive));
                    throw new IllegalArgumentException("File MLmodel not found within archive " + String.valueOf(tempPackageArchive));
                }
                Map data = (Map)yaml.load(zipFile.getInputStream(entry));
                if (data != null) {
                    UUID uuid = UUID.randomUUID();
                    String id = uuid.toString();
                    try {
                        AutoDelete archive = DSSTempUtils.getTempFile((String)"saved_model", (String)id, (String)"zip");
                        FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)archive);
                        Validate.isTrue((boolean)archive.exists(), (String)("Archive to import does not exist: " + String.valueOf(archive)));
                        Map flavors = (Map)data.get("flavors");
                        result.flavors = flavors.keySet().stream().distinct().collect(Collectors.toList());
                        result.pythonVersion = (String)((Map)flavors.get("python_function")).get("python_version");
                        result.creationDate = (String)data.get("utc_time_created");
                        result.uuid = archive.getName().replaceFirst(".zip", "");
                    }
                    catch (IOException e) {
                        throw new IOException("Unable to extract archive");
                    }
                }
                importMLFlowModelInfo = result;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Unable to extract archive");
                }
            }
            zipFile.close();
            return importMLFlowModelInfo;
        }
    }

    public FutureResponse<InfoMessage.InfoMessages> checkProxyModelEndpoint(AuthCtx authCtx, FullModelId fmi) throws Exception {
        return this.futureService.runFuture(new CheckProxyModelEndpointThread(authCtx, fmi), 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    private static boolean isAvailableSM(EnrichedLLMStructuredRef enrichedRef, AbstractLLMConnection.LLMUsagePurpose purpose) {
        if (enrichedRef == null) {
            return false;
        }
        if (purpose == AbstractLLMConnection.LLMUsagePurpose.FINE_TUNING) {
            return enrichedRef.canBeFinetuned;
        }
        if (purpose == AbstractLLMConnection.LLMUsagePurpose.IMAGE_INPUT) {
            return enrichedRef.supportsImageInputs;
        }
        return true;
    }

    public List<EnrichedLLMStructuredRef> listAvailableSMLLMs(AuthCtx authCtx, String projectKey, AbstractLLMConnection.LLMUsagePurpose purpose) throws IOException, DKUSecurityException {
        if (purpose != null && !purpose.supportedBySavedModelLLMs) {
            return new ArrayList<EnrichedLLMStructuredRef>();
        }
        ArrayList<EnrichedLLMStructuredRef> smLLMList = new ArrayList<EnrichedLLMStructuredRef>();
        for (SavedModel savedModel : this.savedModelsDAO.listUnsafe(projectKey)) {
            try {
                EnrichedLLMStructuredRef enrichedLLMRef = this.llmRefEnricherService.getEnrichedLLMRefFromSM(authCtx, savedModel, projectKey);
                if (!SavedModelsService.isAvailableSM(enrichedLLMRef, purpose)) continue;
                smLLMList.add(enrichedLLMRef);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to add saved model " + savedModel.id + " to available LLMs"), (Throwable)e);
            }
        }
        for (AnyLoc anyLoc : this.projectsService.getExposedSavedModels(projectKey)) {
            SavedModel sm = (SavedModel)this.savedModelsDAO.getOrNull(anyLoc.getProjectKey(), anyLoc.getId());
            try {
                EnrichedLLMStructuredRef enrichedLLMRef = this.llmRefEnricherService.getEnrichedLLMRefFromSM(authCtx, sm, projectKey);
                if (!SavedModelsService.isAvailableSM(enrichedLLMRef, purpose)) continue;
                smLLMList.add(enrichedLLMRef);
            }
            catch (Exception e) {
                logger.warn((Object)("failed to load model " + (sm != null ? sm.id : "")));
            }
        }
        return smLLMList;
    }

    public FullModelId createFinetunedLLMVersion(AuthCtx authCtx, SavedModel sm) throws IOException, DKUSecurityException, InterruptedException {
        if (sm.savedModelType != SavedModel.SavedModelType.LLM_GENERIC) {
            throw new IllegalArgumentException("Can't create a fine-tuned LLM version for saved model type " + String.valueOf((Object)sm.savedModelType));
        }
        String newVersionId = "" + System.currentTimeMillis();
        FullModelId fmi = new FullModelId(sm.projectKey, sm.id, newVersionId);
        logger.info((Object)"Creating saved model folder if needed");
        MLPaths.createIfNeededSavedModelFolderAndRestrictPermissions(sm);
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, MLPaths.savedModelBaseFolder(sm.projectKey, sm.id));
        logger.info((Object)"Creating fine-tuned version folder");
        File modelVersionFolder = fmi.getModelFolder();
        if (DKUFileUtils.exists((File)modelVersionFolder, (String[])new String[0])) {
            throw new IllegalArgumentException("Can't create a fine-tuned LLM version with id " + newVersionId + ", a fine-tuned model folder already exists at " + String.valueOf(modelVersionFolder));
        }
        DKUFileUtils.mkdirs((File)modelVersionFolder);
        FilesystemACLUtils.grantFSFullACLs(authCtx, sm.projectKey, modelVersionFolder);
        ModelTrainInfo mti = new ModelTrainInfo();
        mti.state = ModelTrainInfo.ModelTrainState.PENDING;
        fmi.saveModelTrainInfo(mti);
        this.pubSub.publish((DSSEvent)new ModelVersionCreatedEvent(fmi.toString()));
        return fmi;
    }

    public FullModelId saveFinetunedLLMVersion(AuthCtx authCtx, SavedModel sm, String versionId, String connectionName, FinetuningConfig finetuningConfig) throws IOException, DKUSecurityException, InterruptedException {
        boolean isAdapter;
        HuggingFaceLocalConnection.HuggingFaceHandlingMode hfHandlingMode;
        if (sm.savedModelType != SavedModel.SavedModelType.LLM_GENERIC) {
            throw new IllegalArgumentException("Can't manually save a fine-tuned LLM version of saved model type " + String.valueOf((Object)sm.savedModelType));
        }
        FullModelId fmi = new FullModelId(sm.projectKey, sm.id, versionId);
        if (StringUtils.isBlank((String)connectionName)) {
            throw new IllegalArgumentException("A connection name is required to save a fine-tuned LLM");
        }
        HuggingFaceLocalConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, connectionName, HuggingFaceLocalConnection.class);
        logger.info((Object)"Checking saved model folder");
        File savedModelFolder = MLPaths.savedModelBaseFolder(sm.projectKey, sm.id);
        if (!DKUFileUtils.exists((File)savedModelFolder, (String[])new String[0])) {
            throw new IllegalArgumentException("Can't save fine-tuned LLM, saved model folder does not exist at " + String.valueOf(savedModelFolder));
        }
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, fmi.getFolderEnsuringSecurity());
        logger.info((Object)"Checking fine-tuned LLM folder");
        File modelVersionFolder = fmi.getModelFolder();
        if (!DKUFileUtils.exists((File)modelVersionFolder, (String[])new String[0])) {
            throw new IllegalArgumentException("Can't save fine-tuned LLM, version folder does not exist at " + String.valueOf(modelVersionFolder));
        }
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, modelVersionFolder);
        try {
            hfHandlingMode = HuggingFaceLocalConnection.HuggingFaceHandlingMode.valueOf("TEXT_GENERATION_" + finetuningConfig.promptHandlingMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid prompt handling mode: " + finetuningConfig.promptHandlingMode);
        }
        if (DKUFileUtils.exists((File)modelVersionFolder, (String[])new String[]{"model.safetensors"})) {
            isAdapter = false;
        } else if (DKUFileUtils.exists((File)modelVersionFolder, (String[])new String[]{"adapter_model.safetensors"})) {
            isAdapter = true;
        } else {
            throw new IllegalArgumentException("Can't save fine-tuned LLM, the specified folder " + String.valueOf(modelVersionFolder) + " doesn't contain safetensors files (did fine-tuning fail?)");
        }
        logger.info((Object)("Found " + (isAdapter ? "adapter" : "full") + " fine-tuned model files at " + String.valueOf(modelVersionFolder)));
        logger.info((Object)("Saved fine-tuned LLM version \"" + versionId + "\" for saved model \"" + sm.id));
        LLMSavedModelInfo llmSmi = new LLMSavedModelInfo();
        llmSmi.llmType = LLMStructuredRef.LLMType.SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER;
        llmSmi.connection = connectionName;
        llmSmi.wasFinetunedUsingPythonRecipe = true;
        llmSmi.trainingDataset = finetuningConfig.trainingDataset;
        llmSmi.validationDataset = finetuningConfig.validationDataset;
        llmSmi.promptColumn = finetuningConfig.promptColumn;
        llmSmi.completionColumn = finetuningConfig.completionColumn;
        llmSmi.userMessageColumn = finetuningConfig.userMessageColumn;
        llmSmi.assistantMessageColumn = finetuningConfig.assistantMessageColumn;
        llmSmi.systemMessageColumn = finetuningConfig.systemMessageColumn;
        llmSmi.staticSystemMessage = finetuningConfig.staticSystemMessage;
        llmSmi.batchSize = finetuningConfig.batchSize;
        llmSmi.neftuneNoiseAlpha = finetuningConfig.neftuneNoiseAlpha;
        llmSmi.initialLearningRate = finetuningConfig.initialLearningRate;
        llmSmi.nbEpochs = finetuningConfig.nbEpochs;
        llmSmi.totalSteps = finetuningConfig.totalSteps;
        llmSmi.codeEnv = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, finetuningConfig.codeEnvName);
        if (llmSmi.codeEnv.envName != null && !llmSmi.codeEnv.envName.equals(connection.params.getCodeEnvName())) {
            logger.warn((Object)("The code env used to fine-tune the model (" + llmSmi.codeEnv.envName + ") is different from the code env that will be used to run the model (" + connection.params.getCodeEnvName() + "), please make sure Python packages are compatible"));
        }
        if (finetuningConfig.quantization != null) {
            llmSmi.quantizationMode = HuggingFaceLocalConnection.HuggingFaceLocalConnectionParams.QuantizationMode.valueOf(finetuningConfig.quantization);
        }
        if (isAdapter) {
            config = fmi.parseModelFile(TransformersFinetunedModelAdapterConfig.filename, TransformersFinetunedModelAdapterConfig.class);
            if (((TransformersFinetunedModelAdapterConfig)config).base_model_name_or_path == null) {
                throw new IllegalArgumentException("Base model name or path not found in adapter_config.json");
            }
            llmSmi.loraRank = ((TransformersFinetunedModelAdapterConfig)config).r;
            llmSmi.loraAlpha = ((TransformersFinetunedModelAdapterConfig)config).lora_alpha;
            llmSmi.loraDropout = ((TransformersFinetunedModelAdapterConfig)config).lora_dropout;
            llmSmi.inputLLMId = LLMStructuredRef.forHuggingFaceLocalModel((String)connectionName, (String)((TransformersFinetunedModelAdapterConfig)config).base_model_name_or_path).id;
        } else {
            config = fmi.parseModelFile(TransformersFinetunedModelConfig.filename, TransformersFinetunedModelConfig.class);
            if (((TransformersFinetunedModelConfig)config)._name_or_path == null) {
                throw new IllegalArgumentException("Base model name or path not found in config.json");
            }
            llmSmi.inputLLMId = LLMStructuredRef.forHuggingFaceLocalModel((String)connectionName, (String)((TransformersFinetunedModelConfig)config)._name_or_path).id;
        }
        llmSmi.originalLLMId = llmSmi.inputLLMId;
        llmSmi.originalLLMIsUnreferenced = true;
        llmSmi.huggingFaceHandlingMode = hfHandlingMode;
        fmi.saveLLMInfo(llmSmi);
        Optional<ModelTrainInfo> mti = fmi.getTrainModelInfo();
        if (mti.isEmpty()) {
            mti = Optional.of(new ModelTrainInfo());
        }
        fmi.saveModelTrainInfo(mti.get());
        ModelUserMeta mum = new ModelUserMeta();
        mum.name = "Custom Huggingface fine-tuned model - v" + sm.lastTrainIndex;
        fmi.saveUserMeta(mum);
        this.pubSub.publish((DSSEvent)new ModelVersionChangedEvent(fmi.toString()));
        logger.info((Object)"Fine-tuned LLM saved");
        return fmi;
    }

    public void deleteFinetunedLLMVersion(SavedModel sm, String versionId) throws IOException {
        if (sm.savedModelType != SavedModel.SavedModelType.LLM_GENERIC) {
            throw new IllegalArgumentException("Can't delete a fine-tuned version for saved model type " + String.valueOf((Object)sm.savedModelType));
        }
        FullModelId fmi = new FullModelId(sm.projectKey, sm.id, versionId);
        File modelVersionFolder = fmi.getModelFolder();
        if (!DKUFileUtils.exists((File)modelVersionFolder, (String[])new String[0])) {
            logger.warn((Object)("Fine-tuned version folder doesn't exist at " + String.valueOf(modelVersionFolder) + ", nothing to delete"));
            return;
        }
        this.pubSub.publishAfterTransaction((DSSEvent)new ModelVersionDeletedEvent(fmi.toString()));
        logger.info((Object)"Deleting fine-tuned version folder");
        DKUFileUtils.deleteDirectory((File)modelVersionFolder);
    }

    public class CheckProxyModelEndpointThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private final FullModelId fmi;

        public CheckProxyModelEndpointThread(AuthCtx authCtx, FullModelId fmi) {
            super(authCtx);
            this.fmi = fmi;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = FuturePayload.newSimple((String)"check_proxy_model_endpoint", (String)"Check that the remote endpoint matches the info stored in Proxy SMV");
            fp.targets.add(new FuturePayload.FuturePayloadTarget(this.fmi.getProjectKey(), this.fmi.toString(), this.fmi.toString(), null));
            return fp;
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            ProxyModelVersionConfiguration.ConsolidatedEndpointInfo consolidatedEndpointInfo;
            MLFlowModelVersionInfo mlFlowImportedModelMetadata = this.fmi.getMLflowImportedModelMetadata();
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            if (!mlFlowImportedModelMetadata.isProxyModel()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Invalid external model configuration", "Invalid external model configuration."));
                return ret;
            }
            if (null == mlFlowImportedModelMetadata.proxyModelEndpointInfo) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, "No information", "No information was collected when creating this saved model version"));
                return ret;
            }
            if (mlFlowImportedModelMetadata.proxyModelEndpointInfo instanceof ProxyModelVersionConfiguration.ErrorEndpointInfo) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "No information", "It is not possible to check since there was an error during the creation of the saved model version, you will need to recreate the model version."));
                return ret;
            }
            try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Retrieving info on remote endpoint");){
                consolidatedEndpointInfo = mlFlowImportedModelMetadata.proxyModelVersionConfiguration.getConsolidatedEndpointInfo_NT(this.owner);
            }
            if (consolidatedEndpointInfo == null) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Endpoint information unreachable", "Unable to retrieve remote endpoint info."));
                return ret;
            }
            logger.debugV("Retrieved consolidated endpoint info %s with configuration%s", new Object[]{JSON.json((Object)consolidatedEndpointInfo), JSON.json((Object)mlFlowImportedModelMetadata.proxyModelVersionConfiguration)});
            ret = mlFlowImportedModelMetadata.proxyModelEndpointInfo.computeDifferences(consolidatedEndpointInfo);
            ret.summarize();
            return ret;
        }
    }

    public static class FinetuningConfig {
        String trainingDataset;
        String validationDataset;
        String promptColumn;
        String completionColumn;
        String userMessageColumn;
        String assistantMessageColumn;
        String systemMessageColumn;
        String staticSystemMessage;
        String promptHandlingMode;
        Integer batchSize;
        Double neftuneNoiseAlpha;
        Double initialLearningRate;
        Integer nbEpochs;
        Integer totalSteps;
        String codeEnvName;
        String quantization;
    }

    private static class TransformersFinetunedModelAdapterConfig {
        static String filename = "adapter_config.json";
        public Integer r;
        public Integer lora_alpha;
        public Double lora_dropout;
        public String base_model_name_or_path;

        private TransformersFinetunedModelAdapterConfig() {
        }
    }

    private static class TransformersFinetunedModelConfig {
        static String filename = "config.json";
        public String _name_or_path;

        private TransformersFinetunedModelConfig() {
        }
    }

    public abstract class ExternalModelDeployFutureThread
    extends SimpleFutureThread<MLflowModelDeployResult> {
        private final String projectKey;
        private final String savedModelId;
        private final String savedModelTypeLabel;
        private final AuthCtx authCtx;
        private final MLFlowModelVersionInfo modelVersionInfo;
        private final String versionId;
        private final boolean activateVersion;
        private final StreamableDatasetSelection streamableDatasetSelection;
        private final boolean useOptimalThreshold;
        private final boolean skipExpensiveReports;

        public ExternalModelDeployFutureThread(AuthCtx authCtx, String savedModelTypeLabel, String projectKey, String savedModelId, MLFlowModelVersionInfo modelVersionInfo, String versionId, boolean activateVersion, StreamableDatasetSelection streamableDatasetSelection, boolean useOptimalThreshold, boolean skipExpensiveReports) {
            super(authCtx);
            this.authCtx = authCtx;
            this.savedModelTypeLabel = savedModelTypeLabel;
            this.projectKey = projectKey;
            this.savedModelId = savedModelId;
            this.modelVersionInfo = modelVersionInfo;
            this.versionId = versionId;
            this.activateVersion = activateVersion;
            this.streamableDatasetSelection = streamableDatasetSelection;
            this.useOptimalThreshold = useOptimalThreshold;
            this.skipExpensiveReports = skipExpensiveReports;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = FuturePayload.newSimple((String)"deploy_mlflow_model", (String)("Deploy a " + this.savedModelTypeLabel + " Model"));
            fp.targets.add(new FuturePayload.FuturePayloadTarget(this.projectKey, this.savedModelId, this.savedModelId, null));
            return fp;
        }

        @Override
        protected MLflowModelDeployResult compute() throws Exception {
            RWTransaction t;
            FullModelId fmi;
            SavedModel sm;
            try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)("Fetching " + this.savedModelTypeLabel + " Saved Model"));
                 Transaction t2 = SavedModelsService.this.transactionService.beginRead();){
                sm = (SavedModel)SavedModelsService.this.savedModelsDAO.getMandatoryUnsafe(this.projectKey, this.savedModelId);
                if (sm.savedModelType.savedModelHandlingType != SavedModel.SavedModelHandlingType.EXTERNAL_MLFLOW) {
                    throw new IllegalArgumentException("Saved model " + this.projectKey + "." + this.savedModelId + " has handling type " + String.valueOf((Object)sm.savedModelType.savedModelHandlingType) + ". Required handling type is " + String.valueOf((Object)SavedModel.SavedModelHandlingType.EXTERNAL_MLFLOW) + ".");
                }
            }
            ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forSavedMLOperation((AuthCtx)this.authCtx, (String)this.projectKey, (String)this.savedModelId, (String)this.versionId);
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
            ContainerExecSelection containerExecSelection = this.getContainerExecSelection();
            try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)("Creating " + this.savedModelTypeLabel + " Saved Model Version"));){
                fmi = this.createSavedModelVersion_NT(sm);
            }
            MLFlowModelVersionInfo mvi = this.getModelVersionInfo(fmi);
            try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)this.getInferSignatureStepMessage());){
                String activeVersion = this.versionId;
                if (!this.activateVersion) {
                    activeVersion = sm.getActiveVersion();
                }
                boolean changed = !StringUtils.equals((String)sm.activeVersion, (String)this.versionId);
                t = SavedModelsService.this.transactionService.beginWriteAsLoggedInUser(this.authCtx);
                try {
                    ++sm.lastTrainIndex;
                    if (changed) {
                        SavedModelsService.this.psmmService.setActive(sm, this.versionId);
                        t.commit("Made version " + this.versionId + " of saved model " + sm.id + " active");
                    } else {
                        SavedModelsService.this.savedModelsCRUDService.save(sm, false, false);
                        t.commit("Overwrote version " + this.versionId + " of saved model " + sm.id);
                    }
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
                SavedModelsService.this.mlflowModelOperationsService.setSignatureAndFormats(this.authCtx, fmi, mvi, containerExecSelection);
            }
            if (StringUtils.isNotEmpty((String)this.modelVersionInfo.evaluationDatasetSmartName) && this.modelVersionInfo.predictionType != null) {
                fp = FutureProgress.pushAutoCloseableState((String)"Evaluating performances and saving metrics");
                try {
                    SavedModelsService.this.mlflowModelOperationsService.evaluate(this.authCtx, fmi, this.modelVersionInfo.evaluationDatasetSmartName, containerExecSelection, this.streamableDatasetSelection, this.useOptimalThreshold, this.skipExpensiveReports);
                }
                finally {
                    if (fp != null) {
                        fp.close();
                    }
                }
                HashMap metricValues = Maps.newHashMap();
                Partition partition = MetricsComputationService.fakeSMVersionPartition(fmi.getSavedModelVersionID());
                SavedModelsService.this.metricsComputationService.scoopSavedModelMetrics(sm, partition, metricValues);
                MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
                environment.startedFromBuild = false;
                t = SavedModelsService.this.transactionService.beginWriteAsLoggedInUser(this.authCtx);
                try {
                    GeneralSettingsDAO.GeneralSettings generalSettings = SavedModelsService.this.generalSettingsDAO.read();
                    environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
                    environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
                    SavedModelsService.this.metricsComputationService.saveMetricsValues(this.authCtx, sm, MetricTargetType.SAVED_MODEL, partition, DateTime.now(), metricValues, environment);
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            }
            MLflowModelDeployResult ret = new MLflowModelDeployResult();
            ret.fullModelId = fmi.toString();
            ret.smId = sm.id;
            return ret;
        }

        private MLFlowModelVersionInfo getModelVersionInfo(FullModelId fullModelId) throws IOException {
            MLFlowModelVersionInfo mvi;
            try (Transaction t = SavedModelsService.this.transactionService.beginRead();){
                mvi = fullModelId.getMLflowImportedModelMetadata();
                mvi.evaluationDatasetSmartName = this.modelVersionInfo.evaluationDatasetSmartName;
                mvi.gatherFeaturesFromDataset = this.modelVersionInfo.gatherFeaturesFromDataset;
                mvi.signatureAndFormatsGuessingDataset = this.modelVersionInfo.signatureAndFormatsGuessingDataset;
                mvi.inputFormat = this.modelVersionInfo.inputFormat;
                mvi.outputFormat = this.modelVersionInfo.outputFormat;
                mvi.classLabels = this.modelVersionInfo.classLabels;
                mvi.targetColumnName = this.modelVersionInfo.targetColumnName;
                mvi.useUnityCatalog = this.modelVersionInfo.useUnityCatalog;
                mvi.fromDatabricksConnection = this.modelVersionInfo.fromDatabricksConnection;
                mvi.fromDatabricksModelName = this.modelVersionInfo.fromDatabricksModelName;
            }
            return mvi;
        }

        public abstract ContainerExecSelection getContainerExecSelection();

        public abstract FullModelId createSavedModelVersion_NT(SavedModel var1) throws Exception;

        public abstract String getInferSignatureStepMessage() throws Exception;
    }
}

