/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.VariablesUpdateRunner;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RunGlobalVariablesUpdate
implements StepRunner {
    @Autowired
    private IPermissionsService permissionsService;
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return UpdateVariablesStepParams.class;
        }

        @Override
        public String getType() {
            return "run_global_vars_update";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new RunGlobalVariablesUpdate(step.getParamsAs(UpdateVariablesStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            UpdateVariablesStepParams params = step.getParamsAs(UpdateVariablesStepParams.class);
            return "Run global variables update  " + (StringUtils.isBlank((String)params.updateCode) ? "(std code)" : "(custom code)");
        }

        @Override
        public String buildId(Step step) {
            UpdateVariablesStepParams params = step.getParamsAs(UpdateVariablesStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("run_global_vars_update");
            if (params != null) {
                sb.append("_");
                if (StringUtils.isBlank((String)params.updateCode)) {
                    sb.append("std_code");
                } else {
                    sb.append("custom_code_");
                    sb.append(DKUtils.md5Base64((String)params.updateCode));
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private TransactionService transactionService;
    private final UpdateVariablesStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.updateglobal vars");

    public RunGlobalVariablesUpdate(UpdateVariablesStepParams params) {
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        DSSAuthCtx runAsUser = stepRun.getScenarioRun().getRunAsUser();
        if (!this.permissionsService.isAdmin(runAsUser)) {
            throw new Exception("User '" + runAsUser.getIdentifier() + "' has insufficient rights to update global variables.");
        }
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)runAsUser);){
            VariablesUpdateRunner vur = new VariablesUpdateRunner();
            if (!StringUtils.isBlank((String)this.params.updateCode)) {
                logger.info((Object)"Updating global variables using the scenario's code");
                vur.doUpdate((RWTransactionRef)t, this.params.updateCode);
            } else {
                logger.info((Object)"Updating global variables using the global settings' code");
                vur.doUpdate((RWTransactionRef)t);
            }
            t.commit("Executed code-based refresh of global variables");
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    public static class UpdateVariablesStepParams
    implements StepParams {
        public String updateCode;
    }
}

