/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.MarkupFormattersService;
import com.dataiku.dip.server.notifications.NoLinkMarkupFormatter;
import com.dataiku.dip.server.notifications.backend.CommitMentionEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommitMentionsService {
    @Autowired
    private MarkupFormattersService linksService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private IPermissionsService permService;
    private static Logger logger = Logger.getLogger((String)"dku.notifications.mentions");

    @PostConstruct
    public void init() {
        this.pubSubService.subscribe("commit-mention", (DSSEventListener)new DSSEventListener<CommitMentionEvent>(){

            public void on(CommitMentionEvent evt) throws IOException {
                String mentionedUser = evt.getUserLogin();
                boolean sendEmail = false;
                try (Transaction t = CommitMentionsService.this.transactionService.beginRead();){
                    UserSettingsService.UserSettings usersSettings = CommitMentionsService.this.userSettingsService.getForUser(mentionedUser);
                    if (!mentionedUser.equals(evt.author) && CommitMentionsService.this.isAuthorised(mentionedUser, evt.projectKey) && usersSettings != null && usersSettings.mentionEmails.enabled) {
                        sendEmail = true;
                    }
                }
                if (sendEmail) {
                    try {
                        CommitMentionsService.this.sendToUser(evt);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to send mail to " + mentionedUser + " for mention"), (Throwable)e);
                    }
                }
            }
        });
    }

    private boolean isAuthorised(String user, String projectKey) {
        try {
            AuthCtx authCtx = this.authCtxCreationService.create(user);
            return this.permService.hasAnyProjectAccess(authCtx, projectKey);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get user permissions", (Throwable)e);
            return false;
        }
    }

    private void sendToUser(UserEvent evt) throws Exception {
        PublicUser pu;
        try (Transaction t = this.transactionService.beginRead();){
            pu = this.usersService.getPublicUser(evt.getUserLogin());
        }
        if (pu.email == null) {
            return;
        }
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        MarkupFormatter links = this.linksService.getMarkupFormatter(Markup.HTML);
        logger.info((Object)("Sending mention email to " + pu.login));
        if (!(evt instanceof CommitMentionEvent)) {
            throw new Error("Unreachable");
        }
        CommitMentionEvent me = (CommitMentionEvent)evt;
        params.subject = this.makeEMailSubject(me);
        String body = this.makeBody(me, links);
        EmailNotificationsSender sender = new EmailNotificationsSender();
        sender.sendToUser(pu.email, params, body);
    }

    private String makeEMailSubject(CommitMentionEvent evt) {
        return "Dataiku \u2022 " + evt.getSummaryString(new NoLinkMarkupFormatter(Markup.PLAIN_TEXT, new ArrayList<UsersDAO.User>()));
    }

    private String makeBody(CommitMentionEvent evt, MarkupFormatter links) throws Exception {
        return evt.toHumanReadableString(links);
    }
}

