/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.emails.TemplateVariableLookup;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;

public class MessageContentBuilder {
    private Configuration config;
    private VariableLookup lookup;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.notifications.emails");

    public MessageContentBuilder(VariableLookup lookup) {
        this.lookup = lookup;
        this.config = new Configuration();
        this.config.setNewBuiltinClassResolver(TemplateClassResolver.ALLOWS_NOTHING_RESOLVER);
        this.config.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String arg0) {
                throw new RuntimeException("Forbidden");
            }
        });
    }

    public String buildWithFormula(TemplatedContent templatedContent) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)templatedContent.message)) {
            return "";
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Substituting template with formula: " + templatedContent.message));
        }
        StringSubstitutor substitutor = new StringSubstitutor((StringLookup)this.lookup);
        substitutor.setEnableUndefinedVariableException(true);
        return substitutor.replace(templatedContent.message);
    }

    public String buildWithFreemarker(TemplatedContent templatedContent) throws IOException, TemplateException {
        if (StringUtils.isBlank((String)templatedContent.message)) {
            return "";
        }
        logger.info((Object)"Build template with freemarker");
        StringReader reader = new StringReader(templatedContent.message);
        Template template = new Template("tmpl0", (Reader)reader, this.config);
        TemplateVariableLookup tlookup = new TemplateVariableLookup(this.lookup);
        StringWriter swr = new StringWriter();
        template.process((Object)tlookup, (Writer)swr);
        return swr.toString();
    }

    public ExpandedTemplate buildMessage(TemplatedContent templatedContent, File templateFile) throws IOException, TemplateException {
        ExpandedTemplate et = new ExpandedTemplate();
        if (templateFile != null) {
            logger.info((Object)("Build template from file " + templateFile.getAbsolutePath()));
            templatedContent.message = FileUtils.readFileToString((File)templateFile, (Charset)StandardCharsets.UTF_8);
            String[] lines = StringUtils.split((String)templatedContent.message, (char)'\n');
            if (lines.length > 0 && lines[0].contains("html:true")) {
                et.forceSendAsHTML = true;
            }
            if (templateFile.getName().endsWith(".dtl")) {
                templatedContent.templateFormat = TemplatedContent.TemplateFormat.FORMULA;
            } else if (templateFile.getName().endsWith(".ftl")) {
                templatedContent.templateFormat = TemplatedContent.TemplateFormat.FREEMARKER;
            } else {
                throw ErrorContext.iaef((String)"Invalid template file %s", (Object)templateFile, (Object[])new Object[0]);
            }
        }
        switch (templatedContent.templateFormat) {
            case FORMULA: {
                et.message = this.buildWithFormula(templatedContent);
                break;
            }
            case FREEMARKER: {
                et.message = this.buildWithFreemarker(templatedContent);
                break;
            }
            default: {
                throw new Error("Unreachable");
            }
        }
        return et;
    }

    public static class ExpandedTemplate {
        public String message;
        public boolean forceSendAsHTML;
    }
}

