/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class Geocoder {
    protected String apiKey;
    private Cache<String, Coord> cache = CacheBuilder.newBuilder().maximumSize(200000L).build();
    protected static Logger logger = Logger.getLogger((String)"dku.shaker.geocoder");

    protected void fillCache(LinkedHashSet<String> queries, List<Coord> coords) {
        assert (queries.size() == coords.size());
        int i = 0;
        for (String q : queries) {
            Coord c2 = coords.get(i);
            assert (c2 != null);
            this.cache.put((Object)q, (Object)c2);
            ++i;
        }
    }

    protected abstract List<Coord> callAPI(LinkedHashSet<String> var1) throws Exception;

    public void setAPIKey(String apiKey) {
        this.apiKey = apiKey;
    }

    protected abstract int getLimit();

    public Coord getCached(String query) {
        return (Coord)this.cache.getIfPresent((Object)query);
    }

    public static class Coord {
        public boolean found;
        public double lat;
        public double lon;
        public Granularity granularity;

        public Coord() {
        }

        public Coord(double lat, double lon, Granularity granularity) {
            this.found = true;
            this.granularity = granularity;
            this.lat = lat;
            this.lon = lon;
        }
    }

    public static enum Granularity {
        COUNTRY,
        STATE,
        CITY,
        STREET,
        POINT;

    }
}

