/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time;

import com.dataiku.dip.shaker.text.Labelled;
import java.io.StringWriter;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Language implements Labelled
{
    auto{

        @Override
        public String getLabel() {
            return "Translate automatically";
        }

        @Override
        public Locale toLocale() {
            return Locale.US;
        }
    }
    ,
    fr_FR{

        @Override
        public String getLabel() {
            return "fr_FR";
        }
    }
    ,
    en_US{

        @Override
        public String getLabel() {
            return "en_US";
        }
    };


    public Locale toLocale() {
        try {
            return LocaleUtils.toLocale((String)this.name());
        }
        catch (IllegalArgumentException e) {
            StringWriter writer = new StringWriter();
            writer.write("Could not find local " + this.name() + ".\n");
            writer.write("The following are available : ");
            writer.write(StringUtils.join((Object[])Locale.getAvailableLocales(), (String)", "));
            throw new IllegalArgumentException(writer.toString(), e);
        }
    }
}

