/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class DenodoSQLDialect
extends GenericSQLDialect {
    private static Pattern CAST_AS_TSTZ_PATTERN = Pattern.compile(".*as +timestamp[ )]+at +time +zone +'[^']+'[ )]+$");

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public int getIdentifiersMaxLength() {
        return -1;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return -1;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case STRING: {
                if (schemaColumn.maxLength <= 0) {
                    return new DSSTypeSQLMapping(Type.STRING, 12, "text", new Integer[]{2003, 1, 1111, -16, -1, -9, 92});
                }
                return new DSSTypeSQLMapping(Type.STRING, 12, "varchar(" + schemaColumn.getMaxLength() + ")", new Integer[]{2003, 1, 1111, -16, -1, -9, 92});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "double precision", new Integer[]{7, 2, 3});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 2014, "timestamp with time zone", new Integer[]{93, 91});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93, 2014});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "timestamp", new Integer[]{91, 2014});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        if (sqlType == 2014) {
            return new SchemaColumn(name, Type.DATE);
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return "timestamp".equalsIgnoreCase(sqlTypeName);
    }

    @Override
    public boolean requiresStrictTypeComparison() {
        return true;
    }

    @Override
    public String getColumnExpressionForBoolean(String expr) {
        return "CASE WHEN " + expr + " THEN true ELSE false END";
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addGenericFunction(QueryUtils.OperatorType.LENGTH, "LEN", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CAST_BOOL_TO_COLUMN, "CAST", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return DenodoSQLDialect.this.getColumnExpressionForBoolean(this.toSQLNoBrackets(args[0]));
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.GREATEST, "MAX", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs > 0;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                List funcArgs = Lists.newArrayList((Object[])args).stream().map(this::toSQLNoBrackets).collect(Collectors.toList());
                String greatest = "MAX(" + String.join((CharSequence)", ", funcArgs) + ")";
                List nullableArgs = Lists.newArrayList((Object[])args).stream().filter(a -> !(a instanceof QueryAst.ConstExpr) || ((QueryAst.ConstExpr)a).value == null).collect(Collectors.toList());
                if (nullableArgs.isEmpty()) {
                    return greatest;
                }
                return "CASE WHEN " + nullableArgs.stream().map(a -> "(" + this.toSQLNoBrackets((QueryAst.Expr)a) + ") IS NULL").collect(Collectors.joining(" OR ")) + " THEN NULL ELSE " + greatest + " END";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LEAST, "MIN", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs > 0;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                List funcArgs = Lists.newArrayList((Object[])args).stream().map(this::toSQLNoBrackets).collect(Collectors.toList());
                String least = "MIN(" + String.join((CharSequence)", ", funcArgs) + ")";
                List nullableArgs = Lists.newArrayList((Object[])args).stream().filter(a -> !(a instanceof QueryAst.ConstExpr) || ((QueryAst.ConstExpr)a).value == null).collect(Collectors.toList());
                if (nullableArgs.isEmpty()) {
                    return least;
                }
                return "CASE WHEN " + nullableArgs.stream().map(a -> "(" + this.toSQLNoBrackets((QueryAst.Expr)a) + ") IS NULL").collect(Collectors.joining(" OR ")) + " THEN NULL ELSE " + least + " END";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NOT, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.NOT.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String arg1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.NOT.priority);
                return "NOT " + arg1;
            }
        });
        this.addOperator(this.hashingOperator(QueryUtils.OperatorType.MD5, "md5"));
        this.addOperator(this.hashingOperator(QueryUtils.OperatorType.SHA256, "sha256"));
        this.addOperator(this.hashingOperator(QueryUtils.OperatorType.SHA512, "sha512"));
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(this, QueryUtils.OperatorType.INDEX_OF, "(INSTR(", ", COALESCE(", ", '')))", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(this, QueryUtils.OperatorType.STARTS_WITH, "STARTWITH", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(this, QueryUtils.OperatorType.ENDS_WITH, "ENDWITH", false));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_REPLACE, "REGEXP", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                String replacement = this.toSQLNoBrackets(args[2]);
                return "REGEXP(" + column + ", " + regex + ", " + replacement + ")";
            }
        });
        this.removeOperator(QueryUtils.OperatorType.REGEXP_SUBSTR);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "PERCENTILE_CONT(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ") OVER ()";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_WIN, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "PERCENTILE_DISC(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ") OVER ()";
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "CAST(CONCAT(", ", '+00:00') AS TIMESTAMP WITH TIME ZONE)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_DATE, "CAST(", " AS DATE)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "CAST(", " AS TIMESTAMP)"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinMaxNumberOfParameters(args, 1, 3);
                if (args.length == 3) {
                    return String.format("CONVERT_TIMEZONE('UTC', CONVERT_TIMEZONE(%s, %s))", this.toSQLNoBrackets(args[1]), this.toSQLNoBrackets(args[0]));
                }
                if (args.length == 2) {
                    return String.format("CONVERT_TIMEZONE(%s, CAST(%s AS TIMESTAMP))", this.toSQLNoBrackets(args[1]), this.toSQLNoBrackets(args[0]));
                }
                assert (args.length == 1);
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE_NTZ, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinMaxNumberOfParameters(args, 1, 2);
                if (args.length == 2) {
                    return String.format("CONVERT_TIMEZONE(%s, CAST(%s AS TIMESTAMP))", this.toSQLNoBrackets(args[1]), this.toSQLNoBrackets(args[0]));
                }
                assert (args.length == 1);
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type requestedType;
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                if (args[0].outputType != null && args[0].outputType.dssType != Type.STRING) {
                    input = "CAST(" + (String)input + " AS VARCHAR)";
                }
                if ((requestedType = this.getParamAs(args[1], Type.class)).isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    Locale locale = args.length > 3 ? this.getParamAs(args[3], Locale.class) : Locale.US;
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = DenodoSQLDialect.this.toDateFormat(jodaFormat, true);
                    boolean specifiesTimezone = false;
                    for (DKUDateUtils.FormatPatternPart part : DKUDateUtils.parsePattern((String)jodaFormat, (boolean)true)) {
                        specifiesTimezone = part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE;
                    }
                    String i18nParam = "";
                    if (StringUtils.equals((String)"fr_FR", (String)locale.toString()) || StringUtils.equals((String)"fr", (String)locale.toString())) {
                        i18nParam = ", 'fr'";
                    }
                    if (requestedType == Type.DATEONLY) {
                        return "TO_LOCALDATE('" + sqlFormat + "'," + (String)input + i18nParam + ")";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "TO_TIMESTAMP('" + sqlFormat + "', " + (String)input + i18nParam + ")";
                    }
                    String converted = specifiesTimezone ? "TO_TIMESTAMPTZ('" + sqlFormat + "', " + (String)input + i18nParam + ")" : "TO_TIMESTAMP('" + sqlFormat + "', " + (String)input + i18nParam + ") AT TIME ZONE 'UTC'";
                    if (StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return converted;
                    }
                    return "CONVERT_TIMEZONE('" + timezoneId + "', CONVERT_TIMEZONE('UTC', " + converted + "))";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Locale locale;
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                Locale locale2 = locale = args.length > 3 ? this.getParamAs(args[3], Locale.class) : Locale.US;
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String i18nParam = "";
                    if (StringUtils.equals((String)"fr_FR", (String)locale.toString()) || StringUtils.equals((String)"fr", (String)locale.toString())) {
                        i18nParam = ", 'fr'";
                    }
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    if (requestedType == Type.DATE) {
                        String timezoneId = args.length > 4 ? StringUtils.defaultIfBlank((String)this.getParamAs(args[4], String.class), (String)"UTC") : "UTC";
                        input = "(" + (String)input + " AT TIME ZONE '" + timezoneId + "')";
                    }
                    String sqlFormat = DenodoSQLDialect.this.toDateFormat(jodaFormat, false);
                    return "FORMATDATE('" + sqlFormat + "', " + (String)input + i18nParam + ")";
                }
                throw new NotImplementedException("format as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                if ("DAY".equalsIgnoreCase(unit)) {
                    return "ADDDAY(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("WEEK".equalsIgnoreCase(unit)) {
                    return "ADDWEEK(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("HOUR".equalsIgnoreCase(unit)) {
                    return "ADDHOUR(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("MINUTE".equalsIgnoreCase(unit)) {
                    return "ADDMINUTE(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("SECOND".equalsIgnoreCase(unit)) {
                    return "ADDSECOND(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("MONTH".equalsIgnoreCase(unit)) {
                    return "ADDMONTH(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("YEAR".equalsIgnoreCase(unit)) {
                    return "ADDYEAR(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                throw new NotImplementedException("cannot add " + unit);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Object end = this.toSQLNoBrackets(args[0]);
                Object start = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                Type type = Type.DATE;
                if (args[0].outputType != null && args[0].outputType.dssType != null) {
                    type = args[0].outputType.dssType;
                }
                if (type == Type.DATE) {
                    start = "(" + (String)start + " AT TIME ZONE 'UTC')";
                    end = "(" + (String)end + " AT TIME ZONE 'UTC')";
                }
                switch (unit) {
                    case "YEAR": 
                    case "MONTH": {
                        String monthBetween = "GETMONTHSBETWEEN(" + (String)start + ", " + (String)end + ")";
                        String dayCmp = "GETDAY(" + (String)start + ") = GETDAY(" + (String)end + ")";
                        String startRemainder = "CAST((" + (String)start + ") AS TIME)";
                        String endRemainder = "CAST((" + (String)end + ") AS TIME)";
                        String positiveRemainder = " WHEN " + monthBetween + " > 0 AND " + dayCmp + " AND " + endRemainder + " < " + startRemainder + " THEN -1 ";
                        String negativeRemainder = " WHEN " + monthBetween + " < 0 AND " + dayCmp + " AND " + endRemainder + " > " + startRemainder + " THEN 1 ";
                        String remainder = "CASE " + positiveRemainder + negativeRemainder + " ELSE 0 END";
                        String fullMonthBetween = monthBetween + " + " + remainder;
                        if ("YEAR".equalsIgnoreCase(unit)) {
                            return "TRUNC((" + fullMonthBetween + ") / 12)";
                        }
                        return "(" + fullMonthBetween + ")";
                    }
                    case "WEEK": {
                        return "TRUNC((GETTIMEINMILLIS(" + (String)end + ") - GETTIMEINMILLIS(" + (String)start + "))/604800000)";
                    }
                    case "DAY": {
                        return "TRUNC((GETTIMEINMILLIS(" + (String)end + ") - GETTIMEINMILLIS(" + (String)start + "))/86400000)";
                    }
                    case "HOUR": {
                        return "TRUNC((GETTIMEINMILLIS(" + (String)end + ") - GETTIMEINMILLIS(" + (String)start + "))/3600000)";
                    }
                    case "MINUTE": {
                        return "TRUNC((GETTIMEINMILLIS(" + (String)end + ") - GETTIMEINMILLIS(" + (String)start + "))/60000)";
                    }
                    case "SECOND": {
                        return "TRUNC((GETTIMEINMILLIS(" + (String)end + ") - GETTIMEINMILLIS(" + (String)start + "))/1000)";
                    }
                }
                throw new QueryUtils.SQLGenerationException("Unknown datepart: '" + unit + "'");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NOW, QueryUtils.Arity.NO_ARG){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return "(CURRENT_TIMESTAMP)";
            }
        });
    }

    private QueryUtils.Function hashingOperator(QueryUtils.OperatorType operatorType, final String functionName) {
        return new QueryUtils.Function(this, operatorType, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "LOWER(HASH_FUNCTION(" + column + ", '" + functionName + "'))";
            }
        };
    }

    @Override
    public String getLogClause(double base, String argument) {
        return "LOG(" + argument + ", " + base + ")";
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.NestedMultiLineCommentFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.EscapedStringLiteralFinder.META};
    }

    @Override
    public boolean supportsFromTimezoneNtzOperator() {
        return true;
    }

    @Override
    public String quoteDate(String str) {
        return String.format("(CAST(%s AS TIMESTAMP) AT TIME ZONE 'UTC')", this.quoteString(str));
    }

    @Override
    public String quoteDateOnly(String str) {
        return String.format("CAST(%s AS DATE)", this.quoteString(str));
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return String.format("CAST(%s AS TIMESTAMP)", this.quoteString(str));
    }

    private boolean sniffDatetimeTz(String expr) {
        return expr != null && CAST_AS_TSTZ_PATTERN.matcher(expr).matches();
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.DATE) {
            if (exprType == Type.DATEONLY) {
                return "(CAST( (" + expr + ") AS TIMESTAMP) AT TIME ZONE 'UTC')";
            }
            if (exprType == Type.DATETIMENOTZ) {
                return "( (" + expr + ") AT TIME ZONE 'UTC')";
            }
            if (exprType == Type.DATE) {
                return expr;
            }
            if (exprType != null) {
                return "(CAST( (" + expr + ") AS TIMESTAMP) AT TIME ZONE 'UTC')";
            }
            if (this.sniffDatetimeTz(expr)) {
                return expr;
            }
            return super.cast(expr, exprType, requestedType, maxLength);
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        return "(" + this.temporalTrunc("(" + inputDateExpression + ") AT TIME ZONE 'UTC'", rounding, true) + ") AT TIME ZONE 'UTC'";
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, false);
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, true);
    }

    private String temporalTrunc(String exp, DateRounding rounding, boolean canTime) {
        switch (rounding) {
            case DAY: {
                return "TRUNC(" + exp + ", 'DD')";
            }
            case WEEK: {
                return "TRUNC(" + exp + ", 'IW')";
            }
            case MONTH: {
                return "TRUNC(" + exp + ", 'MM')";
            }
            case YEAR: {
                return "TRUNC(" + exp + ", 'YYYY')";
            }
            case QUARTER: {
                return "TRUNC(" + exp + ", 'Q')";
            }
            case HOUR: {
                if (!canTime) {
                    throw new NotImplementedException("Rounding mode not implemented for Denodo date:" + String.valueOf(rounding));
                }
                return "TRUNC(" + exp + ", 'HH24')";
            }
            case MINUTE: {
                if (!canTime) {
                    throw new NotImplementedException("Rounding mode not implemented for Denodo date:" + String.valueOf(rounding));
                }
                return "TRUNC(" + exp + ", 'MI')";
            }
            case SECOND: {
                if (!canTime) {
                    throw new NotImplementedException("Rounding mode not implemented for Denodo date:" + String.valueOf(rounding));
                }
                return "GETTIMEFROMMILLIS(1000*TRUNC(GETTIMEINMILLIS(" + exp + ") / 1000))";
            }
        }
        throw new UnsupportedOperationException("Rounding mode not implemented for Denodo:" + String.valueOf(rounding));
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression("(" + inputDateExpression + ") AT TIME ZONE 'UTC'", part, true);
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, false);
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, true);
    }

    private String temporalPartExpression(String inputDateExpression, DatePart part, boolean canTime) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                if (!canTime) {
                    throw new UnsupportedOperationException("Can't extract time information from a date");
                }
                return "EXTRACT(HOUR FROM " + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                if (!canTime) {
                    throw new UnsupportedOperationException("Can't extract time information from a date");
                }
                return "EXTRACT(MINUTE FROM " + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                if (!canTime) {
                    throw new UnsupportedOperationException("Can't extract time information from a date");
                }
                return "EXTRACT(SECOND FROM " + inputDateExpression + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "EXTRACT(MILLISECOND FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "GETWEEK(" + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputDateExpression + ")";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "1 + MOD(CAST(EXTRACT(DOW FROM " + inputDateExpression + ") AS INTEGER) + 6, 7)";
            }
            case SECOND_FROM_EPOCH: {
                return "TRUNC(GETTIMEINMILLIS(" + inputDateExpression + ")/1000)";
            }
            case MILLIS_FROM_EPOCH: {
                return "GETTIMEINMILLIS(" + inputDateExpression + " )";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Denodo", part));
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        switch (part.type) {
            case ERA: {
                return "GG";
            }
            case YEAR: 
            case YEAROFERA: {
                return part.shortened ? "yy" : "yyyy";
            }
            case MONTH: {
                if (part.numeric) {
                    if (part.length == 1) {
                        return "M";
                    }
                    return "MM";
                }
                if (part.shortened) {
                    return "MMM";
                }
                return "MMMM";
            }
            case DAY: {
                if (part.length == 1) {
                    return "d";
                }
                return "dd";
            }
            case DAYOFYEAR: {
                return "DD";
            }
            case DAYOFWEEK: {
                if (part.numeric) {
                    return "u";
                }
                if (part.shortened) {
                    return "EEE";
                }
                return "EEEE";
            }
            case HOUR: {
                if (part.length == 1) {
                    return "H";
                }
                return "HH";
            }
            case HALFDAY: {
                return "a";
            }
            case HOUROFHALFDAY: {
                if (part.length == 1) {
                    return "K";
                }
                return "KK";
            }
            case CLOCKHOUR: {
                if (part.length == 1) {
                    return "k";
                }
                return "kk";
            }
            case CLOCKHOUROFHALFDAY: {
                if (part.length == 1) {
                    return "h";
                }
                return "hh";
            }
            case MINUTE: {
                if (part.length == 1) {
                    return "m";
                }
                return "mm";
            }
            case SECOND: {
                if (part.length == 1) {
                    return "s";
                }
                return "ss";
            }
            case MILLISECOND: {
                return "SSS";
            }
            case TIMEZONE: {
                if (part.numeric) {
                    return "z";
                }
                return "Z";
            }
            case TEXT: {
                Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"']");
                if (toEscape.matcher(part.text).matches()) {
                    return "''" + part.text.replace("'", "''") + "''";
                }
                return part.text;
            }
        }
        return part.text;
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.WEEK || part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR) {
            return SQLCapability.nok("Denodo can't parse or format using iso-week and iso-weekyear");
        }
        return SQLCapability.ok();
    }

    @Override
    public String getId() {
        return "Denodo";
    }
}

