/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.PrestoSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Params;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TrinoSQLDialect
extends PrestoSQLDialect {
    private static Pattern DATETIMENOTZ_TYPE_PATTERN = Pattern.compile("^timestamp(\\([0-9]+\\))?$", 2);
    public static final Pattern ISO8601_SCREENER = Pattern.compile("^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]+)?Z$");

    @Override
    public String getId() {
        return "Trino";
    }

    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public String useUTCTimezone() {
        return "SET TIME ZONE 'UTC'";
    }

    @Override
    public String quoteDate(String str) {
        if (ISO8601_SCREENER.matcher(str).matches()) {
            return "FROM_ISO8601_TIMESTAMP(" + this.quoteString(str) + ")";
        }
        return "WITH_TIMEZONE(CAST(" + this.quoteString(str) + " AS TIMESTAMP), 'UTC')";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "CAST(" + this.quoteString(str) + " AS TIMESTAMP(6))";
    }

    @Override
    protected String castAsDate(String str, Type type) {
        if (str.toLowerCase().startsWith("with_timezone(") || str.toLowerCase().startsWith("at_timezone(")) {
            return str;
        }
        if (str.toLowerCase().startsWith("cast(") && str.toLowerCase().endsWith("as timestamp with time zone)")) {
            return str;
        }
        if (type == Type.DATEONLY) {
            return "WITH_TIMEZONE(CAST(" + str + " AS TIMESTAMP), 'UTC')";
        }
        String uniso8601 = "regexp_replace(regexp_replace(cast(" + str + " as varchar), '(.*)Z', '$1 UTC'), '([0-9-]{10}).([0-9:.]{8,18})( .*)?', '$1 $2$3')";
        return "AT_TIMEZONE(CAST(" + uniso8601 + " AS TIMESTAMP WITH TIME ZONE), 'UTC')";
    }

    @Override
    public ExpressionBuilder cast(SchemaColumn col, ExpressionBuilder eb) {
        if (col.getType() == Type.STRING && (col.originalType.equalsIgnoreCase("date") || col.originalType.toLowerCase().startsWith("timestamp"))) {
            return eb.castToString(100);
        }
        return eb;
    }

    @Override
    public boolean needCast(SchemaColumn col, boolean isDatasetManaged) {
        if (isDatasetManaged || col == null || StringUtils.isEmpty((String)col.originalType)) {
            return false;
        }
        if (col.getType() == Type.STRING && (col.originalType.equalsIgnoreCase("date") || col.originalType.toLowerCase().startsWith("timestamp"))) {
            return true;
        }
        return col.originalType.toLowerCase().startsWith("time") || col.originalType.toLowerCase().startsWith("interval");
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 2014, "timestamp with time zone", new Integer[]{91, 93});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return DATETIMENOTZ_TYPE_PATTERN.matcher(StringUtils.defaultIfEmpty((String)sqlTypeName, (String)"")).matches();
    }

    @Override
    public void fillWithEmpty(PreparedStatement ps2, Dataset dataset, Type dssType, int colIdx) throws SQLException {
        switch (dssType) {
            case DATE: {
                ps2.setNull(colIdx, 93);
                break;
            }
            default: {
                super.fillWithEmpty(ps2, dataset, dssType, colIdx);
            }
        }
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            case DATEONLY: {
                long timestamp = this.typeDateOnly.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                this.ensureThreadLocalsAreHere();
                ps2.setTimestamp(colIdx, new Timestamp(timestamp), (Calendar)this.utcCalendar.get());
                break;
            }
            default: {
                super.fill(ps2, dssType, colIdx, dssStrVal);
            }
        }
    }

    @Override
    public void initOperators() {
        super.initOperators();
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.CONTAINS, false, true));
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.STARTS_WITH, false, true));
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.ENDS_WITH, false, true));
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
        this.addGenericFunction(QueryUtils.OperatorType.COSH, "COSH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SINH, "SINH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TANH, "TANH", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.DEC2HEX, "LOWER(TO_BASE(", ", 16))"));
        this.removeOperator(QueryUtils.OperatorType.FACT);
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(POSITION(", " IN COALESCE(", ", '')) - 1)", true));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "WITH_TIMEZONE(CAST(", "AS TIMESTAMP), 'UTC')"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                String formattedToStringExpr = "format_datetime(cast(" + this.toSQLNoBrackets(args[0]) + " as timestamp), 'yyyy-MM-dd HH:mm:ss.SSS')";
                if (args.length > 2 && args[2] != null) {
                    String translatedExpr = "cast(concat(" + formattedToStringExpr + ", ' ', " + this.toSQLNoBrackets(args[2]) + ") as TIMESTAMP WITH TIME ZONE)";
                    return "at_timezone(CAST(format_datetime(" + translatedExpr + " AT TIME ZONE " + this.toSQLNoBrackets(args[1]) + ", 'yyyy-MM-dd HH:mm:ss.SSS') AS TIMESTAMP WITH TIME ZONE), 'UTC')";
                }
                if (args.length > 1 && args[1] != null) {
                    return "at_timezone(cast(concat(" + formattedToStringExpr + ", ' ', " + this.toSQLNoBrackets(args[1]) + ") as TIMESTAMP WITH TIME ZONE), 'UTC')";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    boolean producedTz;
                    String converted;
                    String timezoneId;
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String string = timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    if (requestedType == Type.DATEONLY) {
                        if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
                            return "from_iso8601_date(cast(" + input + " as varchar))";
                        }
                        String sqlFormat = TrinoSQLDialect.this.toDateFormat(jodaFormat, true);
                        return "cast(parse_datetime(cast(" + input + " as  varchar),'" + sqlFormat + "') as date)";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        String converted2;
                        if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
                            converted2 = "from_iso8601_timestamp(cast(" + input + " as varchar))";
                        } else {
                            String sqlFormat = TrinoSQLDialect.this.toDateFormat(jodaFormat, true);
                            converted2 = "parse_datetime(cast(" + input + " as  varchar),'" + sqlFormat + "')";
                        }
                        return "cast(" + converted2 + " as timestamp)";
                    }
                    if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
                        converted = "from_iso8601_timestamp(cast(" + input + " as varchar))";
                        producedTz = true;
                    } else {
                        String sqlFormat = TrinoSQLDialect.this.toDateFormat(jodaFormat, true);
                        converted = "parse_datetime(cast(" + input + " as  varchar),'" + sqlFormat + "')";
                        boolean bl = producedTz = sqlFormat.contains("Z") || sqlFormat.contains("z");
                    }
                    if (producedTz) {
                        if (timezoneId == null || timezoneId.equals("UTC")) {
                            return converted;
                        }
                        return "at_timezone(" + converted + ", '" + timezoneId + "')";
                    }
                    return "with_timezone(cast(" + converted + " as timestamp), '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    timezoneId = StringUtils.defaultIfBlank((String)timezoneId, (String)"UTC");
                    input = "with_timezone(cast(" + (String)input + " as timestamp), 'UTC')";
                    if (requestedType.isTimestamp() && StringUtils.isNotBlank((String)timezoneId) && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        input = "at_timezone(" + (String)input + ", '" + timezoneId + "')";
                    }
                    String sqlFormat = TrinoSQLDialect.this.toDateFormat(jodaFormat, false);
                    return "format_datetime(" + (String)input + ",'" + sqlFormat + "')";
                }
                throw new NotImplementedException("format as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.AGG_CONCAT, "LISTAGG", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                QueryAst.ConstExpr separatorExpr = (QueryAst.ConstExpr)args[1];
                String separator = (String)separatorExpr.value;
                boolean distinct = false;
                if (args.length > 2) {
                    QueryAst.ConstExpr distinctExpr = (QueryAst.ConstExpr)args[2];
                    distinct = distinctExpr == null ? false : (Boolean)distinctExpr.value;
                }
                separator = separator == null ? TrinoSQLDialect.this.quoteString("") : this.toSQLNoBrackets(separatorExpr);
                String array = "array_agg(cast(" + column + " as varchar))";
                if (distinct) {
                    array = "array_distinct(" + array + ")";
                }
                return "concat_ws(" + separator + ", " + array + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_SUBSTR, "REGEXP_EXTRACT", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                String pattern = this.toSQLNoBrackets(args[1]);
                return String.format("REGEXP_EXTRACT(%s, %s)", column, pattern);
            }
        });
    }

    @Override
    public String dateonlyPartExpression(String expr, DatePart part) {
        expr = "with_timezone(cast(" + (String)expr + " as timestamp), 'UTC')";
        return this.temporalPartExpression((String)expr, part);
    }

    @Override
    public String datetimenotzPartExpression(String expr, DatePart part) {
        expr = "with_timezone(" + (String)expr + ", 'UTC')";
        return this.temporalPartExpression((String)expr, part);
    }

    @Override
    public String datePartExpression(String expr, DatePart part) {
        expr = "at_timezone(" + (String)expr + ", 'UTC')";
        return super.temporalPartExpression("(" + (String)expr + ") AT TIME ZONE 'UTC'", part);
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        inputDateExpression = "at_timezone(" + (String)inputDateExpression + ", 'UTC')";
        return super.temporalTrunc((String)inputDateExpression, rounding, false);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return super.temporalTrunc(inputDateExpression, rounding, true);
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return super.temporalTrunc(inputDateExpression, rounding, false);
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        Params datasetProps = dataset.getDkuPropertiesAsParams();
        String catalogType = datasetProps.getParam("trino.connector.type", "");
        HashMap<String, String> typeOverrides = new HashMap<String, String>();
        for (Type t : Type.values()) {
            String override = datasetProps.getParam("trino.type.override." + t.getName(), "");
            if (!StringUtils.isNotBlank((String)override)) continue;
            typeOverrides.put(t.getName(), override);
        }
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        if (connection != null) {
            Params connectionProps = connection.getDkuPropertiesAsParams();
            if (StringUtils.isBlank((String)catalogType)) {
                if (config.catalog != null) {
                    catalogType = connectionProps.getParam("trino." + config.catalog + ".connector.type", "");
                }
                if (StringUtils.isBlank((String)catalogType)) {
                    catalogType = connectionProps.getParam("trino.connector.type", "");
                }
            }
            for (Type t : Type.values()) {
                String override = null;
                if (StringUtils.isNotBlank((String)config.catalog)) {
                    override = connectionProps.getParam("trino." + config.catalog + ".type.override." + t.getName(), "");
                }
                if (StringUtils.isBlank(override)) {
                    override = connectionProps.getParam("trino.type.override." + t.getName(), "");
                }
                if (!StringUtils.isNotBlank(override) || typeOverrides.containsKey(t.getName())) continue;
                typeOverrides.put(t.getName(), override);
            }
        }
        catalogType = StringUtils.defaultIfBlank((String)catalogType, (String)"").toLowerCase();
        DKULogger.getLogger((String)"dip.trino").info((Object)("Create table with type overrides " + JSON.json(typeOverrides)));
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE " + (ifNotExist ? "IF NOT EXISTS " : "") + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " (\n");
        boolean first = true;
        for (SchemaColumn col : dataset.getSchema().getColumns()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\t");
            String sqlDecl = this.getSQLType((SchemaColumn)col, (Dataset)dataset).sqlDecl;
            if (typeOverrides.containsKey(col.getType().getName())) {
                sqlDecl = (String)typeOverrides.get(col.getType().getName());
            } else if (col.getType() == Type.DATE && catalogType.startsWith("hive")) {
                sqlDecl = "timestamp";
            }
            sb.append(this.quoteIdentifier(col.getName()) + " " + sqlDecl);
            sb.append("\n");
            first = false;
        }
        sb.append(")");
        if ("hive".equalsIgnoreCase(catalogType)) {
            sb.append(" WITH (transactional=true, format='ORC')");
        }
        return sb.toString();
    }

    @Override
    public String dropTemporaryTable(SQLUtils.SQLTable table) {
        return "DROP TABLE " + this.getQuotedTableFullName(table);
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        throw new IllegalStateException("Cannot create temporary table to be filled later");
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " AS " + selectExpr};
    }

    @Override
    public String getCreateIndexStatement(String indexName, SQLUtils.SQLTable table, String quotedFieldsList) {
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " ON " + this.getQuotedTableFullName(table) + " (" + quotedFieldsList + ")";
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        return abilities;
    }
}

