/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.StringOutputFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class VerticaCopyCSVFormatter
extends StringOutputFormatter {
    private List<Column> schemaColumns = new ArrayList<Column>();
    private String partitioningKeyColumnName;
    private String targetPartitioningKeyValue;
    private Schema schema;

    public VerticaCopyCSVFormatter(Schema schema, String partitioningKeyColumnName, String targetPartitioningKeyValue) {
        super("utf8");
        this.partitioningKeyColumnName = partitioningKeyColumnName;
        this.targetPartitioningKeyValue = targetPartitioningKeyValue;
        this.schema = schema;
    }

    public void format(Row row, ColumnFactory cf, Writer sb) throws IOException {
        int i = 0;
        for (Column c2 : this.schemaColumns) {
            if (c2.getName().equals(this.partitioningKeyColumnName)) {
                if (i++ > 0) {
                    sb.append(",");
                }
                sb.append(this.targetPartitioningKeyValue);
                continue;
            }
            String v = row.get(c2);
            if (i++ > 0) {
                sb.append(",");
            }
            CSVOutputFormatter.appendUNIXStyle(sb, v, ',', '\"', Character.valueOf('\\'));
        }
        sb.append('\n');
    }

    public void header(ColumnFactory cf, Writer sb) throws IOException {
        for (SchemaColumn schemaColumn : this.schema.getColumns()) {
            this.schemaColumns.add(cf.column(schemaColumn.getName()));
        }
    }

    public void footer(ColumnFactory cf, Writer sb) throws IOException {
    }

    public void cancel(OutputStream os) throws Exception {
    }

    public void setOutputSchema(Schema schema) {
        throw new Error();
    }
}

