/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kdbplustick;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.KDBPlusConnection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.kdbplustick.KDBPlusTickStreamingEndpointParams;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.net.SocketException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import kx.c;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class KDBPlusTickSimplePuller
implements StreamingEndpointSimplePuller {
    private static DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ").withZone(DateTimeZone.getDefault());
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private final KDBPlusTickStreamingEndpointParams params;
    private final AuthCtx authCtx;
    private ColumnFactory cf;
    private RowFactory rf;
    private Thread runningThread = null;
    private c currentConn = null;
    private LocalDate currentDate = null;
    private volatile boolean interrupted;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.endpoints.kdbplustick.puller");

    public KDBPlusTickSimplePuller(AuthCtx authCtx, KDBPlusTickStreamingEndpointParams params) {
        this.authCtx = authCtx;
        this.params = params;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void close() throws Exception {
        logger.info((Object)"Interrupt requested");
        this.interrupted = true;
        if (this.runningThread != null) {
            logger.info((Object)"Interrupting the thread");
            this.runningThread.interrupt();
        }
        if (this.currentConn != null) {
            logger.info((Object)"Force-closing the connection");
            try {
                this.currentConn.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close");
            }
        }
    }

    @Override
    public void init(ColumnFactory cf, RowFactory rf, Schema readSchema, JsonElement previousState) throws Exception {
        this.cf = cf;
        this.rf = rf;
        this.runningThread = Thread.currentThread();
        KDBPlusConnection conn = (KDBPlusConnection)this.connectionsDAO.getConnection(this.authCtx, this.params.connection);
        this.currentConn = StringUtils.isNotBlank((String)conn.params.user) ? new c(conn.params.host, conn.params.port, conn.params.user + ":" + conn.params.password) : new c(conn.params.host, conn.params.port);
        Object[] symbols = null;
        logger.info((Object)("Symbols param: " + this.params.symbols));
        if (StringUtils.isNotBlank((String)this.params.symbols)) {
            try {
                JSON.StringList sl = (JSON.StringList)JSON.parse((String)this.params.symbols, JSON.StringList.class);
                symbols = sl.toArray((Object[])new String[0]);
            }
            catch (Exception e) {
                symbols = this.params.symbols;
            }
        } else {
            symbols = "";
        }
        logger.info((Object)("Subscribing to symbols: " + String.valueOf(symbols) + " on table " + this.params.tableName));
        Date ret = (Date)this.currentConn.k(".u.d");
        this.currentDate = new LocalDate((Object)ret);
        logger.info((Object)("currentDate is " + String.valueOf(this.currentDate)));
        this.currentConn.ks(".u.sub", this.params.tableName, symbols);
    }

    @Override
    public StreamingEndpointSimplePuller.RowsPulled next() throws Exception {
        c kdbConnection = this.currentConn;
        Object[] data = null;
        StreamingEndpointSimplePuller.RowsPulled pulled = new StreamingEndpointSimplePuller.RowsPulled();
        pulled.rows = Lists.newArrayList();
        try {
            data = (Object[])kdbConnection.k();
        }
        catch (SocketException e) {
            if (this.interrupted) {
                logger.warn((Object)"socket exception but thread is interrupted, ignoring", (Throwable)e);
                return pulled;
            }
            throw e;
        }
        logger.info((Object)("Received data, message type: " + String.valueOf(data[0])));
        if ("upd".equals(data[0])) {
            String tableName = null;
            Column tableNameCD = null;
            if (data.length >= 2 && data[1] != null) {
                tableName = data[1].toString();
                tableNameCD = this.cf.column("kdb_table_name");
            }
            for (int dataIdx = 0; dataIdx < data.length; ++dataIdx) {
                if (!(data[dataIdx] instanceof c.Flip)) continue;
                logger.info((Object)"Received a flip");
                c.Flip flip = (c.Flip)data[dataIdx];
                int timeColumnIndex = -1;
                ArrayList<Column> columns = new ArrayList<Column>();
                int i = 0;
                for (String col : flip.x) {
                    columns.add(this.cf.column(col));
                    if ("time".equals(col)) {
                        timeColumnIndex = i;
                    }
                    ++i;
                }
                for (int rowIdx = 0; rowIdx < c.n(flip.y[0]); ++rowIdx) {
                    Row row = this.rf.row();
                    if (tableName != null) {
                        row.put(tableNameCD, tableName);
                    }
                    row.put(this.cf.column("day"), String.format("%02d-%02d-%02d", this.currentDate.getYear(), this.currentDate.getMonthOfYear(), this.currentDate.getDayOfMonth()));
                    if (timeColumnIndex >= 0) {
                        Object t = c.at(flip.y[timeColumnIndex], rowIdx);
                        try {
                            if (t instanceof Timestamp) {
                                Timestamp ts = (Timestamp)t;
                                row.put(this.cf.column("computed_date"), dtf.print(ts.getTime()));
                            } else if (t instanceof c.Timespan) {
                                c.Timespan span = (c.Timespan)t;
                                DateTime lt = new DateTime((Object)this.currentDate.toDateTimeAtStartOfDay());
                                lt = lt.millisOfDay().setCopy((int)(span.j / 1000000L));
                                row.put(this.cf.column("computed_date"), dtf.print((ReadableInstant)lt));
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Could not process time", (Throwable)e);
                        }
                    } else {
                        logger.warn((Object)"no time column");
                    }
                    for (int colIdx = 0; colIdx < flip.x.length; ++colIdx) {
                        Object val = c.at(flip.y[colIdx], rowIdx);
                        if (val == null) continue;
                        row.put((Column)columns.get(colIdx), val.toString());
                    }
                    pulled.rows.add(row);
                }
            }
        } else if ("endofday".equals(data[0]) || ".u.end".equals(data[0])) {
            logger.info((Object)"Received EOD");
            this.currentDate = this.currentDate.plusDays(1);
        }
        pulled.state = JSON.toJsonElement((Object)data[0]);
        pulled.ack = null;
        return pulled;
    }

    @Override
    public void setLimit(JsonElement limit) {
    }
}

