/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.statistics.TierStatistics;

public class EhcacheMetrics
implements MetricSet {
    public static final String CACHES_CONFIG_ROOT = "dku.caches";
    private Map<String, Metric> map = new HashMap<String, Metric>();

    public static final String metricNameFor(String cacheName, String statName) {
        return "dku.caches." + cacheName + "." + statName;
    }

    public static MetricSet cacheMetricsSet(String cacheName, final StatisticsService statisticsService, final String ehcacheCacheName) {
        EhcacheMetrics metrics = new EhcacheMetrics();
        Set tierNames = statisticsService.getCacheStatistics(ehcacheCacheName).getTierStatistics().keySet();
        for (final String tierName : tierNames) {
            metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "tiers." + tierName + ".entries"), (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return ((TierStatistics)statisticsService.getCacheStatistics(ehcacheCacheName).getTierStatistics().get(tierName)).getMappings();
                }
            });
            metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "tiers." + tierName + ".bytes"), (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return ((TierStatistics)statisticsService.getCacheStatistics(ehcacheCacheName).getTierStatistics().get(tierName)).getOccupiedByteSize();
                }
            });
            metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "tiers." + tierName + ".puts"), (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return ((TierStatistics)statisticsService.getCacheStatistics(ehcacheCacheName).getTierStatistics().get(tierName)).getPuts();
                }
            });
        }
        metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "lookupCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return statisticsService.getCacheStatistics(ehcacheCacheName).getCacheGets();
            }
        });
        metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "hitCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return statisticsService.getCacheStatistics(ehcacheCacheName).getCacheHits();
            }
        });
        metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "missCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return statisticsService.getCacheStatistics(ehcacheCacheName).getCacheMisses();
            }
        });
        metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "hitRate"), (Metric)new Gauge<Double>(){

            public Double getValue() {
                return statisticsService.getCacheStatistics(ehcacheCacheName).getCacheHitPercentage();
            }
        });
        metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "putCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return statisticsService.getCacheStatistics(ehcacheCacheName).getCachePuts();
            }
        });
        metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "evictionCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return statisticsService.getCacheStatistics(ehcacheCacheName).getCacheEvictions();
            }
        });
        metrics.map.put(EhcacheMetrics.metricNameFor(cacheName, "expirationCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return statisticsService.getCacheStatistics(ehcacheCacheName).getCacheExpirations();
            }
        });
        return metrics;
    }

    public Map<String, Metric> getMetrics() {
        return this.map;
    }
}

