/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import com.dataiku.dip.shaker.processors.time.ical.IntervalTree;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class HolidayOccurrence
implements IntervalTree.Range<HolidayOccurrence, Integer> {
    public final String eventName;
    public final String calendarId;
    public final Type type;
    public final String zone;
    public final String preferredTimezone;
    public final int dayFrom;
    public final int dayTo;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HolidayOccurrence that = (HolidayOccurrence)o;
        return this.dayFrom == that.dayFrom && this.dayTo == that.dayTo && Objects.equals(this.eventName, that.eventName) && Objects.equals(this.calendarId, that.calendarId) && this.type == that.type && Objects.equals(this.zone, that.zone) && Objects.equals(this.preferredTimezone, that.preferredTimezone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventName, this.calendarId, this.type, this.zone, this.preferredTimezone, this.dayFrom, this.dayTo});
    }

    public HolidayOccurrence(String eventName, String calendarId, int dayFrom, int dayTo, String preferredTimezone, Type type, String zone) {
        this.eventName = (String)Preconditions.checkNotNull((Object)eventName);
        this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId);
        this.dayFrom = dayFrom;
        this.dayTo = dayTo;
        this.preferredTimezone = preferredTimezone == null ? "" : preferredTimezone;
        this.type = type == null ? Type.BANK : type;
        this.zone = zone == null ? "" : zone;
    }

    static int packDate(int year, int month, int day) {
        return year * 10000 + month * 100 + day;
    }

    static int unpackYear(int v) {
        return v / 10000;
    }

    static int unpackMonth(int v) {
        return v % 10000 / 100;
    }

    static int unpackDay(int v) {
        return v % 100;
    }

    public String toString() {
        return "[" + this.calendarId + "] " + this.dayFrom + "->" + this.dayTo + " | " + this.eventName;
    }

    @Override
    public int compareLowerBoundToRange(HolidayOccurrence other) {
        return Integer.compare(this.dayFrom, other.dayFrom);
    }

    @Override
    public int compareUpperBoundToRange(HolidayOccurrence other) {
        return Integer.compare(this.dayTo, other.dayTo);
    }

    @Override
    public int compareLowerBoundToScalar(Integer value) {
        return Integer.compare(this.dayFrom, value);
    }

    @Override
    public int compareUpperBoundToScalar(Integer value) {
        return Integer.compare(this.dayTo, value);
    }

    public static enum Type {
        SCHOOL,
        BANK,
        WEEKEND;

    }
}

