/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.utils.BackOffStrategy;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.BackOff;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public abstract class InterruptAndPrintStackTraceAfterTimeoutTask
implements Job,
InterruptableJob {
    public static final int INITIAL_STACKTRACE_TIMEOUT_MS = 300000;
    public static final int MAX_STACKTRACE_TIMEOUT_MS = 0x6DDD00;
    private static final BackOffStrategy STACKTRACE_INTERVAL_BACKOFF_STRATEGY = BackOffStrategy.expBackOff((int)300000, (int)0x6DDD00, (double)2.0);
    public static final long MONITOR_EVERY_MS = 300L;
    private Thread jobThread;
    private String jobKey;
    private int elapsedMs;
    private long currentTimeout;
    private long cumulativeElapsedMs;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.maint.timeout");

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        this.jobKey = jec.getJobDetail().getKey().toString();
        String parentThreadName = Thread.currentThread().getName();
        this.jobThread = new Thread(() -> {
            Thread.currentThread().setName(parentThreadName + "-Deferred");
            try {
                this.executeWithTimeout(jec);
            }
            catch (JobExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        this.cumulativeElapsedMs = 0L;
        this.jobThread.start();
        this.elapsedMs = 0;
        BackOff backOff = STACKTRACE_INTERVAL_BACKOFF_STRATEGY.build();
        try {
            this.currentTimeout = backOff.nextBackOffMillis();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (this.jobThread.isAlive()) {
            try {
                Thread.sleep(300L);
                this.elapsedMs = (int)((long)this.elapsedMs + 300L);
                if ((long)this.elapsedMs < this.currentTimeout) continue;
                this.cumulativeElapsedMs += (long)this.elapsedMs;
                this.elapsedMs = 0;
                this.currentTimeout = backOff.nextBackOffMillis();
                this.printStackTrace();
                logger.infoV("Job %s, trying to call interrupt() on the job thread.", new Object[]{this.jobKey});
                this.jobThread.interrupt();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        logger.infoV("Execution of job %s completed.", new Object[]{this.jobKey});
    }

    private void printStackTrace() {
        String stackTrace = Arrays.stream(this.jobThread.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining(System.lineSeparator() + "\tat "));
        logger.errorV("Execution of job %s is taking longer than %s ms. The job thread stacktrace is: %s", new Object[]{this.jobKey, this.cumulativeElapsedMs, stackTrace});
    }

    public abstract void executeWithTimeout(JobExecutionContext var1) throws JobExecutionException;

    public void interrupt() throws UnableToInterruptJobException {
        logger.errorV("Interrupt was called for job %s. Interrupting underlying thread.", new Object[]{this.jobKey});
        this.jobThread.interrupt();
    }
}

