/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.transactions.TransactionDebugInfo;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.ProxiedReadOnlyFS;
import com.dataiku.dip.transactions.impl.RWTransactionImpl;
import com.dataiku.dip.transactions.impl.TransactionImpl;
import com.dataiku.dip.transactions.impl.YOLOTransactionImpl;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DebugTransactionRegistry {
    public static final long END_LOG_MIN_READ_TOTAL_DURATION = 5000L;
    public static final long END_DUMP_MIN_READ_TOTAL_DURATION = 10000L;
    public static final long END_LOG_MIN_WRITE_TOTAL_DURATION = 5000L;
    public static final long END_DUMP_MIN_WRITE_TOTAL_DURATION = 10000L;
    public static final long SYNC_LOG_MIN_WAIT_DURATION = 5000L;
    public static final long SYNC_LOG_MIN_RUNNING_DURATION = 15000L;
    public static final long BKD_CHECKER_DELAY = 2000L;
    public static final long BKD_CHECKER_POST_DUMP_DELAY = 60000L;
    private boolean doBackground;
    private boolean doSyncLogging;
    private final Set<YOLOTransactionImpl> activeReadYOLOTxns = Sets.newConcurrentHashSet();
    private final Set<TransactionImpl> activeReadTxns = Sets.newConcurrentHashSet();
    private final Set<RWTransactionImpl> activeWriteTxns = Sets.newConcurrentHashSet();
    Counter roCounter = DSSMetrics.registry().counter("dku.transactions.ro");
    Timer roLockWaitTimer = DSSMetrics.registry().timer("dku.transactiontime.ro.lockWait");
    Timer roExecuteTimer = DSSMetrics.registry().timer("dku.transactiontime.ro.execute");
    Counter rwRolledbackCounter = DSSMetrics.registry().counter("dku.transactions.rw.rolledback");
    Counter rwCommittedCounter = DSSMetrics.registry().counter("dku.transactions.rw.committed");
    Timer rwLockWaitTimer = DSSMetrics.registry().timer("dku.transactiontime.rw.lockWait");
    Timer rwExecuteTimer = DSSMetrics.registry().timer("dku.transactiontime.rw.execute");
    Timer rwCommitPrepTimer = DSSMetrics.registry().timer("dku.transactiontime.rw.commitPrep");
    Timer rwCommitWaitTimer = DSSMetrics.registry().timer("dku.transactiontime.rw.commitWait");
    Timer rwCommitExecTimer = DSSMetrics.registry().timer("dku.transactiontime.rw.commitExec");
    private static DKULogger logger = DKULogger.getLogger((String)"dku.transactions");

    public DebugTransactionRegistry(boolean doBackground, boolean doSyncLogging) {
        this.doBackground = doBackground;
        this.doSyncLogging = doSyncLogging;
        if (doBackground) {
            new BackgroundChecker().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransactionStateDump() {
        TransactionDebugInfo di;
        StringBuilder sb = new StringBuilder();
        ArrayList localActive = null;
        ArrayList localRWActive = null;
        ArrayList localActiveYolo = null;
        Iterator iterator = this;
        synchronized (iterator) {
            localActive = Lists.newArrayList(this.activeReadTxns);
            localActiveYolo = Lists.newArrayList(this.activeReadYOLOTxns);
            localRWActive = Lists.newArrayList(this.activeWriteTxns);
        }
        for (ProxiedReadOnlyFS impl : localActiveYolo) {
            di = ((YOLOTransactionImpl)impl).getDebugInfo();
            sb.append("Read txn (YOLO) thread=" + di.threadName + " state=" + String.valueOf((Object)di.state) + " start=" + DKUtils.isoFormatPretty((long)di.requestedTime) + System.lineSeparator());
            this.appendStacks(di, sb, " (YOLO)");
        }
        for (ProxiedReadOnlyFS impl : localActive) {
            di = ((TransactionImpl)impl).getDebugInfo();
            sb.append("Read txn (ISOLATED) thread=" + di.threadName + " state=" + String.valueOf((Object)di.state) + " start=" + DKUtils.isoFormatPretty((long)di.requestedTime) + System.lineSeparator());
            this.appendStacks(di, sb, " (ISOLATED)");
        }
        for (ProxiedReadOnlyFS impl : localRWActive) {
            di = ((RWTransactionImpl)impl).getDebugInfo();
            String committableStr = ((RWTransactionImpl)impl).isCommittable() ? " (COMMITTABLE) " : " (NON COMMITTABLE) ";
            sb.append("Write txn" + committableStr + "thread=" + di.threadName + " state=" + String.valueOf((Object)di.state) + " start=" + DKUtils.isoFormatPretty((long)di.requestedTime) + System.lineSeparator());
            this.appendStacks(di, sb, committableStr);
        }
        return sb.toString();
    }

    private void appendStacks(TransactionDebugInfo di, StringBuilder sb, String typeDetails) {
        sb.append("Startup stack" + typeDetails + ":\n").append(DebugTransactionRegistry.prefixLines("S", di.getStartupStackTrace()));
        if (di.state == TransactionProvider.TransactionState.RUNNING || di.state == TransactionProvider.TransactionState.COMMITTING) {
            sb.append("Current stack" + typeDetails + ":\n").append(DebugTransactionRegistry.prefixLines("C ", di.getFormattedStackStrace())).append("\n");
        }
        sb.append("\n");
    }

    private static String prefixLines(String prefix, String lines) {
        StringBuilder out = new StringBuilder();
        try (Scanner scanner = new Scanner(lines);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                out.append(prefix);
                out.append('\t');
                out.append(line);
                out.append('\n');
            }
        }
        return out.toString();
    }

    private void logCheckWarnHeader() {
        logger.warn((Object)"------------------------------------");
        logger.warn((Object)"Detected concurrent transaction state");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runSyncCheck() {
        long runTime;
        long waitTime;
        TransactionDebugInfo di;
        long now = System.currentTimeMillis();
        ArrayList localActive = null;
        ArrayList localRWActive = null;
        DebugTransactionRegistry debugTransactionRegistry = this;
        synchronized (debugTransactionRegistry) {
            localActive = Lists.newArrayList(this.activeReadTxns);
            localRWActive = Lists.newArrayList(this.activeWriteTxns);
        }
        boolean dumpAll = false;
        for (ProxiedReadOnlyFS impl : localActive) {
            di = ((TransactionImpl)impl).getDebugInfo();
            if (di.state == TransactionProvider.TransactionState.WAITING_START) {
                waitTime = now - di.requestedTime;
                if (waitTime <= 5000L) continue;
                if (!dumpAll) {
                    this.logCheckWarnHeader();
                }
                dumpAll = true;
                logger.warn((Object)("READ TXN in WAIT state for " + waitTime + " thread=" + di.threadName));
                continue;
            }
            if (di.state != TransactionProvider.TransactionState.RUNNING || (runTime = now - di.startedTime) <= 15000L) continue;
            if (!dumpAll) {
                this.logCheckWarnHeader();
            }
            dumpAll = true;
            logger.warn((Object)("READ TXN in RUNNING state for " + runTime + "ms thread=" + di.threadName));
        }
        for (ProxiedReadOnlyFS impl : localRWActive) {
            di = ((RWTransactionImpl)impl).getDebugInfo();
            if (di.state == TransactionProvider.TransactionState.WAITING_START || di.state == TransactionProvider.TransactionState.WAITING_UPGRADE) {
                waitTime = now - di.requestedTime;
                if (waitTime <= 5000L) continue;
                if (!dumpAll) {
                    this.logCheckWarnHeader();
                }
                dumpAll = true;
                logger.warn((Object)("WRITE TXN in WAIT state for " + waitTime + " thread=" + di.threadName));
                continue;
            }
            if (di.state != TransactionProvider.TransactionState.RUNNING || (runTime = now - di.startedTime) <= 15000L) continue;
            if (!dumpAll) {
                this.logCheckWarnHeader();
            }
            dumpAll = true;
            String committableStr = ((RWTransactionImpl)impl).isCommittable() ? " (COMMITTABLE) " : " (NON COMMITTABLE) ";
            logger.warn((Object)("WRITE TXN" + committableStr + "in RUNNING state for " + runTime + "ms thread=" + di.threadName));
        }
        if (dumpAll) {
            logger.info((Object)"DUMPING Transactions state");
            logger.info((Object)"--------------------------");
            logger.info((Object)this.getTransactionStateDump());
            logger.warn((Object)"------------------------------------");
        }
        return dumpAll;
    }

    public void registerRead(TransactionImpl mt) {
        this.activeReadTxns.add(mt);
    }

    public void registerRead(YOLOTransactionImpl mt) {
        this.activeReadYOLOTxns.add(mt);
    }

    public void registerWrite(RWTransactionImpl mt) {
        this.activeWriteTxns.add(mt);
    }

    public void unregister(YOLOTransactionImpl mt) {
        this.activeReadYOLOTxns.remove(mt);
    }

    public void unregister(TransactionImpl mt) {
        if (!this.activeReadTxns.remove(mt)) {
            return;
        }
        TransactionDebugInfo debugInfo = mt.getDebugInfo();
        long lockWaitDelay = debugInfo.startedTime - debugInfo.requestedTime;
        long insideTransaction = debugInfo.endTime - debugInfo.startedTime;
        long total = lockWaitDelay + insideTransaction;
        this.roCounter.inc();
        this.roLockWaitTimer.update(lockWaitDelay, TimeUnit.MILLISECONDS);
        this.roExecuteTimer.update(insideTransaction, TimeUnit.MILLISECONDS);
        if (this.doSyncLogging && total >= 5000L) {
            logger.infoV("End of long read txn [total=%dms wait=%dms exec=%dms]", new Object[]{total, lockWaitDelay, insideTransaction});
        }
        if (this.doSyncLogging && total >= 10000L) {
            logger.info((Object)("It was started as:\n" + DebugTransactionRegistry.prefixLines("S", debugInfo.getStartupStackTrace())));
        }
    }

    public void unregister(RWTransactionImpl mt) {
        if (!this.activeWriteTxns.remove(mt)) {
            return;
        }
        TransactionDebugInfo debugInfo = mt.getDebugInfo();
        long total = debugInfo.endTime - debugInfo.requestedTime;
        boolean committed = debugInfo.commitStartedTime > 0L;
        long lockWaitDelay = debugInfo.startedTime - debugInfo.requestedTime;
        if (committed) {
            long insideDelay = debugInfo.commitStartedTime - debugInfo.startedTime;
            long commitPrepDelay = debugInfo.commitWaitStartTime - debugInfo.commitStartedTime;
            long commitWaitDelay = debugInfo.commitWaitDoneTime - debugInfo.commitWaitStartTime;
            long commitExecDelay = debugInfo.endTime - debugInfo.commitWaitDoneTime;
            if (this.doSyncLogging && total >= 5000L) {
                logger.infoV("End of long write txn [COMMIT] [total=%dms waitStart=%dms exec=%dms commitPrep=%dms commitWait=%dms commitExec=%dms]", new Object[]{total, lockWaitDelay, insideDelay, commitPrepDelay, commitWaitDelay, commitExecDelay});
            }
            this.rwCommittedCounter.inc();
            this.rwLockWaitTimer.update(lockWaitDelay, TimeUnit.MILLISECONDS);
            this.rwExecuteTimer.update(insideDelay, TimeUnit.MILLISECONDS);
            this.rwCommitPrepTimer.update(commitPrepDelay, TimeUnit.MILLISECONDS);
            this.rwCommitWaitTimer.update(commitWaitDelay, TimeUnit.MILLISECONDS);
            this.rwCommitExecTimer.update(commitExecDelay, TimeUnit.MILLISECONDS);
        } else {
            long insideDelay = debugInfo.endTime - debugInfo.startedTime;
            if (this.doSyncLogging && total >= 5000L) {
                logger.infoV("End of long write txn [ROLLBACK] [total=%dms waitStart=%dms exec=%dms]", new Object[]{total, lockWaitDelay, insideDelay});
            }
            this.rwRolledbackCounter.inc();
            this.rwLockWaitTimer.update(lockWaitDelay, TimeUnit.MILLISECONDS);
            this.rwExecuteTimer.update(insideDelay, TimeUnit.MILLISECONDS);
        }
        if (this.doSyncLogging && total >= 10000L) {
            logger.info((Object)("It was started as:\n" + DebugTransactionRegistry.prefixLines("S", debugInfo.getStartupStackTrace())));
        }
    }

    public class BackgroundChecker
    extends Thread {
        @Override
        public void run() {
            Thread.currentThread().setName("BackgroundTransactionChecker");
            long lastDump = 0L;
            while (true) {
                long now;
                if ((now = System.currentTimeMillis()) - lastDump < 60000L) {
                    DKUtils.unsafeSleep((long)(60000L - (now - lastDump)));
                } else {
                    DKUtils.unsafeSleep((long)2000L);
                }
                try {
                    boolean didDump = DebugTransactionRegistry.this.runSyncCheck();
                    if (!didDump) continue;
                    lastDump = System.currentTimeMillis();
                    continue;
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to check transactions state", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

