/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.assertions;

import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Audience;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Identifier;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Subject;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public abstract class AssertionDetails {
    private final Issuer issuer;
    private final Subject subject;
    private final List<Audience> audience;
    private final Date iat;
    private final Date exp;
    private final Identifier id;

    public AssertionDetails(Issuer issuer, Subject subject, List<Audience> audience, Date iat, Date exp, Identifier id) {
        this.issuer = Objects.requireNonNull(issuer);
        this.subject = Objects.requireNonNull(subject);
        if (CollectionUtils.isEmpty(audience)) {
            throw new IllegalArgumentException("The audience must not be null or empty");
        }
        this.audience = audience;
        this.exp = Objects.requireNonNull(exp);
        this.iat = iat;
        this.id = id;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public List<Audience> getAudience() {
        return this.audience;
    }

    public Date getExpirationTime() {
        return this.exp;
    }

    public Date getIssueTime() {
        return this.iat;
    }

    public Identifier getID() {
        return this.id;
    }
}

