/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.Intervals;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalsSource;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.util.Locale;

public class Wildcard
extends IntervalFunction {
    private final String wildcard;
    private final int maxExpansions;

    public Wildcard(String wildcard, int maxExpansions) {
        this.wildcard = wildcard;
        this.maxExpansions = maxExpansions;
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        if (this.maxExpansions == 0) {
            return Intervals.wildcard(new BytesRef(this.wildcard));
        }
        return Intervals.wildcard(new BytesRef(this.wildcard), this.maxExpansions);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:wildcard(%s%s)", this.wildcard, this.maxExpansions == 0 ? "" : " maxExpansions:" + this.maxExpansions);
    }
}

