/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.AbstractDiscoverableAnnotationHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.AnnotationDecorator;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.AnnotationParser;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.ClassInheritanceHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.ContainerInitializerAnnotationHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.WebFilterAnnotationHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.WebListenerAnnotationHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.WebServletAnnotationHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.plus.webapp.PlusConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContainerInitializerHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.Source;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.FragmentDescriptor;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.JettyWebXmlConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppContext;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebDescriptor;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ExceptionUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Loader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.NanoTime;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ProcessorUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.StringUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.TypeUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.Resource;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.ResourceFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.statistic.CounterStatistic;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.annotation.HandlesTypes;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationConfiguration.class);
    public static final String SERVLET_CONTAINER_INITIALIZER_EXCLUSION_PATTERN = "com.dataiku.dss.shadelib.org.eclipse.jetty.containerInitializerExclusionPattern";
    public static final String SERVLET_CONTAINER_INITIALIZER_ORDER = "com.dataiku.dss.shadelib.org.eclipse.jetty.containerInitializerOrder";
    public static final String CLASS_INHERITANCE_MAP = "com.dataiku.dss.shadelib.org.eclipse.jetty.classInheritanceMap";
    public static final String CONTAINER_INITIALIZERS = "com.dataiku.dss.shadelib.org.eclipse.jetty.containerInitializers";
    public static final String CONTAINER_INITIALIZER_STARTER = "com.dataiku.dss.shadelib.org.eclipse.jetty.containerInitializerStarter";
    public static final String MULTI_THREADED = "com.dataiku.dss.shadelib.org.eclipse.jetty.annotations.multiThreaded";
    public static final String MAX_SCAN_WAIT = "com.dataiku.dss.shadelib.org.eclipse.jetty.annotations.maxWait";
    protected static final String STATE = "com.dataiku.dss.shadelib.org.eclipse.jetty.annotations.state";
    public static final int DEFAULT_MAX_SCAN_WAIT = 60;
    public static final boolean DEFAULT_MULTI_THREADED = true;

    public AnnotationConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class, PlusConfiguration.class).addDependents(JettyWebXmlConfiguration.class).hide("com.dataiku.dss.shadelib.org.objectweb.asm."));
    }

    @Override
    public void preConfigure(WebAppContext context) {
        String tmp = (String)context.getAttribute(SERVLET_CONTAINER_INITIALIZER_EXCLUSION_PATTERN);
        State state = new State(context);
        context.setAttribute(STATE, state);
        state._sciExcludePattern = tmp == null ? null : Pattern.compile(tmp);
    }

    private State getState(WebAppContext context) {
        Object object = context.getAttribute(STATE);
        if (object instanceof State) {
            State state = (State)object;
            return state;
        }
        throw new IllegalStateException("No state");
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        State state = this.getState(context);
        context.getObjectFactory().addDecorator(new AnnotationDecorator(context));
        if (!context.getMetaData().isMetaDataComplete() && (context.getServletContext().getEffectiveMajorVersion() >= 3 || context.isConfigurationDiscovered())) {
            state._discoverableAnnotationHandlers.add(new WebServletAnnotationHandler(context));
            state._discoverableAnnotationHandlers.add(new WebFilterAnnotationHandler(context));
            state._discoverableAnnotationHandlers.add(new WebListenerAnnotationHandler(context));
        }
        this.createServletContainerInitializerAnnotationHandlers(context, this.getNonExcludedInitializers(state));
        if (!state._discoverableAnnotationHandlers.isEmpty() || state._classInheritanceHandler != null || !state._containerInitializerAnnotationHandlers.isEmpty()) {
            this.scanForAnnotations(context, state);
        }
        Map map = (Map)context.getAttribute(CLASS_INHERITANCE_MAP);
        for (DiscoveredServletContainerInitializerHolder holder : state._sciHolders) {
            holder.resolveClasses(map);
            context.addServletContainerInitializer(holder);
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        ClassInheritanceMap classMap = (ClassInheritanceMap)context.getAttribute(CLASS_INHERITANCE_MAP);
        if (classMap != null) {
            classMap.clear();
        }
        context.removeAttribute(CLASS_INHERITANCE_MAP);
        Object object = context.removeAttribute(STATE);
        if (!(object instanceof State)) {
            throw new IllegalStateException("No state");
        }
        State state = (State)object;
        state._discoverableAnnotationHandlers.clear();
        state._classInheritanceHandler = null;
        state._containerInitializerAnnotationHandlers.clear();
        state._sciHolders.clear();
        if (state._parserTasks != null) {
            state._parserTasks.clear();
            state._parserTasks = null;
        }
        super.postConfigure(context);
    }

    protected void scanForAnnotations(WebAppContext context, State state) throws Exception {
        int javaPlatform = 0;
        Object target = context.getAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.javaTargetPlatform");
        if (target != null) {
            javaPlatform = Integer.parseInt(target.toString());
        }
        AnnotationParser parser = this.createAnnotationParser(javaPlatform);
        state._parserTasks = new ArrayList<ParserTask>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotation scanning commencing: webxml={}, metadatacomplete={}, configurationDiscovered={}, multiThreaded={}, maxScanWait={}", new Object[]{context.getServletContext().getEffectiveMajorVersion(), context.getMetaData().isMetaDataComplete(), context.isConfigurationDiscovered(), this.isUseMultiThreading(context), this.getMaxScanWait(context)});
        }
        this.parseContainerPath(context, parser);
        this.parseWebInfClasses(state, parser);
        this.parseWebInfLib(state, parser);
        long start = NanoTime.now();
        Semaphore task_limit = this.isUseMultiThreading(context) ? new Semaphore(ProcessorUtils.availableProcessors()) : new Semaphore(1);
        CountDownLatch latch = new CountDownLatch(state._parserTasks.size());
        ExceptionUtil.MultiException multiException = new ExceptionUtil.MultiException();
        for (ParserTask p : state._parserTasks) {
            task_limit.acquire();
            context.getServer().getThreadPool().execute(() -> {
                multiException.callAndCatch(p::call);
                task_limit.release();
                latch.countDown();
            });
        }
        boolean timeout = !latch.await(this.getMaxScanWait(context), TimeUnit.SECONDS);
        long elapsedMs = NanoTime.millisSince(start);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotation scanning elapsed time={}ms", (Object)elapsedMs);
            for (ParserTask p : state._parserTasks) {
                LOG.debug("Scanned {} in {}ms", (Object)p.getResource(), (Object)TimeUnit.NANOSECONDS.toMillis(p.getStatistic().getElapsedNanos()));
            }
            LOG.debug("Scanned {} container path jars, {} WEB-INF/lib jars, {} WEB-INF/classes dirs in {}ms for context {}", new Object[]{state._containerPathStats == null ? -1L : state._containerPathStats.getTotal(), state._webInfLibStats == null ? -1L : state._webInfLibStats.getTotal(), state._webInfClassesStats == null ? -1L : state._webInfClassesStats.getTotal(), elapsedMs, context});
        }
        if (timeout) {
            multiException.add(new Exception("Timeout scanning annotations"));
        }
        multiException.ifExceptionThrow();
    }

    protected AnnotationParser createAnnotationParser(int javaPlatform) {
        return new AnnotationParser(javaPlatform);
    }

    protected boolean isUseMultiThreading(WebAppContext context) {
        Object o = context.getAttribute(MULTI_THREADED);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        o = context.getServer().getAttribute(MULTI_THREADED);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(System.getProperty(MULTI_THREADED, Boolean.toString(true)));
    }

    protected int getMaxScanWait(WebAppContext context) {
        Object o = context.getAttribute(MAX_SCAN_WAIT);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        o = context.getServer().getAttribute(MAX_SCAN_WAIT);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.getInteger(MAX_SCAN_WAIT, 60);
    }

    public void createServletContainerInitializerAnnotationHandlers(WebAppContext context, List<ServletContainerInitializer> scis) throws Exception {
        if (scis == null || scis.isEmpty()) {
            return;
        }
        State state = this.getState(context);
        for (ServletContainerInitializer sci : scis) {
            Class[] classes = new Class[]{};
            HandlesTypes annotation = sci.getClass().getAnnotation(HandlesTypes.class);
            if (annotation != null) {
                classes = annotation.value();
            }
            DiscoveredServletContainerInitializerHolder holder = new DiscoveredServletContainerInitializerHolder(new Source(Source.Origin.ANNOTATION, sci.getClass()), sci, new Class[0]);
            state._sciHolders.add(holder);
            if (classes.length <= 0) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("HandlesTypes {} on initializer {}", Arrays.asList(classes), sci.getClass());
            }
            if (context.getAttribute(CLASS_INHERITANCE_MAP) == null) {
                ClassInheritanceMap map = new ClassInheritanceMap();
                context.setAttribute(CLASS_INHERITANCE_MAP, map);
                state._classInheritanceHandler = new ClassInheritanceHandler(map);
            }
            for (Class c : classes) {
                if (c.isAnnotation()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Registering annotation handler for {}", (Object)c.getName());
                    }
                    state._containerInitializerAnnotationHandlers.add(new ContainerInitializerAnnotationHandler(holder, c));
                }
                holder.addStartupClasses(c);
            }
        }
    }

    protected Resource getJarFor(WebAppContext context, ServletContainerInitializer service) {
        URI uri = TypeUtil.getLocationOfClass(service.getClass());
        if (uri == null) {
            return null;
        }
        return ResourceFactory.of(context).newResource(uri);
    }

    public boolean isFromExcludedJar(WebAppContext context, ServletContainerInitializer sci, Resource sciResource) {
        Resource r;
        if (sci == null) {
            throw new IllegalArgumentException("ServletContainerInitializer null");
        }
        if (context == null) {
            throw new IllegalArgumentException("WebAppContext null");
        }
        if (sciResource == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!Excluded {} null resource", (Object)sci);
            }
            return false;
        }
        if (this.isFromWebInfClasses(context, sciResource)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!Excluded {} from web-inf/classes", (Object)sci);
            }
            return false;
        }
        if (this.isFromContainerClassPath(context, sci)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!Excluded {} from container classpath", (Object)sci);
            }
            return false;
        }
        if (!context.getMetaData().isOrdered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!Excluded {} no ordering", (Object)sci);
            }
            return false;
        }
        List<Resource> orderedJars = context.getMetaData().getWebInfResources(true);
        if (orderedJars.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Excluded {} empty ordering", (Object)sci);
            }
            return true;
        }
        boolean included = false;
        Iterator<Resource> iterator2 = orderedJars.iterator();
        while (iterator2.hasNext() && !(included = (r = iterator2.next()).equals(sciResource))) {
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}Excluded {} found={}", new Object[]{included ? "!" : "", sci, included});
        }
        return !included;
    }

    public boolean matchesExclusionPattern(State state, ServletContainerInitializer sci) {
        if (state._sciExcludePattern == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking {} against containerInitializerExclusionPattern", (Object)sci.getClass().getName());
        }
        return state._sciExcludePattern.matcher(sci.getClass().getName()).matches();
    }

    public boolean isFromContainerClassPath(WebAppContext context, ServletContainerInitializer sci) {
        if (sci == null) {
            return false;
        }
        ClassLoader sciLoader = sci.getClass().getClassLoader();
        if (sciLoader == null) {
            return true;
        }
        if (context.getClassLoader() == null) {
            return true;
        }
        for (ClassLoader loader = sciLoader; loader != null; loader = loader.getParent()) {
            if (loader != context.getClassLoader()) continue;
            return false;
        }
        return true;
    }

    public boolean isFromWebInfClasses(WebAppContext context, Resource sci) {
        for (Resource dir : context.getMetaData().getWebInfClassesResources()) {
            if (!dir.equals(sci)) continue;
            return true;
        }
        return false;
    }

    protected List<ServletContainerInitializer> getNonExcludedInitializers(State state) {
        WebAppContext context = state._context;
        ArrayList<ServletContainerInitializer> nonExcludedInitializers = new ArrayList<ServletContainerInitializer>();
        long start = NanoTime.now();
        List scis = TypeUtil.serviceProviderStream(ServiceLoader.load(ServletContainerInitializer.class)).flatMap(provider -> {
            try {
                return Stream.of((ServletContainerInitializer)provider.get());
            }
            catch (Error e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error: {} for {}", new Object[]{e.getMessage(), state._context, e});
                } else {
                    LOG.info("Error: {} for {}", (Object)e.getMessage(), (Object)state._context);
                }
                return Stream.of(new ServletContainerInitializer[0]);
            }
        }).toList();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Service loaders found in {}ms", (Object)NanoTime.millisSince(start));
        }
        HashMap sciResourceMap = new HashMap();
        ServletContainerInitializerOrdering initializerOrdering = this.getInitializerOrdering(context);
        for (Object sci : scis) {
            if (this.matchesExclusionPattern(state, (ServletContainerInitializer)sci)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} excluded by pattern", sci);
                continue;
            }
            Resource resource = this.getJarFor(context, (ServletContainerInitializer)sci);
            if (this.isFromExcludedJar(context, (ServletContainerInitializer)sci, resource)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} is from excluded jar", sci);
                continue;
            }
            String name = sci.getClass().getName();
            if (initializerOrdering != null && !initializerOrdering.hasWildcard() && initializerOrdering.getIndexOf(name) < 0) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} is excluded by ordering", sci);
                continue;
            }
            sciResourceMap.put(sci, resource);
        }
        if (initializerOrdering != null && !initializerOrdering.isDefaultOrder()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ordering ServletContainerInitializers with {}", (Object)initializerOrdering);
            }
            nonExcludedInitializers.addAll(sciResourceMap.keySet());
            nonExcludedInitializers.sort(new ServletContainerInitializerComparator(initializerOrdering));
        } else {
            int lastContainerSCI = -1;
            for (Map.Entry entry : sciResourceMap.entrySet()) {
                if (((ServletContainerInitializer)entry.getKey()).getClass().getClassLoader() == context.getClassLoader().getParent()) {
                    nonExcludedInitializers.add(++lastContainerSCI, (ServletContainerInitializer)entry.getKey());
                    continue;
                }
                if (entry.getValue() == null) {
                    nonExcludedInitializers.add((ServletContainerInitializer)entry.getKey());
                    continue;
                }
                for (Resource resource : context.getMetaData().getWebInfClassesResources()) {
                    if (!resource.equals(entry.getValue())) continue;
                    nonExcludedInitializers.add((ServletContainerInitializer)entry.getKey());
                }
            }
            for (ServletContainerInitializer servletContainerInitializer : nonExcludedInitializers) {
                sciResourceMap.remove(servletContainerInitializer);
            }
            if (context.getMetaData().getOrdering() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No web.xml ordering, ServletContainerInitializers in random order");
                }
                nonExcludedInitializers.addAll(sciResourceMap.keySet());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ordering ServletContainerInitializers with ordering {}", (Object)context.getMetaData().getOrdering());
                }
                for (Resource resource : context.getMetaData().getWebInfResources(true)) {
                    for (Map.Entry entry : sciResourceMap.entrySet()) {
                        if (!resource.equals(entry.getValue())) continue;
                        nonExcludedInitializers.add((ServletContainerInitializer)entry.getKey());
                    }
                }
            }
        }
        if (context.getServletContext().getEffectiveMajorVersion() < 3 && !context.isConfigurationDiscovered()) {
            ListIterator it = nonExcludedInitializers.listIterator();
            while (it.hasNext()) {
                Object sci;
                sci = (ServletContainerInitializer)it.next();
                if (this.isFromContainerClassPath(context, (ServletContainerInitializer)sci)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring SCI {}: old web.xml version {}.{}", new Object[]{sci.getClass().getName(), context.getServletContext().getEffectiveMajorVersion(), context.getServletContext().getEffectiveMinorVersion()});
                }
                it.remove();
            }
        }
        if (LOG.isDebugEnabled()) {
            int i = 0;
            for (ServletContainerInitializer servletContainerInitializer : nonExcludedInitializers) {
                LOG.debug("ServletContainerInitializer: {} {} from {}", new Object[]{++i, servletContainerInitializer.getClass().getName(), sciResourceMap.get(servletContainerInitializer)});
            }
        }
        return nonExcludedInitializers;
    }

    public ServletContainerInitializerOrdering getInitializerOrdering(WebAppContext context) {
        if (context == null) {
            return null;
        }
        String tmp = (String)context.getAttribute(SERVLET_CONTAINER_INITIALIZER_ORDER);
        if (StringUtil.isBlank(tmp)) {
            return null;
        }
        return new ServletContainerInitializerOrdering(tmp);
    }

    public void parseContainerPath(WebAppContext context, AnnotationParser parser) {
        State state = this.getState(context);
        HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
        handlers.addAll(state._discoverableAnnotationHandlers);
        handlers.addAll(state._containerInitializerAnnotationHandlers);
        if (state._classInheritanceHandler != null) {
            handlers.add(state._classInheritanceHandler);
        }
        if (LOG.isDebugEnabled()) {
            state._containerPathStats = new CounterStatistic();
        }
        for (Resource r : context.getMetaData().getContainerResources()) {
            if (state._parserTasks == null) continue;
            ParserTask task = new ParserTask(parser, handlers, r);
            state._parserTasks.add(task);
            if (!LOG.isDebugEnabled()) continue;
            state._containerPathStats.increment();
            task.setStatistic(new TimeStatistic());
        }
    }

    protected void parseWebInfLib(State state, AnnotationParser parser) throws Exception {
        WebAppContext context = state._context;
        List<Resource> jars = context.getMetaData().getWebInfResources(context.getMetaData().isOrdered());
        if (LOG.isDebugEnabled() && state._webInfLibStats == null) {
            state._webInfLibStats = new CounterStatistic();
        }
        for (Resource r : jars) {
            HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
            FragmentDescriptor f = context.getMetaData().getFragmentDescriptorForJar(r);
            if (WebDescriptor.isMetaDataComplete(f) && state._classInheritanceHandler == null && state._containerInitializerAnnotationHandlers.isEmpty()) continue;
            if (state._classInheritanceHandler != null) {
                handlers.add(state._classInheritanceHandler);
            }
            handlers.addAll(state._containerInitializerAnnotationHandlers);
            if (!WebDescriptor.isMetaDataComplete(f)) {
                handlers.addAll(state._discoverableAnnotationHandlers);
            }
            if (state._parserTasks == null) continue;
            ParserTask task = new ParserTask(parser, handlers, r);
            state._parserTasks.add(task);
            if (!LOG.isDebugEnabled()) continue;
            state._webInfLibStats.increment();
            task.setStatistic(new TimeStatistic());
        }
    }

    protected void parseWebInfClasses(State state, AnnotationParser parser) {
        WebAppContext context = state._context;
        HashSet<AbstractDiscoverableAnnotationHandler> handlers = new HashSet<AbstractDiscoverableAnnotationHandler>(state._discoverableAnnotationHandlers);
        if (state._classInheritanceHandler != null) {
            handlers.add((AbstractDiscoverableAnnotationHandler)((Object)state._classInheritanceHandler));
        }
        handlers.addAll(state._containerInitializerAnnotationHandlers);
        if (LOG.isDebugEnabled()) {
            state._webInfClassesStats = new CounterStatistic();
        }
        for (Resource dir : context.getMetaData().getWebInfClassesResources()) {
            if (state._parserTasks == null) continue;
            ParserTask task = new ParserTask(parser, handlers, dir);
            state._parserTasks.add(task);
            if (!LOG.isDebugEnabled()) continue;
            state._webInfClassesStats.increment();
            task.setStatistic(new TimeStatistic());
        }
    }

    protected static class State {
        public final WebAppContext _context;
        public final List<AbstractDiscoverableAnnotationHandler> _discoverableAnnotationHandlers = new ArrayList<AbstractDiscoverableAnnotationHandler>();
        public final List<ContainerInitializerAnnotationHandler> _containerInitializerAnnotationHandlers = new ArrayList<ContainerInitializerAnnotationHandler>();
        public final List<DiscoveredServletContainerInitializerHolder> _sciHolders = new ArrayList<DiscoveredServletContainerInitializerHolder>();
        public ClassInheritanceHandler _classInheritanceHandler;
        public List<ParserTask> _parserTasks;
        public CounterStatistic _containerPathStats;
        public CounterStatistic _webInfLibStats;
        public CounterStatistic _webInfClassesStats;
        public Pattern _sciExcludePattern;

        State(WebAppContext context) {
            this._context = context;
        }
    }

    public static class DiscoveredServletContainerInitializerHolder
    extends ServletContainerInitializerHolder {
        private final Set<Class<?>> _handlesTypes = new HashSet();
        private final Set<String> _discoveredClassNames = new HashSet<String>();

        public DiscoveredServletContainerInitializerHolder(Source source, ServletContainerInitializer sci, Class<?> ... startupClasses) {
            super(source, sci, new Class[0]);
            this._handlesTypes.addAll(this._startupClasses);
        }

        @Override
        public void addStartupClasses(String ... names) {
            this._discoveredClassNames.addAll(Arrays.asList(names));
        }

        @Override
        public void addStartupClasses(Class<?> ... clazzes) {
            this._handlesTypes.addAll(Arrays.asList(clazzes));
        }

        @Override
        protected Set<Class<?>> resolveStartupClasses() throws Exception {
            HashSet classes = new HashSet();
            WebAppClassLoader.runWithServerClassAccess(() -> {
                for (String name : this._startupClassNames) {
                    classes.add(Loader.loadClass(name));
                }
                return null;
            });
            return classes;
        }

        void resolveClasses(Map<String, Set<String>> classMap) {
            HashSet<String> finalClassnames = new HashSet<String>();
            if (classMap != null) {
                for (Class<?> c : this._handlesTypes) {
                    if (c.isAnnotation()) continue;
                    this.addInheritedTypes(finalClassnames, classMap, classMap.get(c.getName()));
                }
                for (String classname : this._discoveredClassNames) {
                    finalClassnames.add(classname);
                    this.addInheritedTypes(finalClassnames, classMap, classMap.get(classname));
                }
            }
            super.addStartupClasses(finalClassnames.toArray(new String[0]));
        }

        private void addInheritedTypes(Set<String> results, Map<String, Set<String>> classMap, Set<String> names) {
            if (names == null || names.isEmpty()) {
                return;
            }
            for (String s2 : names) {
                results.add(s2);
                this.addInheritedTypes(results, classMap, classMap.get(s2));
            }
        }
    }

    public static class ClassInheritanceMap
    extends ConcurrentHashMap<String, Set<String>> {
        @Override
        public String toString() {
            return String.format("ClassInheritanceMap@%x{size=%d}", this.hashCode(), this.size());
        }
    }

    public static class ParserTask
    implements Callable<Void> {
        protected final AnnotationParser _parser;
        protected final Set<? extends AnnotationParser.Handler> _handlers;
        protected final Resource _resource;
        protected TimeStatistic _stat;

        public ParserTask(AnnotationParser parser, Set<? extends AnnotationParser.Handler> handlers, Resource resource) {
            this._parser = parser;
            this._handlers = handlers;
            this._resource = resource;
        }

        public void setStatistic(TimeStatistic stat) {
            this._stat = stat;
        }

        @Override
        public Void call() throws Exception {
            if (this._stat != null) {
                this._stat.start();
            }
            if (this._parser != null) {
                this._parser.parse(this._handlers, this._resource);
            }
            if (this._stat != null) {
                this._stat.end();
            }
            return null;
        }

        public TimeStatistic getStatistic() {
            return this._stat;
        }

        public Resource getResource() {
            return this._resource;
        }
    }

    public static class TimeStatistic {
        public long _start = 0L;
        public long _end = 0L;

        public void start() {
            this._start = NanoTime.now();
        }

        public void end() {
            this._end = NanoTime.now();
        }

        public long getElapsedNanos() {
            return NanoTime.elapsed(this._start, this._end);
        }
    }

    public static class ServletContainerInitializerOrdering {
        private final Map<String, Integer> _indexMap = new HashMap<String, Integer>();
        private Integer _star = null;
        private String _ordering = null;

        public ServletContainerInitializerOrdering(String ordering) {
            if (ordering != null) {
                this._ordering = ordering;
                String[] tmp = StringUtil.csvSplit(ordering);
                for (int i = 0; i < tmp.length; ++i) {
                    String s2 = tmp[i].trim();
                    this._indexMap.put(s2, i);
                    if (!"*".equals(s2)) continue;
                    if (this._star != null) {
                        throw new IllegalArgumentException("Duplicate wildcards in ServletContainerInitializer ordering " + ordering);
                    }
                    this._star = i;
                }
            }
        }

        public boolean hasWildcard() {
            return this._star != null;
        }

        public int getWildcardIndex() {
            if (!this.hasWildcard()) {
                return -1;
            }
            return this._star;
        }

        public boolean isDefaultOrder() {
            return this.getSize() == 1 && this.hasWildcard();
        }

        public int getIndexOf(String name) {
            Integer i = this._indexMap.get(name);
            if (i == null) {
                return -1;
            }
            return i;
        }

        public int getSize() {
            return this._indexMap.size();
        }

        public String toString() {
            if (this._ordering == null) {
                return "";
            }
            return this._ordering;
        }
    }

    public static class ServletContainerInitializerComparator
    implements Comparator<ServletContainerInitializer> {
        private final ServletContainerInitializerOrdering _ordering;

        public ServletContainerInitializerComparator(ServletContainerInitializerOrdering ordering) {
            this._ordering = ordering;
        }

        @Override
        public int compare(ServletContainerInitializer sci1, ServletContainerInitializer sci2) {
            int i2;
            String c2;
            String c1 = sci1 != null ? sci1.getClass().getName() : null;
            String string = c2 = sci2 != null ? sci2.getClass().getName() : null;
            if (c1 == null && c2 == null) {
                return 0;
            }
            int i1 = this._ordering.getIndexOf(c1);
            if (i1 < 0 && this._ordering.hasWildcard()) {
                i1 = this._ordering.getWildcardIndex();
            }
            if ((i2 = this._ordering.getIndexOf(c2)) < 0 && this._ordering.hasWildcard()) {
                i2 = this._ordering.getWildcardIndex();
            }
            return Integer.compare(i1, i2);
        }
    }
}

