/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.reactor.core.publisher;

import com.dataiku.dss.shadelib.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelib.reactor.core.Scannable;
import com.dataiku.dss.shadelib.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelib.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelib.reactor.core.publisher.SourceProducer;
import com.dataiku.dss.shadelib.reactor.util.context.Context;
import com.dataiku.dss.shadelib.reactor.util.context.ContextView;
import java.util.Objects;
import java.util.function.Function;

final class MonoDeferContextual<T>
extends Mono<T>
implements SourceProducer<T> {
    final Function<ContextView, ? extends Mono<? extends T>> contextualMonoFactory;

    MonoDeferContextual(Function<ContextView, ? extends Mono<? extends T>> contextualMonoFactory) {
        this.contextualMonoFactory = Objects.requireNonNull(contextualMonoFactory, "contextualMonoFactory");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Mono<T> p;
        Context ctx = actual.currentContext();
        try {
            p = Objects.requireNonNull(this.contextualMonoFactory.apply(ctx), "The Mono returned by the contextualMonoFactory is null");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, ctx));
            return;
        }
        p.subscribe(actual);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

