/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.lambda.mgmt.LambdaServicesCRUDService;
import com.dataiku.dip.lambda.mgmt.PackagesMgmtServiceImpl;
import com.dataiku.dip.lambda.mgmt.PackagesService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ZipUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.lambda.model.serverconfig.LambdaAuthMethod;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/apiservices"})
public class PublicAPILambdaController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private LambdaServicesCRUDService crudService;
    @Autowired
    private PackagesMgmtServiceImpl packagesMgmtService;
    @Autowired
    private PackagesService packagesService;
    @Autowired
    private FutureService futureService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ProjectsService projectsService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.lambda");

    @AuditedCall(value={"msgType", "api-services-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List<LambdaService> services = this.crudService.list(projectKey);
            ArrayList<ServiceHead> res = new ArrayList<ServiceHead>(services.size());
            for (LambdaService service : services) {
                ServiceHead s = new ServiceHead();
                s.id = service.id;
                s.projectKey = service.projectKey;
                s.name = service.name;
                s.publicAccess = service.authMethod == LambdaAuthMethod.PUBLIC;
                s.authMethod = service.authMethod;
                for (DSSLambdaEndpointConfig endpoint : service.endpoints) {
                    EndpointHead e = new EndpointHead();
                    e.id = endpoint.id;
                    e.type = endpoint.type;
                    s.endpoints.add(e);
                }
                res.add(s);
            }
            PublicAPILambdaController.writeJSON((HttpServletResponse)resp, res);
        }
    }

    @AuditedCall(value={"msgType", "api-services-create", "projectKey", "${projectKey}", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/{serviceId:.+}"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String serviceId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.crudService.create(projectKey, serviceId);
            rwt.commit("Created API service " + serviceId);
        }
    }

    @AuditedCall(value={"msgType", "api-services-get", "projectKey", "${projectKey}", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/{serviceId}/settings"}, method={RequestMethod.GET})
    public void getServiceSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String serviceId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            LambdaService config = this.crudService.getOrNull(projectKey, serviceId);
            if (config == null) {
                throw new NotFoundException("Service " + serviceId + " not found");
            }
            if (config.authRealm != null) {
                config.authRealm.decryptKeysIfEncrypted(this.passwordEncryptionService);
            }
            PublicAPILambdaController.writeJSON((HttpServletResponse)resp, (Object)config);
        }
    }

    @AuditedCall(value={"msgType", "api-services-save", "projectKey", "${projectKey}", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/{serviceId}/settings"}, method={RequestMethod.PUT})
    public void saveServiceSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String serviceId) throws Exception {
        AuthCtx authCtx;
        LambdaService config = (LambdaService)this.getRequestBodyAs(req, LambdaService.class);
        config.projectKey = projectKey;
        config.id = serviceId;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.crudService.save(config);
            rwt.commit("Updated API service config (serviceId=" + serviceId + ") from API");
        }
    }

    @AuditedCall(value={"msgType", "api-services-get-package-summary", "projectKey", "${projectKey}", "serviceId", "${serviceId}", "packageId", "${packageId}"})
    @RequestMapping(value={"/{serviceId}/packages/{packageId}/summary"}, method={RequestMethod.GET})
    public void getPackageSummary(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String serviceId, @PathVariable String packageId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        File dir = this.packagesService.get(projectKey, serviceId, packageId);
        File packageArchive = new File(dir, "package.zip");
        if (!packageArchive.exists()) {
            throw new FileNotFoundException("Package archive does not exist: " + packageArchive.getAbsolutePath());
        }
        LambdaServiceGenTag tagInfo = (LambdaServiceGenTag)ZipUtils.readFileContentJSON((File)packageArchive, (String)"tag.json", LambdaServiceGenTag.class);
        if (tagInfo == null) {
            throw new FileNotFoundException(String.format("Package '%s' doesn't contain required details", packageId));
        }
        Package packageSummary = new Package();
        packageSummary.id = packageId;
        packageSummary.createdOn = tagInfo.createdOn;
        packageSummary.releaseNotes = tagInfo.releaseNotes;
        PublicAPILambdaController.writeJSON((HttpServletResponse)resp, (Object)packageSummary);
    }

    @AuditedCall(value={"msgType", "api-services-get", "projectKey", "${projectKey}", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/{serviceId}/packages"}, method={RequestMethod.GET})
    public void getPackages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String serviceId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List<LambdaService.LambdaServiceSummary.Package> packageSummaries = this.packagesService.listSummaries(projectKey, serviceId);
            ArrayList<Package> res = new ArrayList<Package>(packageSummaries.size());
            for (LambdaService.LambdaServiceSummary.Package summary : packageSummaries) {
                Package p = new Package();
                p.id = summary.id;
                p.createdOn = summary.mtime;
                res.add(p);
            }
            PublicAPILambdaController.writeJSON((HttpServletResponse)resp, res);
        }
    }

    @AuditedCall(value={"msgType", "api-services-download", "projectKey", "${projectKey}", "serviceId", "${serviceId}", "packageId", "${packageId}"})
    @RequestMapping(value={"/{serviceId}/packages/{packageId}/archive"}, method={RequestMethod.GET})
    public void downloadPackage(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String serviceId, @PathVariable String packageId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            File dir = this.packagesService.get(projectKey, serviceId, packageId);
            File zip = new File(dir, "package.zip");
            if (!zip.exists()) {
                throw new FileNotFoundException("Package archive does not exist " + zip.getAbsolutePath());
            }
            resp.setHeader("Content-Length", "" + zip.length());
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + serviceId + "_" + packageId + ".zip\"");
            try (FileInputStream fis = new FileInputStream(zip);){
                IOUtils.copyLarge((InputStream)fis, (OutputStream)resp.getOutputStream());
            }
        }
    }

    @AuditedCall(value={"msgType", "api-services-package", "projectKey", "${projectKey}", "serviceId", "${serviceId}", "packageId", "${packageId}"})
    @RequestMapping(value={"/{serviceId}/packages/{packageId:.+}"}, method={RequestMethod.POST})
    public void createPackage(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String serviceId, @PathVariable String packageId, @RequestParam(required=false) @Nullable String releaseNotes) throws Exception {
        FutureResponse fr;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            File pdir = this.packagesService.mkdir(projectKey, serviceId, packageId);
            LambdaService service = this.crudService.getOrNull(projectKey, serviceId);
            if (StringUtils.isNotBlank((String)releaseNotes)) {
                VariablesContext context = this.variablesService.getForProject(projectKey);
                service.releaseNotes = context.expandAllowUnresolved(releaseNotes).trim();
            }
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            fr = this.packagesMgmtService.startGeneratingPackage(pdir, projectKey, service, project.permissions, t.getUser(), false);
        }
        fr = this.futureService.waitForFinalResponse(fr);
        this.writeMessage(resp, "Created package %s", new Object[]{packageId});
    }

    @AuditedCall(value={"msgType", "api-services-package-delete", "projectKey", "${projectKey}", "serviceId", "${serviceId}", "packageId", "${packageId}"})
    @RequestMapping(value={"/{serviceId}/packages/{packageId:.+}"}, method={RequestMethod.DELETE})
    public void deletePackage(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String serviceId, @PathVariable String packageId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.packagesService.delete(projectKey, serviceId, packageId);
        }
        catch (FileNotFoundException fne) {
            throw new NotFoundException("Package does not exist: " + packageId);
        }
        this.writeMessage(resp, "Deleted package %s", new Object[]{packageId});
    }

    @AuditedCall(value={"msgType", "api-services-publish", "projectKey", "${projectKey}", "serviceId", "${serviceId}", "packageId", "${packageId}"})
    @RequestMapping(value={"/{serviceId}/packages/{packageId}/publish"}, method={RequestMethod.POST})
    public void publishVersionToDeployer(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String serviceId, @PathVariable String packageId, @RequestParam(required=false) String publishedServiceId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        this.packagesService.publish_NT(authCtx, projectKey, serviceId, packageId, publishedServiceId);
    }

    static class ServiceHead {
        String id;
        String projectKey;
        String name;
        @Deprecated
        boolean publicAccess;
        LambdaAuthMethod authMethod;
        List<EndpointHead> endpoints = new ArrayList<EndpointHead>();

        ServiceHead() {
        }
    }

    static class EndpointHead {
        String id;
        LambdaEndpointConfig.EndpointType type;

        EndpointHead() {
        }
    }

    static class Package {
        String id;
        long createdOn;
        @Nullable
        String releaseNotes;

        Package() {
        }
    }
}

