/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.prediction.MLflowOrigin;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetHandler;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetParams;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.experimenttracking.Experiment;
import com.dataiku.dip.experimenttracking.ExperimentTag;
import com.dataiku.dip.experimenttracking.ExperimentTrackingService;
import com.dataiku.dip.experimenttracking.Model;
import com.dataiku.dip.experimenttracking.Run;
import com.dataiku.dip.experimenttracking.RunMetric;
import com.dataiku.dip.experimenttracking.RunParam;
import com.dataiku.dip.experimenttracking.RunTag;
import com.dataiku.dip.experimenttracking.ViewType;
import com.dataiku.dip.experimenttracking.mlflowfilter.MLflowFilterParsingException;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.externalml.mlflow.MLflowModelDeployResult;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.savedmodels.SavedModelsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.api.PublicAPICodes;
import com.dataiku.dip.server.api.PublicAPIMLflowBaseController;
import com.dataiku.dip.server.api.PublicAPIMLflowRepositoryController;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.mlflow.api.proto.Service;
import com.dataiku.dss.shadelib.org.mlflow_project.google.protobuf.InvalidProtocolBufferException;
import com.dataiku.dss.shadelib.org.mlflow_project.google.protobuf.MessageOrBuilder;
import com.dataiku.dss.shadelib.org.mlflow_project.google.protobuf.util.JsonFormat;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/api/{version:\\d\\.\\d}/mlflow"})
public class PublicAPIMLflowExperimentTrackingController
extends PublicAPIMLflowBaseController {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private ExperimentTrackingService experimentTrackingService;
    @Autowired
    private SavedModelsService savedModelsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;

    @AuditInline
    @RequestMapping(value={"/experiments/create", "/preview/mlflow/experiments/create"}, method={RequestMethod.POST})
    public void createExperiment(HttpServletRequest req, HttpServletResponse resp, @RequestBody DSSCreateExperiment params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            ManagedFolder mf;
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
                mf = this.getManagedFolderFromHeaders(req);
            }
            String artifactsRoot = this.buildArtifactRootUriFromManagedFolder(projectKey, mf);
            String experimentId = this.experimentTrackingService.createExperiment(artifactsRoot, projectKey, params.name, params.artifact_location, params.tags);
            this.auditTrailService.generic("mlflow-experiment-create").with("projectKey", projectKey).with("name", params.name).with("artifactLocation", params.artifact_location).emit();
            resp.setStatus(200);
            resp.getWriter().print(JsonFormat.printer().print((MessageOrBuilder)Service.CreateExperiment.Response.newBuilder().setExperimentId(experimentId)));
        }
        catch (SQLException e) {
            this.auditTrailService.failure("mlflow-experiment-create", (Throwable)e).with("projectKey", projectKey).with("name", params.name).with("artifactLocation", params.artifact_location).emit();
            this.returnMLflowError(resp, 400, "RESOURCE_ALREADY_EXISTS", "Error creating an experiment named `" + params.name + "'. Check that no experiment with the same name exists.");
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-experiment-create", (Throwable)e).with("projectKey", projectKey).with("name", params.name).with("artifactLocation", params.artifact_location).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/experiments/get", "/preview/mlflow/experiments/get"}, method={RequestMethod.GET})
    public String getExperiment(HttpServletRequest req, @RequestParam(value="experiment_id") String experimentId) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkRead(req, projectKey);
            }
            Service.Experiment experiment = this.experimentTrackingService.getExperiment(projectKey, experimentId).toMLflowExperiment();
            this.auditTrailService.generic("mlflow-experiments-get").with("projectKey", projectKey).with("experimentId", experimentId).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.GetExperiment.Response.newBuilder().setExperiment(experiment));
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-experiment-get", (Throwable)e).with("projectKey", projectKey).with("experimentId", experimentId).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/experiments/search", "/preview/mlflow/experiments/search"}, method={RequestMethod.POST})
    public void searchExperiments(HttpServletRequest req, HttpServletResponse resp, @RequestBody DSSExperimentSearch params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        Service.ViewType viewType = params.view_type != null ? params.view_type : Service.ViewType.ACTIVE_ONLY;
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkRead(req, projectKey);
            }
            List experiments = Experiment.toMLflowExperiments((List)this.experimentTrackingService.searchExperiments_NT(projectKey, ViewType.fromMLflowViewType((Service.ViewType)viewType), params.filter, params.max_results, params.order_by));
            this.auditTrailService.generic("mlflow-experiments-search").with("projectKey", projectKey).with("view_type", params.view_type != null ? params.view_type.toString() : null).with("filter", params.filter).with("max_results", (Number)params.max_results).with("order_by", StringUtils.join(params.order_by, (String)", ")).emit();
            resp.setStatus(200);
            resp.getWriter().print(JsonFormat.printer().print((MessageOrBuilder)Service.SearchExperiments.Response.newBuilder().addAllExperiments((Iterable)experiments)));
        }
        catch (MLflowFilterParsingException e) {
            this.auditTrailService.failure("mlflow-experiments-search", (Throwable)e).with("projectKey", projectKey).with("view_type", params.view_type != null ? params.view_type.toString() : null).with("filter", params.filter).with("max_results", (Number)params.max_results).with("order_by", StringUtils.join(params.order_by, (String)", ")).emit();
            this.returnMLflowError(resp, 400, "BAD_REQUEST", "Error parsing search experiments filter: " + e.getMessage());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-experiments-search", (Throwable)e).with("projectKey", projectKey).with("view_type", params.view_type != null ? params.view_type.toString() : null).with("filter", params.filter).with("max_results", (Number)params.max_results).with("order_by", StringUtils.join(params.order_by, (String)", ")).emit();
            throw e;
        }
    }

    private void returnMLflowError(HttpServletResponse resp, int httpCode, String mlFlowerrorCode, String message) throws IOException {
        resp.setStatus(httpCode);
        resp.getWriter().print(JSON.json((Object)new DSSErrorMesssage(mlFlowerrorCode, message)));
    }

    @AuditInline
    @RequestMapping(value={"/experiments/get-by-name", "/preview/mlflow/experiments/get-by-name"}, method={RequestMethod.GET})
    public void getExperimentByName(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="experiment_name") String experimentName) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkRead(req, projectKey);
            }
            try {
                Service.Experiment experiment = this.experimentTrackingService.getExperimentByName(projectKey, experimentName).toMLflowExperiment();
                this.auditTrailService.generic("mlflow-experiments-get-by-name").with("projectKey", projectKey).with("experimentName", experimentName).emit();
                resp.setStatus(200);
                resp.getWriter().print(JsonFormat.printer().print((MessageOrBuilder)Service.GetExperiment.Response.newBuilder().setExperiment(experiment)));
            }
            catch (NotFoundException nfe) {
                this.auditTrailService.generic("mlflow-experiments-get-by-name").with("projectKey", projectKey).with("experimentName", experimentName).emit();
                this.returnMLflowError(resp, 404, "RESOURCE_DOES_NOT_EXIST", "Experiment with name " + experimentName + " not found");
            }
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-experiments-get-by-name", (Throwable)e).with("projectKey", projectKey).with("experimentName", experimentName).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/experiments/delete", "/preview/mlflow/experiments/delete"}, method={RequestMethod.POST})
    public String lifecycleDeleteExperiment(HttpServletRequest req, @RequestBody DSSExperimentOperation param) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.deleteExperiment(projectKey, param.experiment_id);
            this.auditTrailService.generic("mlflow-experiments-lifecycle-delete").with("projectKey", projectKey).with("experimentId", param.experiment_id).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.DeleteExperiment.Response.newBuilder());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-experiments-lifecycle-delete", (Throwable)e).with("projectKey", projectKey).with("experimentId", param.experiment_id).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/experiments/restore", "/preview/mlflow/experiments/restore"}, method={RequestMethod.POST})
    public void lifecycleRestoreExperiment(HttpServletRequest req, HttpServletResponse resp, @RequestBody DSSExperimentOperation param) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.restoreExperiment(projectKey, param.experiment_id);
            this.auditTrailService.generic("mlflow-experiments-lifecycle-restore").with("projectKey", projectKey).with("experimentId", param.experiment_id).emit();
            resp.setStatus(200);
            resp.getWriter().print(JsonFormat.printer().print((MessageOrBuilder)Service.DeleteExperiment.Response.newBuilder()));
        }
        catch (InvalidParameterException ipe) {
            this.returnMLflowError(resp, 400, "RESOURCE_ALREADY_EXISTS", ipe.getMessage());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-experiments-lifecycle-restore", (Throwable)e).with("projectKey", projectKey).with("experimentId", param.experiment_id).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/create", "/preview/mlflow/runs/create"}, method={RequestMethod.POST})
    public String createRun(HttpServletRequest req, @RequestBody DSSCreateRun params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        if (params.run_name != null) {
            if (params.tags == null) {
                params.tags = new ArrayList<RunTag>();
            }
            params.tags.add(new RunTag("mlflow.runName", params.run_name));
        }
        try {
            ManagedFolder mf;
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.checkWrite(req, projectKey);
                mf = this.getManagedFolderFromHeaders(req);
            }
            String artifactsRoot = this.buildArtifactRootUriFromManagedFolder(projectKey, mf);
            this.addDSSUserTag(params, authCtx);
            Service.Run run = this.experimentTrackingService.createRun(artifactsRoot, projectKey, params.experiment_id, params.user_id, params.start_time, params.tags).toMLflowRun();
            this.auditTrailService.generic("mlflow-run-create").with("projectKey", projectKey).with("experimentId", params.experiment_id).with("userId", params.user_id).with("startTime", (Number)params.start_time).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.CreateRun.Response.newBuilder().setRun(run));
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-run-create", (Throwable)e).with("projectKey", projectKey).with("experimentId", params.experiment_id).with("userId", params.user_id).with("startTime", (Number)params.start_time).emit();
            throw e;
        }
    }

    private void addDSSUserTag(DSSCreateRun params, AuthCtx authCtx) {
        RunTag dssUserTag = new RunTag("dku-ext.dssUser", authCtx.getIdentifier());
        if (params.tags == null) {
            params.tags = new ArrayList<RunTag>();
        }
        params.tags.add(dssUserTag);
    }

    private String buildArtifactRootUriFromManagedFolder(String contextProjectKey, ManagedFolder mf) {
        SmartObjectRef smartRef = SmartObjectRef.fromResolved((ITaggingService.TaggableType)ITaggingService.TaggableType.MANAGED_FOLDER, (String)mf.getProjectKey(), (String)mf.getId(), (String)contextProjectKey);
        return "dss-managed-folder://" + smartRef.getSmartName();
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/get", "/preview/mlflow/runs/get"}, method={RequestMethod.GET})
    public String getRun(HttpServletRequest req, @RequestParam(value="run_id") String runId) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkRead(req, projectKey);
            }
            Service.Run run = this.experimentTrackingService.getRun(projectKey, runId, false).toMLflowRun();
            this.auditTrailService.generic("mlflow-run-get").with("projectKey", projectKey).with("runId", runId).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.CreateRun.Response.newBuilder().setRun(run));
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-run-get", (Throwable)e).with("projectKey", projectKey).with("runId", runId).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/metrics/get-history", "/preview/mlflow/metrics/get-history"}, method={RequestMethod.GET})
    public String getMetricHistory(HttpServletRequest req, @RequestParam String run_id, @RequestParam String metric_key) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkRead(req, projectKey);
            }
            List metrics = this.experimentTrackingService.getMetricHistory(projectKey, run_id, metric_key).stream().map(RunMetric::toMLflowMetric).collect(Collectors.toList());
            this.auditTrailService.generic("mlflow-metrics-get-history").with("projectKey", projectKey).with("runId", run_id).with("metricKey", metric_key).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.GetMetricHistory.Response.newBuilder().addAllMetrics(metrics));
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-run-get", (Throwable)e).with("projectKey", projectKey).with("runId", run_id).with("metricKey", metric_key).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/update", "/preview/mlflow/runs/update"}, method={RequestMethod.POST})
    public String updateRun(HttpServletRequest req, @RequestBody DSSUpdateRun params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            Service.Run run = this.experimentTrackingService.setRunStatusEndTime(projectKey, params.run_id, params.status, params.end_time).toMLflowRun();
            this.auditTrailService.generic("mlflow-run-update").with("projectKey", projectKey).with("runId", params.run_id).with("status", params.status).with("endTime", (Number)params.end_time).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.UpdateRun.Response.newBuilder().setRunInfo(run.getInfo()));
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-run-update", (Throwable)e).with("projectKey", projectKey).with("runId", params.run_id).with("status", params.status).with("endTime", (Number)params.end_time).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/experiments/update", "/preview/mlflow/experiments/update"}, method={RequestMethod.POST})
    public void updateExperiment(HttpServletRequest req, HttpServletResponse resp, @RequestBody DSSUpdateExperiment params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.setExperimentName(projectKey, params.experiment_id, params.new_name);
            this.auditTrailService.generic("mlflow-experiment-update").with("projectKey", projectKey).with("experimentId", params.experiment_id).with("newName", params.new_name).emit();
            resp.setStatus(200);
            resp.getWriter().print(JsonFormat.printer().print((MessageOrBuilder)Service.UpdateExperiment.Response.newBuilder()));
        }
        catch (InvalidParameterException ipe) {
            this.returnMLflowError(resp, 400, "RESOURCE_ALREADY_EXISTS", "Error renaming experiment " + params.new_name + ". An active experiment has the same name.");
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-experiment-update", (Throwable)e).with("projectKey", projectKey).with("experimentId", params.experiment_id).with("newName", params.new_name).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/delete", "/preview/mlflow/runs/delete"}, method={RequestMethod.POST})
    public String deleteRun(HttpServletRequest req, @RequestBody DSSRunOperation params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            Service.Run run = this.experimentTrackingService.setRunLifecycle(projectKey, params.run_id, "deleted").toMLflowRun();
            this.auditTrailService.generic("mlflow-run-delete").with("projectKey", projectKey).with("runId", params.run_id).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.UpdateRun.Response.newBuilder().setRunInfo(run.getInfo()));
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-run-delete", (Throwable)e).with("projectKey", projectKey).with("runId", params.run_id).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/restore", "/preview/mlflow/runs/restore"}, method={RequestMethod.POST})
    public String restoreRun(HttpServletRequest req, @RequestBody DSSRunOperation params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            Service.Run run = this.experimentTrackingService.setRunLifecycle(projectKey, params.run_id, "active").toMLflowRun();
            this.auditTrailService.generic("mlflow-run-restore").with("projectKey", projectKey).with("runId", params.run_id).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.UpdateRun.Response.newBuilder().setRunInfo(run.getInfo()));
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-run-restore", (Throwable)e).with("projectKey", projectKey).with("runId", params.run_id).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/set-tag", "/preview/mlflow/runs/set-tag"}, method={RequestMethod.POST})
    public String setTag(HttpServletRequest req, @RequestBody DSSKeyValueParam params) throws DKUSecurityException, NotFoundException, SQLException, InvalidProtocolBufferException {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.setRunTag(projectKey, params.run_uuid, params.run_id, params.key, params.value);
            this.auditTrailService.generic("mlflow-set_tag").with("projectKey", projectKey).with("runId", params.run_id).with("key", params.key).with("value", params.value).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.SetTag.Response.newBuilder().build());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-set_tag", (Throwable)e).with("projectKey", projectKey).with("runId", params.run_id).with("key", params.key).with("value", params.value).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/experiments/set-experiment-tag", "/preview/mlflow/experiments/set-experiment-tag"}, method={RequestMethod.POST})
    public String setExperimentTag(HttpServletRequest req, @RequestBody DSSKeyValueParam params) throws DKUSecurityException, NotFoundException, SQLException, InvalidProtocolBufferException {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.setExperimentTag(projectKey, params.experiment_id, params.key, params.value);
            this.auditTrailService.generic("mlflow-set_tag").with("projectKey", projectKey).with("experimentId", params.experiment_id).with("key", params.key).with("value", params.value).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.SetTag.Response.newBuilder().build());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-set_tag", (Throwable)e).with("projectKey", projectKey).with("experimentId", params.experiment_id).with("key", params.key).with("value", params.value).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/delete-tag", "/preview/mlflow/runs/delete-tag"}, method={RequestMethod.POST})
    public String deleteTag(HttpServletRequest req, @RequestBody DSSKeyParam params) throws DKUSecurityException, NotFoundException, SQLException, InvalidProtocolBufferException {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.deleteRunTag(projectKey, params.run_id, params.key);
            this.auditTrailService.generic("mlflow-delete_tag").with("projectKey", projectKey).with("runId", params.run_id).with("key", params.key).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.DeleteTag.Response.newBuilder().build());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-delete_tag", (Throwable)e).with("projectKey", projectKey).with("runId", params.run_id).with("key", params.key).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/log-parameter", "/preview/mlflow/runs/log-parameter"}, method={RequestMethod.POST})
    public String logParameter(HttpServletRequest req, @RequestBody DSSKeyValueParam params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.insertParameter(projectKey, params.run_uuid, params.run_id, params.key, params.value);
            this.auditTrailService.generic("mlflow-log_param").with("projectKey", projectKey).with("runUUID", params.run_uuid).with("runId", params.run_id).with("key", params.key).with("value", params.value).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.LogParam.Response.newBuilder());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-log_param", (Throwable)e).with("projectKey", projectKey).with("runUUID", params.run_uuid).with("runId", params.run_id).with("key", params.key).with("value", params.value).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/log-metric", "/preview/mlflow/runs/log-metric"}, method={RequestMethod.POST})
    public String logMetric(HttpServletRequest req, @RequestBody DSSLogMetric params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.insertUpdateMetric(projectKey, params.run_uuid, params.run_id, params.key, Double.valueOf(params.value), params.timestamp, params.step);
            this.auditTrailService.generic("mlflow-log_metric").with("projectKey", projectKey).with("runUUID", params.run_uuid).with("runId", params.run_id).with("key", params.key).with("value", (Number)params.value).with("step", (Number)params.step).with("timestamp", (Number)params.timestamp).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.LogMetric.Response.newBuilder());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-log_metric", (Throwable)e).with("projectKey", projectKey).with("runUUID", params.run_uuid).with("runId", params.run_id).with("key", params.key).with("value", (Number)params.value).with("step", (Number)params.step).with("timestamp", (Number)params.timestamp).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/log-batch", "/preview/mlflow/runs/log-batch"}, method={RequestMethod.POST})
    public String logBatch(HttpServletRequest req, @RequestBody DSSLogBatch params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.logBatch(projectKey, params.run_id, params.metrics, params.params, params.tags);
            this.auditTrailService.generic("mlflow-log_batch").with("projectKey", projectKey).with("runId", params.run_id).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.LogMetric.Response.newBuilder());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-log_batch", (Throwable)e).with("projectKey", projectKey).with("runId", params.run_id).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/runs/search", "/preview/mlflow/runs/search"}, method={RequestMethod.POST})
    public void searchRuns(HttpServletRequest req, HttpServletResponse resp, @RequestBody DSSRunSearch params) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        Service.ViewType viewType = params.run_view_type != null ? params.run_view_type : Service.ViewType.ACTIVE_ONLY;
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkRead(req, projectKey);
            }
            List runs = Run.toMLflowRuns((List)this.experimentTrackingService.searchRuns_NT(projectKey, params.experiment_ids, ViewType.fromMLflowViewType((Service.ViewType)viewType), params.filter, params.max_results, params.order_by, false));
            this.auditTrailService.generic("mlflow-runs-search").with("projectKey", projectKey).with("experiment_ids", StringUtils.join(params.experiment_ids, (String)", ")).with("run_view_type", params.run_view_type != null ? params.run_view_type.toString() : null).with("filter", params.filter).with("max_results", (Number)params.max_results).with("order_by", StringUtils.join(params.order_by, (String)", ")).emit();
            resp.setStatus(200);
            resp.getWriter().print(JsonFormat.printer().print((MessageOrBuilder)Service.SearchRuns.Response.newBuilder().addAllRuns((Iterable)runs)));
        }
        catch (MLflowFilterParsingException e) {
            this.auditTrailService.failure("mlflow-runs-search", (Throwable)e).with("projectKey", projectKey).with("experiment_ids", StringUtils.join(params.experiment_ids, (String)", ")).with("run_view_type", params.run_view_type != null ? params.run_view_type.toString() : null).with("filter", params.filter).with("max_results", (Number)params.max_results).with("order_by", StringUtils.join(params.order_by, (String)", ")).emit();
            this.returnMLflowError(resp, 400, "BAD_REQUEST", "Error parsing search runs filter: " + e.getMessage());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-runs-search", (Throwable)e).with("projectKey", projectKey).with("experiment_ids", StringUtils.join(params.experiment_ids, (String)", ")).with("run_view_type", params.run_view_type != null ? params.run_view_type.toString() : null).with("filter", params.filter).with("max_results", (Number)params.max_results).with("order_by", StringUtils.join(params.order_by, (String)", ")).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/runs/log-model", "/preview/mlflow/runs/log-model"}, method={RequestMethod.POST})
    public String logModel(HttpServletRequest req, @RequestBody DSSLogRun params) throws Exception {
        DSSModelJson model_json = (DSSModelJson)JSON.parse((String)params.model_json, DSSModelJson.class);
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.logModel(projectKey, params.run_uuid, params.run_id, model_json.artifact_path);
            this.auditTrailService.generic("mlflow-log_model").with("projectKey", projectKey).with("runUUID", params.run_uuid).with("runId", params.run_id).with("artifactPath", model_json.artifact_path).emit();
            return JsonFormat.printer().print((MessageOrBuilder)Service.LogModel.Response.newBuilder());
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-log_batch", (Throwable)e).with("projectKey", projectKey).with("runUUID", params.run_uuid).with("runId", params.run_id).with("artifactPath", model_json.artifact_path).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/extension/models/{runId}"}, method={RequestMethod.GET})
    public List<Model> listModels(HttpServletRequest req, @PathVariable String runId) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkRead(req, projectKey);
            }
            List ret = this.experimentTrackingService.listRunModels(projectKey, runId);
            this.auditTrailService.generic("mlflow-list_models").with("projectKey", projectKey).with("runId", runId).emit();
            return ret;
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-log_batch", (Throwable)e).with("projectKey", projectKey).with("runId", runId).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/extension/garbage-collect"}, method={RequestMethod.POST})
    public void garbageCollect(HttpServletRequest req) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.checkWrite(req, projectKey);
            }
            this.experimentTrackingService.garbageCollect_NT(authCtx, projectKey);
            this.auditTrailService.generic("mlflow-garbage_collect").with("projectKey", projectKey).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("mlflow-garbage_collect", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "mlflow-clean-db", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/extension/clean-db/{projectKey}"}, method={RequestMethod.DELETE})
    public void cleanExperimentsDB(HttpServletRequest req, @PathVariable String projectKey) throws DKUSecurityException, SQLException {
        try (Transaction t = this.transactionService.beginRead();){
            this.checkAdmin(req, projectKey);
        }
        this.experimentTrackingService.cleanProject(projectKey);
    }

    @AuditedCall(value={"msgType", "create-project-experiments-dataset"})
    @RequestMapping(value={"/extension/create-project-experiments-dataset"}, method={RequestMethod.POST})
    public void createProjectExperimentsDataset(HttpServletRequest req, HttpServletResponse resp, @RequestBody DSSCreateETDataset queryParams) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.checkWrite(req, projectKey);
            DatasetHandler.DatasetMeta datasetMeta = DatasetHandlerFactory.getMeta((String)"ExperimentsDB");
            Dataset dataset = new Dataset();
            dataset.setFullName(projectKey + "." + queryParams.datasetName);
            datasetMeta.fillManagedDatasetParams(dataset, null, null);
            ExperimentsDBDatasetParams params = (ExperimentsDBDatasetParams)dataset.getParamsAs(ExperimentsDBDatasetParams.class);
            params.scope = ExperimentsDBDatasetParams.RetrievalScope.PROJECT;
            params.experimentIds = queryParams.experimentIds;
            params.viewType = ViewType.fromMLflowViewType((Service.ViewType)queryParams.viewType);
            params.filter = queryParams.filter;
            params.orderBy = queryParams.orderBy;
            params.format = queryParams.format;
            dataset.setSchema(ExperimentsDBDatasetHandler.getSchema((ExperimentsDBDatasetParams.RetrievalScope)params.scope, (ExperimentsDBDatasetParams.Format)params.format));
            DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
            PublicAPIMLflowExperimentTrackingController.writeJSON((HttpServletResponse)resp, (Object)this.datasetSaveService.create(projectKey, dataset.serialize(), dsCtx, authCtx));
            t.commit("Added dataset to view experiments of project " + projectKey + " in format " + String.valueOf(params.format));
        }
    }

    @AuditedCall(value={"msgType", "set_run_inference_info", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/extension/set-run-inference-info"}, method={RequestMethod.POST})
    public void setRunDeploymentInfo(HttpServletRequest req, @RequestBody DDSRunDeploymentInfo info) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkWrite(req, projectKey);
        }
        this.experimentTrackingService.setRunTag(projectKey, info.run_id, info.run_id, "dku-ext.predictionType", info.prediction_type);
        if (StringUtils.isNotEmpty((String)info.classes)) {
            this.experimentTrackingService.setRunTag(projectKey, info.run_id, info.run_id, "dku-ext.targetClasses", info.classes);
        }
        if (StringUtils.isNotEmpty((String)info.code_env_name)) {
            this.experimentTrackingService.setRunTag(projectKey, info.run_id, info.run_id, "dku-ext.codeEnv", info.code_env_name);
        }
        if (StringUtils.isNotEmpty((String)info.target)) {
            this.experimentTrackingService.setRunTag(projectKey, info.run_id, info.run_id, "dku-ext.target", info.target);
        }
    }

    private void retrieveInferenceInfo(Run run, MLFlowModelVersionInfo modelVersionInfo) {
        RunTag classesRT;
        RunTag targetRT;
        RunTag predictionTypeRT = run.data.runTags.stream().filter(tag -> tag.key.equals("dku-ext.predictionType")).findAny().orElse(null);
        PredictionMLTask.PredictionType predictionType = null;
        if (predictionTypeRT != null && !"OTHER".equals(predictionTypeRT.value)) {
            try {
                predictionType = PredictionMLTask.PredictionType.valueOf((String)predictionTypeRT.value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(predictionTypeRT.value + " is not a valid prediction type. Use \"REGRESSION\", \"BINARY_CLASSIFICATION\", \"MULTICLASS\" or \"OTHER\"");
            }
        }
        if (predictionType != null && !predictionType.supportsMLflowAndExternal()) {
            throw new IllegalArgumentException(predictionTypeRT.value + " prediction type is not supported for MLflow or External models. Use \"REGRESSION\", \"BINARY_CLASSIFICATION\", \"MULTICLASS\" or \"OTHER\"");
        }
        modelVersionInfo.predictionType = predictionType;
        RunTag codeEnvRT = run.data.runTags.stream().filter(tag -> tag.key.equals("dku-ext.codeEnv")).findAny().orElse(null);
        if (codeEnvRT != null) {
            modelVersionInfo.pythonCodeEnvName = codeEnvRT.value;
        }
        if ((targetRT = (RunTag)run.data.runTags.stream().filter(tag -> tag.key.equals("dku-ext.target")).findAny().orElse(null)) != null) {
            modelVersionInfo.targetColumnName = targetRT.value;
        }
        if ((classesRT = (RunTag)run.data.runTags.stream().filter(tag -> tag.key.equals("dku-ext.targetClasses")).findAny().orElse(null)) != null) {
            ArrayList<MLFlowModelVersionInfo.ClassLabel> classLabels = new ArrayList<MLFlowModelVersionInfo.ClassLabel>();
            List classes = (List)JSON.parse((String)classesRT.value, ArrayList.class);
            for (String aClass : classes) {
                MLFlowModelVersionInfo.ClassLabel label = new MLFlowModelVersionInfo.ClassLabel();
                label.label = aClass;
                classLabels.add(label);
            }
            modelVersionInfo.classLabels = classLabels;
        }
    }

    @AuditedCall(value={"msgType", "deploy-run", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @ResponseBody
    @RequestMapping(value={"/extension/deploy-run"}, method={RequestMethod.POST})
    public FutureResponse<MLflowModelDeployResult> deployRun(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String runId, @RequestParam String versionId, @RequestParam MLFlowModelVersionInfo modelVersionInfo, @RequestParam(defaultValue="") String modelSubfolder, @RequestParam(required=false) SamplingParam samplingParam, @RequestParam(defaultValue="true") boolean activate, @RequestParam(defaultValue="0.5") double binaryClassificationThreshold, @RequestParam(defaultValue="true") boolean useOptimalThreshold, @RequestParam(defaultValue="false") boolean skipExpensiveReports, @RequestParam(defaultValue="true") boolean useInferenceInfo) throws Exception {
        AuthCtx authCtx;
        Run run = this.experimentTrackingService.getRun(projectKey, runId, true);
        if (useInferenceInfo) {
            this.retrieveInferenceInfo(run, modelVersionInfo);
        }
        Object path = run.info.artifactUri.split("//")[1];
        String folderId = run.info.artifactUri.split("//")[1].split("/")[0];
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.checkWrite(req, projectKey);
            this.permissionsService.checkCodeEnvPrivileges(authCtx, CodeEnvModel.EnvLang.PYTHON, modelVersionInfo.pythonCodeEnvName, new Privileges.CodeEnvLevelPrivilegeType[]{Privileges.CodeEnvLevelPrivilegeType.USE});
        }
        if (modelSubfolder.equals("")) {
            List models = this.experimentTrackingService.listRunModels(projectKey, runId);
            if (models.size() != 1) {
                throw new RuntimeException("Unexpected multiple model folders in managed folder");
            }
            modelSubfolder = ((Model)models.get((int)0)).artifactPath;
        }
        path = ((String)path).substring(((String)path).indexOf(47) + 1);
        path = (String)path + "/" + modelSubfolder;
        MLflowOrigin origin = new MLflowOrigin(run.info.experimentId, runId, run.info.artifactUri, modelSubfolder);
        if (StringUtils.isNotEmpty((String)modelVersionInfo.gatherFeaturesFromDataset) && (modelVersionInfo.predictionType == PredictionMLTask.PredictionType.MULTICLASS || modelVersionInfo.predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION)) {
            this.checkArgument(CollectionUtils.isNotEmpty((Collection)modelVersionInfo.classLabels), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Class labels must be specified for a prediction model", new Object[0]);
        }
        this.checkArgument(modelVersionInfo.pythonCodeEnvName != null, (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "A python code environment name must be set either in modelVersionInfo or via set_inference_info", new Object[0]);
        if (StringUtils.isNotBlank((String)modelVersionInfo.gatherFeaturesFromDataset)) {
            this.checkArgument(StringUtils.isNotBlank((String)modelVersionInfo.targetColumnName), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "A target column name must be set either in modelVersionInfo or via set_inference_info to evaluate the model", new Object[0]);
            modelVersionInfo.evaluationDatasetSmartName = modelVersionInfo.gatherFeaturesFromDataset;
            modelVersionInfo.evaluationSamplingParam = samplingParam;
        }
        StreamableDatasetSelection selection = samplingParam == null ? StreamableDatasetSelection.head10K() : StreamableDatasetSelection.fromSamplingParam((SamplingParam)samplingParam);
        FutureResponse response = this.savedModelsService.deployMLflowModelInFuture(authCtx, projectKey, smId, folderId, (String)path, versionId, modelVersionInfo, origin, selection, Boolean.valueOf(activate), binaryClassificationThreshold, Boolean.valueOf(useOptimalThreshold), Boolean.valueOf(skipExpensiveReports));
        return this.futureService.waitForFinalResponse(response);
    }

    @AuditedCall(value={"msgType", "log_inputs", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/runs/log-inputs", "/preview/mlflow/runs/log-inputs"}, method={RequestMethod.POST})
    public String logInputs(HttpServletRequest req, @RequestBody PublicAPIMLflowRepositoryController.DSSRegisteredModelCreation info) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkRead(req, projectKey);
        }
        logger.warnV("Calling noop registry method %s", new Object[]{req.getServletPath()});
        return "{}";
    }

    @AuditedCall(value={"msgType", "import-analysis-models-into-experiment-tracking", "projectKey", "${projectKey}", "experimentId", "${experimentId}"})
    @RequestMapping(value={"/import-analysis-models-into-experiment-tracking"}, method={RequestMethod.POST})
    public void createRunsForLabModels(HttpServletRequest req, @RequestParam String projectKey, @RequestParam List<String> fullModelIds, @RequestParam String experimentId) throws Exception {
        AuthCtx user;
        logger.debug((Object)("Comparing with experiment tracking model_ids : " + String.valueOf(fullModelIds)));
        try (Transaction t = this.transactionService.beginRead();){
            user = this.checkWrite(req, projectKey);
        }
        List parsedFullModelIds = fullModelIds.stream().map(FullModelId::parse).collect(Collectors.toList());
        this.experimentTrackingService.createRunsFromAnalyses(user, projectKey, parsedFullModelIds, experimentId);
    }

    public static class DSSCreateExperiment {
        String name;
        String artifact_location;
        List<ExperimentTag> tags;
    }

    public static class DSSExperimentSearch {
        Service.ViewType view_type;
        String filter;
        long max_results;
        List<String> order_by;
    }

    public static class DSSErrorMesssage {
        public String error_code;
        public String message;

        public DSSErrorMesssage() {
        }

        public DSSErrorMesssage(String error_code, String message) {
            this.error_code = error_code;
            this.message = message;
        }
    }

    public static class DSSExperimentOperation {
        public String experiment_id;
    }

    public static class DSSCreateRun {
        String experiment_id;
        String user_id;
        long start_time;
        List<RunTag> tags;
        String run_name;
    }

    public static class DSSUpdateRun {
        String run_uuid;
        String run_id;
        String status;
        long end_time;
    }

    public static class DSSUpdateExperiment {
        String experiment_id;
        String new_name;
    }

    public static class DSSRunOperation {
        String run_id;
    }

    public static class DSSKeyValueParam {
        String experiment_id;
        String run_uuid;
        String run_id;
        String key;
        String value;
    }

    public static class DSSKeyParam {
        String run_id;
        String key;
    }

    public static class DSSLogMetric {
        String run_uuid;
        String run_id;
        String key;
        double value;
        long timestamp;
        long step;
    }

    public static class DSSLogBatch {
        String run_id;
        List<RunMetric> metrics = new ArrayList<RunMetric>();
        List<RunParam> params = new ArrayList<RunParam>();
        List<RunTag> tags = new ArrayList<RunTag>();
    }

    public static class DSSRunSearch {
        List<String> experiment_ids;
        Service.ViewType run_view_type;
        String filter;
        long max_results;
        List<String> order_by;
    }

    public static class DSSLogRun {
        String run_id;
        String run_uuid;
        String model_json;
    }

    public static class DSSModelJson {
        String artifact_path;
    }

    public static class DSSCreateETDataset {
        String datasetName;
        List<String> experimentIds;
        Service.ViewType viewType = Service.ViewType.ACTIVE_ONLY;
        String filter;
        List<String> orderBy;
        ExperimentsDBDatasetParams.Format format = ExperimentsDBDatasetParams.Format.LONG;
    }

    public static class DDSRunDeploymentInfo {
        String run_id;
        String classes;
        String prediction_type;
        String code_env_name;
        String target;
    }

    public static class SimpleKeyValueTimestamp
    extends SimpleKeyValue {
        long timestamp;
    }
}

