/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.serializers.field_definitions;

import com.dataiku.gh.core.models.fields.SourceType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public abstract class TypedFieldDefinitionSerializer<FD extends FieldDefinition>
implements JsonDeserializer<FD>,
JsonSerializer<FD> {
    public FD deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        JsonElement sourceTypeJson = obj.get("sourceType");
        SourceType sourceType = sourceTypeJson != null ? SourceType.valueOf(sourceTypeJson.getAsString()) : SourceType.STORE;
        Class<FD> clazz = sourceType == SourceType.STORE ? this.getStoredFieldDefinition() : this.getComputedFieldDefinition();
        return (FD)((FieldDefinition)context.deserialize(json, clazz));
    }

    public JsonElement serialize(FD src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize(src, src.getClass());
    }

    protected abstract Class<? extends FD> getStoredFieldDefinition();

    protected abstract Class<? extends FD> getComputedFieldDefinition();
}

