/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.migration_paths;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactDetails;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPathStatus;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.roles.assignments.ArtifactRoleAssignments;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.services.artifacts.IArtifactPatchupService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.IArtifactsService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.migration_paths.IBlueprintVersionMigrationPathsDataService;
import com.dataiku.gh.core.services.migration_paths.IBlueprintVersionMigrationPathsService;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionService;
import com.dataiku.gh.core.services.python_execution.migration_paths.MigrationPathException;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IArtifactValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.ValidatorUtils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlueprintVersionMigrationPathService
implements IBlueprintVersionMigrationPathsService {
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IArtifactsService artifactsService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IArtifactValidationService artifactValidationService;
    @Autowired
    private IArtifactPatchupService artifactPatchupService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IBlueprintVersionMigrationPathsDataService blueprintVersionMigrationPathsDataService;
    @Autowired
    private IPythonExecutionService pythonExecutionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.blueprint-version-migration-path");

    @Override
    @GHReadonlyTransaction
    public List<BlueprintVersionMigrationPath> listBlueprintVersionMigrationPaths(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.getEnrichedArtifactAndCheckArtifactAdminPermission(authCtx, artifactId);
        return this.blueprintVersionMigrationPathsDataService.listBlueprintVersionMigrationPathsByRelatedBlueprintVersionSource(enrichedArtifact.blueprintVersion.id).stream().filter(migration -> migration.status == BlueprintVersionMigrationPathStatus.ACTIVE).collect(Collectors.toList());
    }

    @Override
    @GHWriteTransaction
    public void applyBlueprintVersionMigrationPath(AuthCtx authCtx, String artifactId, String blueprintVersionMigrationPathId) throws IOException, DKUSecurityException {
        EnrichedArtifact migratedEnrichedArtifact;
        EnrichedArtifact enrichedArtifact = this.getEnrichedArtifactAndCheckArtifactAdminPermission(authCtx, artifactId);
        BlueprintVersionMigrationPath migration = this.blueprintVersionMigrationPathsDataService.getBlueprintVersionMigrationPath(blueprintVersionMigrationPathId);
        ValidatorUtils.validateThat(Objects.equals((Object)migration.status, (Object)BlueprintVersionMigrationPathStatus.ACTIVE), "Cannot apply a non-active migration: " + migration.id, new Object[0]);
        ValidatorUtils.validateThat(Objects.equals(enrichedArtifact.blueprintVersion.id, migration.blueprintVersionIdFrom), "Cannot apply the migration: " + migration.id + " on the item: " + enrichedArtifact.artifact.id + ". The blueprint version sources do not match: " + String.valueOf(migration.blueprintVersionIdFrom) + ", " + String.valueOf(enrichedArtifact.blueprintVersion.id), new Object[0]);
        EnrichedBlueprintVersion blueprintVersionTarget = this.blueprintsDataService.getBlueprintVersion(migration.blueprintVersionIdTo);
        ValidatorUtils.validateThat(Objects.equals((Object)blueprintVersionTarget.blueprintVersionTrace.status, (Object)BlueprintVersionStatus.ACTIVE), "Cannot apply the migration: " + migration.id + " to a non-active template: " + String.valueOf(blueprintVersionTarget.blueprintVersion.id), new Object[0]);
        ValidatorUtils.validateThat(Objects.equals(migration.blueprintVersionIdTo.blueprintId, migration.blueprintVersionIdFrom.blueprintId), "The target blueprint id: " + migration.blueprintVersionIdTo.blueprintId + " must match the source one: " + migration.blueprintVersionIdFrom.blueprintId + ". Only blueprint version can be different", new Object[0]);
        Artifact migratedArtifact = this.pythonExecutionService.applyBlueprintVersionMigrationPath(enrichedArtifact, migration, blueprintVersionTarget);
        try {
            migratedEnrichedArtifact = this.buildEnrichedArtifactFromMigratedArtifactForSave_NoLicenseCheck(migratedArtifact, blueprintVersionTarget, enrichedArtifact.enrichedArtifactDetails, enrichedArtifact.signoffs, enrichedArtifact.artifactRoleAssignments);
            this.artifactValidationService.validateArtifact(migratedEnrichedArtifact);
            this.artifactPatchupService.patchupArtifact(migratedEnrichedArtifact);
        }
        catch (ValidationException e) {
            throw new MigrationPathException("The migrated artifact generated by the migration is not valid. " + e.getMessage(), migration.id, (Throwable)e);
        }
        this.artifactsDataService.storeArtifact(migratedEnrichedArtifact, false);
    }

    private EnrichedArtifact buildEnrichedArtifactFromMigratedArtifactForSave_NoLicenseCheck(Artifact migratedArtifact, EnrichedBlueprintVersion enrichedTargetBlueprintVersion, EnrichedArtifactDetails artifactDetails, List<Signoff> signoffs, ArtifactRoleAssignments artifactRoleAssignments) throws DKUSecurityException {
        return EnrichedArtifact.build(enrichedTargetBlueprintVersion.blueprint, enrichedTargetBlueprintVersion.blueprintVersion, enrichedTargetBlueprintVersion.blueprintVersionTrace, enrichedTargetBlueprintVersion.blueprintRoleAssignments, artifactRoleAssignments, enrichedTargetBlueprintVersion.blueprintPermissions, migratedArtifact, signoffs, artifactDetails);
    }

    private EnrichedArtifact getEnrichedArtifactAndCheckArtifactAdminPermission(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
        this.checkPermissionsService.checkArtifactAdminPermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, enrichedArtifact.artifact.id);
        return enrichedArtifact;
    }
}

