/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.subscriptions;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.models.subscriptions.SubscriptionId;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.subscriptions.ISubscriptionDAO;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionsDataService
implements ISubscriptionsDataService {
    @Autowired
    private ISubscriptionDAO subscriptionDAO;
    @Autowired
    private IArtifactsDataService artifactsDataService;

    @Override
    @GHMandatoryTransaction
    @Nullable
    public Subscription getSubscriptionOrNull(SubscriptionId subscriptionId) throws IOException {
        return (Subscription)this.subscriptionDAO.getOrNull(subscriptionId);
    }

    @Override
    @GHMandatoryTransaction
    public List<Subscription> listSubscriptionsForUser(String userLogin) throws IOException {
        return this.subscriptionDAO.listForUser(userLogin);
    }

    @Override
    @GHMandatoryTransaction
    public List<Subscription> listSubscriptionsForArtifacts(List<String> artifactIds) throws IOException {
        return this.subscriptionDAO.listForArtifacts(artifactIds);
    }

    @Override
    @GHMandatoryTransaction
    public List<Subscription> listSubscriptionsForUserAndArtifacts(String userLogin, List<String> artifactIds) throws IOException {
        return this.subscriptionDAO.listForUserAndArtifacts(userLogin, artifactIds);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteForArtifact(String artifactId) throws IOException {
        List<Subscription> subscriptions = this.subscriptionDAO.listForArtifact(artifactId);
        for (Subscription sub : subscriptions) {
            this.subscriptionDAO.delete(sub.subscriptionId);
        }
    }

    @Override
    @GHMandatoryTransaction
    public void deleteForUser(String userLogin) throws IOException {
        List<Subscription> subscriptions = this.subscriptionDAO.listForUser(userLogin);
        for (Subscription sub : subscriptions) {
            EnrichedArtifact ea = this.artifactsDataService.getArtifact(sub.subscriptionId.artifactId);
            this.artifactsDataService.lockArtifact(ea.artifact.id, ea.blueprintVersion.id);
        }
        for (Subscription sub : subscriptions) {
            this.subscriptionDAO.delete(sub.subscriptionId);
        }
    }

    @Override
    @GHMandatoryTransaction
    public Subscription storeSubscription(Subscription subscription) throws IOException {
        if (subscription.subscriptionLevel == Subscription.SubscriptionLevel.INO) {
            throw new IllegalArgumentException("Can't store an INO subscription");
        }
        EnrichedArtifact ea = this.artifactsDataService.getArtifact(subscription.subscriptionId.artifactId);
        this.artifactsDataService.lockArtifact(ea.artifact.id, ea.blueprintVersion.id);
        if (this.subscriptionDAO.exists(subscription.subscriptionId)) {
            this.subscriptionDAO.save(subscription);
        } else {
            this.subscriptionDAO.create(subscription);
        }
        return this.getSubscriptionOrNull(subscription.subscriptionId);
    }
}

