import os

from traitlets.config.configurable import LoggingConfigurable

PER_USER_TRUSTSTORE_DIP_PROPERTY = "dku.jupyter.truststore.per_user"
PREVENT_LOCAL_PROCESS_IMPERSONATION = "dku.security.preventLocalProcessImpersonation"


class DipProperties(LoggingConfigurable):

    def list(self):
        dip_properties = {}
        dip_home_path = os.environ.get("DIP_HOME")
        if not dip_home_path:
            self.log.warning("DIP_HOME is not defined")
            return dip_properties
        dip_properties_path = os.path.join(dip_home_path, "config", "dip.properties")
        if not os.path.isfile(dip_properties_path):
            self.log.warning("%s is not a file" % dip_properties_path)
            return dip_properties
        with open(dip_properties_path, 'r') as f:
            lines = f.readlines()
        for line in lines:
            stripped_line = line.strip()
            if not stripped_line:
                continue
            line_chunks = stripped_line.split("=", 1)
            if len(line_chunks) != 2:
                self.log.warning("Unexpected line format: %s" % stripped_line)
                continue
            dip_properties[line_chunks[0]] = line_chunks[1]
        return dip_properties

    def get(self, prop):
        dip_properties = self.list()
        return dip_properties.get(prop)
