(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/edit.js
     */
    app.controller('CopyPageController', function($scope, DataikuAPI, $timeout, StateUtils, DashboardUtils, TileUtils, DashboardVariablesService, DashboardPageUtils, Debounce) {

        $scope.pointerMode = false;

        // b/c when this function is called, CreateModalFromTemplate callback is not executed yet, therefore $scope.page does not exist yet.
        $scope.init = function() {
            $scope.copyPageName = $scope.page.title || 'Page ' + ($scope.pageIdx + 1);
            $scope.copyPageName += ' - COPY';
            $scope.interpolatedTitle = $scope.page.displayedTitle + ' - COPY';

            DataikuAPI.dashboards.listEditable($scope.dashboard.projectKey, $scope.dashboard.id)
                .error(setErrorInScope.bind($scope))
                .success(function(data) {
                    $scope.dashboards = data.dashboards;
                    for (let i = 0; i < $scope.dashboards.length; i++) {
                        const d = $scope.dashboards[i];
                        if (d.id == $scope.dashboard.id) {
                            $scope.targetedDashboard = d;
                            break;
                        }
                    }
                    $scope.$apply();
                });
        };

        $scope.copyPage = function() {
            const copyPageFront = function(insights) {
                const newPage = angular.copy($scope.dashboard.pages[$scope.pageIdx]);
                newPage.title = $scope.copyPageName;
                newPage.displayedTitle = $scope.interpolatedTitle;
                newPage.id = null;
                if (insights) {
                    TileUtils.getFlattenTileList(newPage.grid.tiles).forEach(function(tile) {
                        if (tile.tileType == 'INSIGHT') {
                            const insight = insights.shift();
                            tile.insightId = insight.id;
                        }
                    });
                }
                $scope.pages.splice($scope.pageIdx + 1, 0, newPage);
                $scope.uiState.currentPageIdx = $scope.pageIdx+1;
            };

            const tgt = $scope.targetedDashboard;

            if (tgt.id == $scope.dashboard.id) {
                if (!$scope.pointerMode) {
                    const insightIds = [];
                    const insightNames = [];

                    TileUtils.getFlattenTileList($scope.page.grid.tiles).forEach(function(tile) {
                        if (tile.tileType == 'INSIGHT') {
                            insightIds.push(tile.insightId);
                            insightNames.push($scope.insightsMap[tile.insightId].name);
                        }
                    });
                    DataikuAPI.dashboards.insights.copy($scope.dashboard.projectKey, insightIds, insightNames, $scope.dashboard.id)
                        .error(setErrorInScope.bind($scope))
                        .success(function(newInsights) {
                            newInsights.forEach(function(insight) {
                                $scope.insightsMap[insight.id] = insight;
                                DashboardUtils.sendWT1InsightCreation(insight.type, {
                                    triggeredFrom: 'copy-page-modal'
                                });
                            });
                            copyPageFront(newInsights);
                            $scope.dismiss();
                        });
                } else {
                    copyPageFront();
                    $scope.dismiss();
                }
            } else {
                DataikuAPI.dashboards.copyPage($scope.dashboard.projectKey, $scope.dashboard.id, $scope.page, tgt.id, $scope.copyPageName, $scope.pointerMode)
                    .error(setErrorInScope.bind($scope))
                    .success(function(data) {
                        $timeout(function() {
                            StateUtils.go.dashboard(tgt.id, tgt.projectKey, { name: tgt.name, tab: 'edit', pageId: data });
                        });
                        $scope.dismiss();
                    });
            }
        };

        $scope.onChangeTitle = Debounce().withDelay(100, 100).wrap(() => $scope.updatePageTitle());

        $scope.addVarToTitle = function(event) {
            $scope.copyPageName = DashboardVariablesService.replaceCurrentVar($scope.copyPageName, event.variableName, event.currentSearch, event.varPosition);
            $scope.updatePageTitle();
        };

        $scope.updatePageTitle = function() {
            DashboardPageUtils.getPageTitle($scope.copyPageName, $scope.pageIdx + 1).then(data => {
                $scope.interpolatedTitle = data.data;
            });
        };
    });
})();
