/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public class AlgorithmNameExtractor
implements ModelExtractor<String> {
    private final String jsonPath;
    private final JsonPath compiled;

    public AlgorithmNameExtractor(String jsonPath) {
        this.jsonPath = jsonPath;
        this.compiled = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        try {
            String algorithmName = (String)documentContext.read(this.compiled);
            if (algorithmName != null) {
                for (AlgorithmType algorithmType : AlgorithmType.values()) {
                    if (!algorithmType.name().equals(algorithmName)) continue;
                    return algorithmType.getUserFriendlyName();
                }
                return algorithmName;
            }
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
        catch (PathNotFoundException e) {
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
    }

    public static enum AlgorithmType {
        PYTHON_ENSEMBLE("Ensemble model in Python "),
        SPARK_ENSEMBLE("Ensemble model in Spark"),
        CUSTOM_PLUGIN("Custom algorithm (Python)"),
        SCIKIT_MODEL("Custom algorithm (scikit-learn)"),
        RANDOM_FOREST_CLASSIFICATION("Random Forest"),
        EXTRA_TREES("Extra trees"),
        RANDOM_FOREST_REGRESSION("Random Forest"),
        RIDGE_REGRESSION("Ridge Regression"),
        LASSO_REGRESSION("Lasso Regression"),
        LEASTSQUARE_REGRESSION("Ordinary Least Squares"),
        LOGISTIC_REGRESSION("Logistic Regression"),
        SVC_CLASSIFICATION("Support Vector Machine (classification)"),
        SVM_REGRESSION("Support Vector Machine"),
        SGD_CLASSIFICATION("Stochastic Gradient Descent"),
        SGD_REGRESSION("Stochastic Gradient Descent"),
        GBT_CLASSIFICATION("Gradient Tree Boosting"),
        GBT_REGRESSION("Gradient Tree Boosting"),
        DECISION_TREE_CLASSIFICATION("Decision Tree"),
        DECISION_TREE_REGRESSION("Decision Tree"),
        KNN("KNN"),
        NEURAL_NETWORK("Neural Network"),
        LARS("LASSO-LARS"),
        XGBOOST_CLASSIFICATION("XGBoost"),
        XGBOOST_REGRESSION("XGBoost"),
        LIGHTGBM_CLASSIFICATION("LightGBM"),
        LIGHTGBM_REGRESSION("LightGBM"),
        DEEP_NEURAL_NETWORK_CLASSIFICATION("Deep Neural Network"),
        DEEP_NEURAL_NETWORK_REGRESSION("Deep Neural Network"),
        KERAS_CODE("Custom algorithm (Keras)"),
        TRIVIAL_IDENTITY_TIMESERIES("Trivial identity"),
        SEASONAL_NAIVE("Seasonal naive"),
        AUTO_ARIMA("AutoARIMA"),
        ARIMA("ARIMA"),
        CROSTON("Croston"),
        ETS("ETS"),
        SEASONAL_LOESS("Seasonal trend"),
        PROPHET("Prophet"),
        GLUONTS_NPTS_FORECASTER("NPTS"),
        GLUONTS_SIMPLE_FEEDFORWARD("Simple feed forward"),
        GLUONTS_DEEPAR("DeepAR"),
        GLUONTS_TRANSFORMER("Transformer"),
        GLUONTS_MQCNN("MQ-CNN"),
        SPARKLING_DEEP_LEARNING("Deep Learning (H2O)"),
        SPARKLING_GBM("Generalized Linear Model (H2O)"),
        SPARKLING_RF("Random Forest (H2O)"),
        SPARKLING_GLM("Generalized Linear Model (H2O)"),
        SPARKLING_NB("Naive Bayes (H2O)"),
        MLLIB_LOGISTIC_REGRESSION("Logistic Regression (MLLib)"),
        MLLIB_DECISION_TREE("Decision Tree (MLLib)"),
        MLLIB_LINEAR_REGRESSION("Linear Regression (MLLib)"),
        MLLIB_RANDOM_FOREST("Random Forest (MLLib)"),
        MLLIB_NAIVE_BAYES("Naive Bayes (MLLib)"),
        MLLIB_GBT("Gradient Tree Boosting (MLLib)"),
        MLLIB_CUSTOM("Custom algorithm (MLLib)"),
        VERTICA_LINEAR_REGRESSION("Linear Regression (Vertica)"),
        VERTICA_LOGISTIC_REGRESSION("Logistic Regression (Vertica)"),
        KMEANS("KMeans"),
        MiniBatchKMeans("Mini-Batch KMeans"),
        SPECTRAL("Spectral clustering"),
        WARD("Agglomerative clustering"),
        DBSCAN("DBSCAN"),
        HDBSCAN("HDBSCAN"),
        GMM("Gaussian Mixture"),
        PY_TWO_STEP("Interactive clustering"),
        PY_ISOLATION_FOREST("Isolation Forest"),
        MLLIB_KMEANS("KMeans (MLLib)"),
        MLLIB_GAUSSIAN_MIXTURE("Gaussian Mixture (MLLib)"),
        MLLIB_TWO_STEP("Interactive clustering (MLLib)"),
        MLLIB_ISOLATION_FOREST("Isolation Forest (MLLib)"),
        VERTICA_KMEANS("KMeans (Vertica)"),
        SPARKLING_KMEANS("KMeans (H2O)");

        private String userFriendlyName;

        private AlgorithmType(String userFriendlyName) {
            this.userFriendlyName = userFriendlyName;
        }

        String getUserFriendlyName() {
            return this.userFriendlyName;
        }
    }
}

