/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.analysis.model.core.CustomMetricFailure;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.analysis.model.core.CustomMetricSuccess;
import com.dataiku.dip.analysis.model.core.ModelCustomEvaluationMetric;
import com.dataiku.dip.analysis.model.core.MultiCutCustomMetricSuccess;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;

public class CustomMetricResultAggregator {
    double score = 0.0;
    double testWeightScore = 0.0;
    boolean containsFailure = false;
    ArrayList<String> failedPartitions = new ArrayList();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.ml.prediction.partitioned.aggregation");

    public void addValue(CustomMetricResult metricResult, double testWeight, String modelId) {
        this.addValue(metricResult, testWeight, modelId, -1);
    }

    public void addValue(CustomMetricResult metricResult, double testWeight, String modelId, int thresholdIndex) throws IllegalStateException {
        if (metricResult instanceof CustomMetricFailure) {
            this.containsFailure = true;
            this.failedPartitions.add(modelId);
        } else if (metricResult instanceof MultiCutCustomMetricSuccess && thresholdIndex != -1) {
            this.score += ((MultiCutCustomMetricSuccess)metricResult).values[thresholdIndex] * testWeight;
            this.testWeightScore += testWeight;
        } else if (metricResult instanceof CustomMetricSuccess) {
            this.score += ((CustomMetricSuccess)metricResult).value * testWeight;
            this.testWeightScore += testWeight;
        } else {
            throw new IllegalStateException();
        }
    }

    public CustomMetricResult aggregateMulticut(ModelCustomEvaluationMetric sourceMetric) {
        if (this.containsFailure) {
            return this.getCustomMetricFailure(sourceMetric);
        }
        MultiCutCustomMetricSuccess result = new MultiCutCustomMetricSuccess();
        result.metric = sourceMetric;
        if (this.testWeightScore > 0.0) {
            double value = this.score / this.testWeightScore;
            result.values = new double[]{value};
        }
        return result;
    }

    public CustomMetricResult aggregate(ModelCustomEvaluationMetric sourceMetric) {
        if (this.containsFailure) {
            return this.getCustomMetricFailure(sourceMetric);
        }
        CustomMetricSuccess result = new CustomMetricSuccess();
        result.metric = sourceMetric;
        if (this.testWeightScore > 0.0) {
            result.value = this.score / this.testWeightScore;
        }
        return result;
    }

    private CustomMetricResult getCustomMetricFailure(ModelCustomEvaluationMetric sourceMetric) {
        CustomMetricFailure result = new CustomMetricFailure();
        result.metric = sourceMetric;
        result.error = "One or more partition models failed to calculate the metric";
        String failedPartitionsStr = this.failedPartitions.toString();
        logger.warn((Object)String.format("Custom Metric '%s' calculation failed on the following partitions: %s", sourceMetric.name, failedPartitionsStr));
        return result;
    }
}

