/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.python;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.python.PyMemoryAlgorithmMeta;
import java.util.Collections;
import java.util.List;

public class GluonTSMXNetMQCNNMeta
extends PyMemoryAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "MQ-CNN";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        PredictionModelingParams.GluonTSMXNetMQCNNSpace space = rpmp.gluonts_mqcnn_timeseries_grid;
        ModelTrainInfo.PreSearchDescription description = new ModelTrainInfo.PreSearchDescription(rpmp).withGridLength(this.getSearchSize(rpmp.grid_search_params, space)).withMVParam("Learning rate", space.learning_rate).withSVParam("MLP layer sizes", space.decoder_mlp_dim_seq).withSVParam("Nb. channels", space.channels_seq).withSVParam("Convolution dilations", space.dilation_seq).withSVParam("Kernel sizes", space.kernel_size_seq);
        if (!space.full_context) {
            description = description.withMVParam("Context length", space.context_length);
        }
        return description;
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        PredictionModelingParams.GluonTSMXNetMQCNNSpace space = before.gluonts_mqcnn_timeseries_grid;
        PostTrainPredictionModelingParams.GluonTSMXNetMQCNNParams params = after.gluonts_mqcnn_timeseries_params;
        ModelTrainInfo.PostSearchDescription description = new ModelTrainInfo.PostSearchDescription().withSVParam("Learning rate", params.learning_rate).withSVParam("MLP layer sizes", params.decoder_mlp_dim_seq).withSVParam("Nb. channels", params.channels_seq).withSVParam("Convolution dilations", params.dilation_seq).withSVParam("Kernel sizes", params.kernel_size_seq).withSVParam("Epochs", params.epochs);
        if (!space.full_context) {
            description = description.withSVParam("Context length", params.context_length);
        }
        return description;
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        PredictionModelingParams.GluonTSMXNetMQCNNSpace space = pmp.gluonts_mqcnn_timeseries;
        if (space == null || !space.enabled) {
            return;
        }
        checks.checkNumericalDimension(space.learning_rate, "Learning rate (MQ-CNN)");
        if (!space.full_context) {
            checks.checkNumericalDimension(space.context_length, "Context length (MQ-CNN)");
        }
        checks.checkPositive(space.channels_seq.size(), "The size of at least one MLP layer must be specified (MQ-CNN)");
        checks.checkPositive(space.decoder_mlp_dim_seq.size(), "The number of channels must be specified for at least one encoder layer (MQ-CNN)");
        checks.checkEquals(space.channels_seq.size(), space.kernel_size_seq.size(), "Kernel size array should be of same length as number of channels array (MQ-CNN)");
        checks.checkEquals(space.channels_seq.size(), space.dilation_seq.size(), "Convolution dilation array should be of same length as number of channels array (MQ-CNN)");
        checks.checkPositive(Collections.min(space.decoder_mlp_dim_seq).longValue(), "Dimensions of MLP layers must be positive for every layer (MQ-CNN)");
        checks.checkPositive(Collections.min(space.channels_seq).longValue(), "Number of channels must be positive for every layer (MQ-CNN)");
        checks.checkPositive(Collections.min(space.dilation_seq).longValue(), "Dilation of the layer convolution must be positive for every layer (MQ-CNN)");
        checks.check(Collections.min(space.kernel_size_seq) > 1L, "Kernel size must be strictly greater than 1 for every layer (MQ-CNN)");
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        PredictionModelingParams.GluonTSMXNetMQCNNSpace space = pmp.gluonts_mqcnn_timeseries;
        if (space == null || !space.enabled) {
            return Collections.emptyList();
        }
        PreTrainPredictionModelingParams preTrainParams = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.GLUONTS_MQCNN, pmp);
        preTrainParams.gluonts_mqcnn_timeseries_grid = space;
        preTrainParams.gridLength = this.getSearchSize(preTrainParams.grid_search_params, space);
        WorkSet.ModelingSet modelingSet = new WorkSet.ModelingSet(preTrainParams);
        if (preTrainParams.gridLength > 1) {
            modelingSet.estimatedTrains = preTrainParams.gridLength * gsFolds + 1;
        }
        return Collections.singletonList(modelingSet);
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PostTrainPredictionModelingParams.GluonTSMXNetMQCNNParams optimizedParameters = optimized.gluonts_mqcnn_timeseries_params;
        PreTrainPredictionModelingParams preTrainParams = this.getCopyWithGridStrategy(usedToTrain);
        PredictionModelingParams.GluonTSMXNetMQCNNSpace space = preTrainParams.gluonts_mqcnn_timeseries_grid;
        if (!preTrainParams.gluonts_mqcnn_timeseries_grid.full_context) {
            space.context_length.setToSingleValueGrid(optimizedParameters.context_length);
        }
        space.learning_rate.setToSingleValueGrid(optimizedParameters.learning_rate);
        return preTrainParams;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrainParams = this.regridifyToPreTrain(optimized, usedToTrain);
        target.gluonts_mqcnn_timeseries = preTrainParams.gluonts_mqcnn_timeseries_grid;
        target.gluonts_mqcnn_timeseries.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.gluonts_mqcnn_timeseries = usedToTrain.gluonts_mqcnn_timeseries_grid;
        target.gluonts_mqcnn_timeseries.enabled = true;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return true;
    }

    @Override
    protected int getGridLength(PredictionModelingParams.HyperparametersSpace space) {
        PredictionModelingParams.GluonTSMXNetMQCNNSpace gluonTSMXNetMQCNNSpace = (PredictionModelingParams.GluonTSMXNetMQCNNSpace)space;
        return gluonTSMXNetMQCNNSpace.learning_rate.getLength() * (gluonTSMXNetMQCNNSpace.full_context ? 1 : gluonTSMXNetMQCNNSpace.context_length.getLength());
    }
}

