/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.dao.AbstractGlobalDAO;
import com.dataiku.dip.dao.ProjectFoldersDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedProjectFoldersDAO
extends AbstractGlobalDAO<ProjectFolder>
implements ProjectFoldersDAO {
    private static final String PROJECT_FOLDER_TYPE = "project_folder";
    private static final String PROJECT_FOLDER_DIR = "project_folders";

    protected ProjectFolder getOrNull(String id, boolean unsafe) throws IOException {
        RelFile file;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(file = this.getDAOFile(id))) {
            return null;
        }
        ProjectFolder folder = unsafe ? (ProjectFolder)t.readObjectUnsafe(file, ProjectFolder.class) : (ProjectFolder)t.readObject(file, ProjectFolder.class);
        folder.id = id;
        return folder;
    }

    protected List<ProjectFolder> list(boolean unsafe) throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile dir = this.getDAODir();
        ArrayList<ProjectFolder> folders = new ArrayList<ProjectFolder>();
        if (!tr.exists(dir)) {
            return folders;
        }
        for (RelFile file : tr.listFiles(dir, (RelFileFilter)FileFilter.json())) {
            try {
                String projectFolderId = StringUtils.removeEnd((String)file.getLeafName(), (String)".json");
                ProjectFolder folder = (ProjectFolder)this.getMandatory(projectFolderId, unsafe);
                folders.add(folder);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to read project folder file " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return folders;
    }

    protected String getType() {
        return PROJECT_FOLDER_TYPE;
    }

    public void delete(String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteFile(this.getDAOFile(id));
    }

    private RelFile getDAODir() {
        return RelFile.global((String)PROJECT_FOLDER_DIR);
    }

    protected RelFile getDAOFile(String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Project folder's id not specified");
        return new RelFile(this.getDAODir(), new String[]{id + ".json"});
    }

    @Override
    public void save(ProjectFolder folder) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        RelFile file = this.getDAOFile(folder.id);
        tr.writeObject(file, (Object)folder);
    }
}

