/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datadirectories;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataDirectoriesFootprintModel {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.directories-footprint.model");

    public static void computeTotals(Size size) {
        for (Field field : size.getClass().getFields()) {
            try {
                Object value = field.get(size);
                if (value instanceof Sizes) {
                    Sizes list = (Sizes)value;
                    for (Size elem : list.items) {
                        DataDirectoriesFootprintModel.computeTotals(elem);
                        list.add(elem);
                    }
                    size.add(list);
                    continue;
                }
                if (!(value instanceof Size)) continue;
                DataDirectoriesFootprintModel.computeTotals((Size)value);
                size.add((Size)value);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)("Unable to summarize " + field.getName() + ", ignoring. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
    }

    public static void trimToSummary(Size size) {
        if (size instanceof SizeWithLocation) {
            ((SizeWithLocation)size).locations = null;
        }
        if (size instanceof Sizes) {
            Sizes sizes = (Sizes)size;
            for (Size item : sizes.items) {
                DataDirectoriesFootprintModel.trimToSummary(item);
            }
        }
        if (size instanceof UnknownData) {
            ((UnknownData)size).files = null;
        }
        for (Field field : size.getClass().getFields()) {
            try {
                Object value = field.get(size);
                if (!(value instanceof Size)) continue;
                field.set(size, null);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)("Unable to trim " + field.getName() + ", ignoring. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
    }

    public static class Sizes<T extends Size>
    extends Size {
        public final List<T> items;

        public Sizes() {
            this.items = new ArrayList<T>();
        }

        public Sizes(List<T> items) {
            this.items = items;
        }

        public static <T extends Size> Sizes<T> of(T item) {
            return new Sizes<T>(ImmutableList.of(item));
        }
    }

    public static class Size
    implements Serializable {
        public long size;
        public int nbFiles;
        public int nbFolders;
        public int nbErrors;

        public void add(Size other) {
            this.size += other.size;
            this.nbFiles += other.nbFiles;
            this.nbFolders += other.nbFolders;
            this.nbErrors += other.nbErrors;
        }

        public void add(long fileSize, boolean isFolder, boolean hasError) {
            this.size += hasError || isFolder ? 0L : fileSize;
            this.nbFiles += hasError || isFolder ? 0 : 1;
            this.nbFolders += hasError || !isFolder ? 0 : 1;
            this.nbErrors += hasError ? 1 : 0;
        }
    }

    public static class SizeWithLocation
    extends Size {
        public Set<String> locations;

        public void addLocation(String location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashSet<String>();
                }
                this.locations.add(location);
            }
        }
    }

    public static class UnknownData
    extends Size {
        public String path;
        public boolean folder;
        public UnknownFiles files;
    }

    public static class UnknownFiles
    extends Size {
        public List<String> names = new ArrayList<String>();
    }

    public static class DatadirFootprint
    extends Size
    implements GenericFootprint {
        public Sizes<ProjectFootprint> projects;
        public Sizes<ProjectFootprint> orphanProjects;
        public Sizes<CodeEnvFootprint> codeEnvs;
        public Sizes<PluginFootprint> plugins;
        public SizeWithLocation globalConfig;
        public SizeWithLocation git;
        public SizeWithLocation tmp;
        public SizeWithLocation privtmp;
        public SizeWithLocation uiftmp;
        public SizeWithLocation bin;
        public SizeWithLocation migrationBackups;
        public SizeWithLocation run;
        public SizeWithLocation pyenv;
        public SizeWithLocation runtimeDatabases;
        public SizeWithLocation installSupport;
        public SizeWithLocation dataCatalog;
        public SizeWithLocation costLimiting;
        public SizeWithLocation resources;
        public SizeWithLocation exports;
        public SizeWithLocation diagnosis;
        public SizeWithLocation clusters;
        public SizeWithLocation globalFiles;
        public SizeWithLocation local;
        public SizeWithLocation story;
        public SizeWithLocation bundleActivationBackups;
        public SizeWithLocation RLib;
        public SizeWithLocation apiDeployer;
        public SizeWithLocation unifiedMonitoring;
        public SizeWithLocation jupyterRun;
        public SizeWithLocation featuresUsage;
        public SizeWithLocation codeStudioTemplates;
        public SizeWithLocation modelCache;
        public SizeWithLocation popularDatasets;
        public SizeWithLocation timelines;
        public SizeWithLocation caches;
        public SizeWithLocation lib;
        public SizeWithLocation docportal;
        public Sizes<UnknownData> unknown;
    }

    public static class ProjectFootprint
    extends Size
    implements GenericFootprint {
        public String projectKey;
        public SizeWithLocation config;
        public SizeWithLocation git;
        public SizeWithLocation preparedBundles;
        public SizeWithLocation importedBundles;
        public SizeWithLocation jobs;
        public SizeWithLocation scenarios;
        public SizeWithLocation continuousActivities;
        public SizeWithLocation uploadedDatasets;
        public SizeWithLocation managedDatasets;
        public SizeWithLocation managedFolders;
        public SizeWithLocation dkuWorkdirs;
        public SizeWithLocation shakerFullPivot;
        public SizeWithLocation shakerSamples;
        public SizeWithLocation libResources;
        public SizeWithLocation codeStudioResources;
        public SizeWithLocation analysis;
        public SizeWithLocation savedModels;
        public SizeWithLocation modelEvaluationStores;
        public SizeWithLocation insights;
        public SizeWithLocation apiNodePackages;
        public SizeWithLocation wikiAttachments;
        public SizeWithLocation codeReports;
        public SizeWithLocation agentTools;
        public SizeWithLocation promptStudios;
        public SizeWithLocation pythonGuardrails;
        public SizeWithLocation webApps;
        public SizeWithLocation thumbnails;
        public SizeWithLocation notebooks;
        public SizeWithLocation notebookResults;
        public SizeWithLocation knowledgeBanks;
        public SizeWithLocation mergeRequests;
        public SizeWithLocation projectDeployer;
        public SizeWithLocation codeStudios;
        public SizeWithLocation projectStandards;
        public SizeWithLocation workloadFolders;
        public SizeWithLocation docportal;
    }

    static interface GenericFootprint {
    }

    public static class PluginFootprint
    extends SizeWithLocation {
        public String name;
        public String type;
    }

    public static class CodeEnvFootprint
    extends SizeWithLocation {
        public String name;
        public String language;
    }
}

