/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeHelper;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeJobDef;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLExecutor;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryJobDefBuilder;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.SplitRecipeService;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitRecipeJobDefBuilder {
    @Autowired
    private SplitRecipeService splitService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    private final JobActivity activity;
    private final RecipeRunnableSubgraph subgraph;
    private final SplitRecipePayloadParams params;
    private final boolean lowerCaseColumns;
    private SplitRecipeHelper splitHelper;
    private static Logger logger = Logger.getLogger((String)"dip.split.spark.jobdef.builder");

    public SplitRecipeJobDefBuilder(JobActivity activity, SplitRecipePayloadParams params, SplitRecipeHelper splitHelper) {
        this.splitHelper = splitHelper;
        SpringUtils.getInstance().autowire((Object)this);
        this.params = params;
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.lowerCaseColumns = false;
    }

    public SplitRecipeJobDef build(SparkSQLExecutor.SparkSQLExecutorParams sparkSQLParams) throws IOException {
        FlowDataset source = this.subgraph.getSourceDatasets().get(0);
        Schema baseOutputSchema = this.splitHelper.getBaseOutputSchema();
        SparkSQLDialect dialect = new SparkSQLDialect();
        SplitRecipeJobDef jobDef = new SplitRecipeJobDef();
        jobDef.readParams = (InputDatasetsReadParams)JSON.deepCopy((Object)this.params.engineParams.sparkSQL.readParams);
        FlowRecipe recipe = this.subgraph.getRecipe();
        jobDef.input = SparkRecipeUtils.getInputFlowDatasetRef(source, jobDef.readParams, false, recipe, this.activity, this.datasetsDAO);
        for (FlowDataset out : this.subgraph.getTargetsDatasets()) {
            SplitRecipeJobDef.SplitRecipeOutputDef output;
            String outputFullName = out.getFullName();
            Dataset outputDS = out.getMandatory(this.datasetsDAO);
            Schema outputSchema = new Schema();
            PartitioningScheme partitioningScheme = outputDS.getPartitioningSchema();
            boolean shouldSkipPartitionColumns = DatasetInspector.arePartitioningColumnsForbiddenInSchema(outputDS) && partitioningScheme != null && partitioningScheme.isPartitioned();
            for (SchemaColumn column : baseOutputSchema.columns) {
                if (shouldSkipPartitionColumns && partitioningScheme.getDimensionNames().contains(column.getName())) continue;
                outputSchema.addColumn(column);
            }
            if (this.lowerCaseColumns) {
                SchemaUtils.lowerCase(outputSchema);
            }
            if (this.datasetInConditions(outputFullName)) {
                output = new SplitRecipeJobDef.SplitRecipeOutputDef(outputFullName, this.subgraph.getTargetPartition(out).id(), this.params.mode == SplitRecipePayloadParams.Mode.RANDOM ? null : this.splitHelper.effectiveConditions.get(outputFullName).toSQL(dialect), this.params.mode == SplitRecipePayloadParams.Mode.RANDOM ? this.splitHelper.randomOutputs.get(outputFullName) : null, SparkSQLQueryJobDefBuilder.findWriteMode(outputDS, recipe.getModel()));
                output.outputSchema = outputSchema.columns;
                jobDef.outputs.add(output);
                continue;
            }
            output = new SplitRecipeJobDef.SplitRecipeOutputDef(outputFullName, this.subgraph.getTargetPartition(out).id(), null, null, SparkSQLQueryJobDefBuilder.findWriteMode(outputDS, recipe.getModel()));
            output.outputSchema = outputSchema.columns;
            jobDef.emptyOutputs.add(output);
        }
        jobDef.splitMode = this.params.mode;
        if (this.params.mode == SplitRecipePayloadParams.Mode.RANDOM) {
            jobDef.randomSeed = this.params.seed;
        }
        jobDef.prepareSqlQuery = this.splitHelper.enrichInputDatasetOrTable(dialect, true).toSQL(dialect);
        jobDef.writeSchema = this.params.engineParams.sparkSQL.overwriteOutputSchema;
        jobDef.useGlobalMetastore = sparkSQLParams.useGlobalMetastore;
        if (jobDef.useGlobalMetastore) {
            jobDef.metastoreDatabase = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
            if (jobDef.metastoreDatabase == null) {
                logger.warn((Object)"Could not find a metastore database to use from recipe inputs/outputs, will use default");
                jobDef.metastoreDatabase = "";
            }
        }
        return jobDef;
    }

    private boolean datasetInConditions(String datasetFullName) {
        if (this.params.mode == SplitRecipePayloadParams.Mode.RANDOM) {
            return this.splitHelper.randomOutputs.containsKey(datasetFullName);
        }
        return this.splitHelper.effectiveConditions.containsKey(datasetFullName);
    }
}

