/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.window;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.BasicRecipeLineageHandler;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class WindowRecipePayloadParams
extends VisualSQLRecipePayloadParams
implements ParamsWithContainerizable,
BasicRecipeLineageHandler.Params {
    public RetrievedColumnsSelectionMode retrievedColumnsSelectionMode = RetrievedColumnsSelectionMode.ALL;
    public ArrayList<WindowValue> values = new ArrayList();
    public List<ComputedColumn> computedColumns = new ArrayList<ComputedColumn>();
    public FilterDesc preFilter = new FilterDesc();
    public FilterDesc postFilter = new FilterDesc();
    public HashMap<String, String> outputColumnNameOverrides;
    public ArrayList<WindowDesc> windows = new ArrayList();
    public boolean rank;
    public boolean denseRank;
    public boolean rowNumber;
    public boolean cumeDist;
    public boolean ntile;
    public String ntileValues = "10";
    public boolean legacyUnboundedWindowStreamBehavior = true;

    private static int[] splitToIntArray(String str) {
        if (StringUtils.isBlank((String)str)) {
            return new int[]{1};
        }
        String[] parts = str.split(",");
        int[] ret = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            ret[i] = Integer.parseInt(parts[i]);
            if (ret[i] > 0) continue;
            throw new IllegalArgumentException("Expected comma-separated positive integers");
        }
        return ret;
    }

    public int[] getNtileValues() {
        return WindowRecipePayloadParams.splitToIntArray(this.ntileValues);
    }

    @Override
    public List<ComputedColumn> getComputedColumns() {
        return this.computedColumns;
    }

    @Override
    public Map<String, String> getOutputColumnNameOverrides() {
        return this.outputColumnNameOverrides;
    }

    public boolean hasUnorderedWindow() {
        if (this.windows == null) {
            return false;
        }
        for (WindowDesc window : this.windows) {
            if (window.enableOrdering && window.orders != null && !window.orders.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOrderedAggregations() {
        if (this.rank || this.denseRank || this.rowNumber || this.cumeDist || this.ntile) {
            return true;
        }
        for (WindowValue val : this.values) {
            if (!val.first && !val.last && !val.lag && !val.lead) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonTrivialAggregation() {
        if (this.rank || this.denseRank || this.rowNumber || this.cumeDist || this.ntile) {
            return true;
        }
        if (this.values == null) {
            return false;
        }
        for (WindowValue val : this.values) {
            if (val.column != null && !val.hasAnyAggr(true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContainerExecSelection getContainerSelection() {
        return this.engineParams.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        this.engineParams.containerSelection = selection;
    }

    public List<WindowValue> getResolvedWindowValues(Schema inputSchema) {
        if (inputSchema == null) {
            throw new IllegalArgumentException("Using window recipe with input dataset with no schema");
        }
        boolean retrieveAll = this.retrievedColumnsSelectionMode == RetrievedColumnsSelectionMode.ALL;
        HashMap<String, WindowValue> valuesByColumn = new HashMap<String, WindowValue>();
        ArrayList<WindowValue> customAggregations = new ArrayList<WindowValue>();
        for (WindowValue value2 : this.values) {
            if (value2.column != null) {
                valuesByColumn.put(value2.column, value2);
                continue;
            }
            customAggregations.add(value2);
        }
        Stream<WindowValue> inputAndComputed = Stream.concat(inputSchema.columns.stream().map(SchemaColumn::getName), this.computedColumns.stream().map(cc -> cc.name)).map(column -> valuesByColumn.getOrDefault(column, new WindowValue().withColumn((String)column))).map(value -> {
            if (retrieveAll && !value.value) {
                return ((WindowValue)ObjectUtils.shallowCopy((Object)value)).withValue();
            }
            return value;
        });
        return Stream.concat(inputAndComputed, customAggregations.stream()).toList();
    }

    public static enum RetrievedColumnsSelectionMode {
        EXPLICIT,
        ALL;

    }

    public static class WindowDesc {
        public String name;
        public String prefix;
        public boolean enablePartitioning;
        public ArrayList<String> partitioningColumns;
        public boolean enableOrdering;
        public ArrayList<Order> orders = new ArrayList();
        public boolean enableLimits;
        public WindowLimitMode windowLimitMode;
        public boolean limitPreceding;
        public boolean limitFollowing;
        public int precedingRows;
        public int followingRows;
        public double windowLowerBound;
        public double windowUpperBound;
        public DateDiffUnit windowDateRangeUnit;
    }

    public static class WindowValue {
        public String column;
        public Type type;
        public boolean min;
        public boolean max;
        public boolean count;
        public boolean countDistinct;
        public boolean sum;
        public boolean concat;
        public boolean avg;
        public boolean stddev;
        public boolean first;
        public boolean last;
        public boolean value;
        public boolean lead;
        public boolean lag;
        public boolean leadDiff;
        public boolean lagDiff;
        public String leadValues = "1";
        public String lagValues = "1";
        public DateDiffUnit dateDiffUnit = DateDiffUnit.DAY;
        public String customName;
        public String customExpr;
        public String concatSeparator;
        public boolean concatDistinct;
        public boolean firstLastNotNull;

        public boolean hasAnyAggr(boolean ignoreValue) {
            assert (this.column != null);
            if (!ignoreValue && this.value) {
                return true;
            }
            return this.min || this.max || this.count || this.countDistinct || this.sum || this.concat || this.avg || this.stddev || this.first || this.last || this.lead || this.lag || this.leadDiff || this.lagDiff;
        }

        public ArrayList<SchemaColumn> getDerivedColumns(SchemaColumn inputColumn, SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer, String prefix, SQLDialect dialect) {
            Type outType;
            String colName;
            ArrayList<SchemaColumn> ret = new ArrayList<SchemaColumn>();
            Type inColType = inputColumn.getType();
            if (this.min) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_min"), inColType));
            }
            if (this.max) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_max"), inColType));
            }
            if (this.count) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_count"), Type.BIGINT));
            }
            if (this.countDistinct) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_distinct"), Type.BIGINT));
            }
            if (this.avg) {
                Type outColType = inColType == Type.DATETIMENOTZ ? Type.DATETIMENOTZ : (inColType == Type.DATEONLY ? Type.DATETIMENOTZ : (inColType == Type.DATE ? Type.DATE : Type.DOUBLE));
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_avg"), outColType));
            }
            if (this.stddev) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_stddev"), Type.DOUBLE));
            }
            if (this.sum) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_sum"), inColType == Type.BOOLEAN || inColType.isInteger() ? Type.BIGINT : inColType));
            }
            if (this.concat) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_concat"), Type.STRING));
            }
            if (this.first) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_first"), inColType));
            }
            if (this.last) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(prefix + this.column, "_last"), inColType));
            }
            if (this.lead) {
                for (int leadValue : this.getLeadValues()) {
                    colName = safeSuffixer.addSuffix(prefix + this.column, "_lead" + String.valueOf(leadValue != 1 || this.getLeadValues().length > 1 ? Integer.valueOf(leadValue) : ""));
                    ret.add(new SchemaColumn(colName, inColType));
                }
            }
            if (this.leadDiff) {
                for (int leadValue : this.getLeadValues()) {
                    colName = safeSuffixer.addSuffix(prefix + this.column, "_lead_diff" + String.valueOf(leadValue != 1 || this.getLeadValues().length > 1 ? Integer.valueOf(leadValue) : ""));
                    outType = this.getLeadLagDiffType(inColType, dialect);
                    ret.add(new SchemaColumn(colName, outType));
                }
            }
            if (this.lag) {
                for (int lagValue : this.getLagValues()) {
                    colName = safeSuffixer.addSuffix(prefix + this.column, "_lag" + String.valueOf(lagValue != 1 || this.getLagValues().length > 1 ? Integer.valueOf(lagValue) : ""));
                    ret.add(new SchemaColumn(colName, inColType));
                }
            }
            if (this.lagDiff) {
                for (int lagValue : this.getLagValues()) {
                    colName = safeSuffixer.addSuffix(prefix + this.column, "_lag_diff" + String.valueOf(lagValue != 1 || this.getLagValues().length > 1 ? Integer.valueOf(lagValue) : ""));
                    outType = this.getLeadLagDiffType(inColType, dialect);
                    ret.add(new SchemaColumn(colName, outType));
                }
            }
            return ret;
        }

        private Type getLeadLagDiffType(Type inColType, SQLDialect dialect) {
            Type outType = inColType;
            if (inColType.isTemporal()) {
                outType = Type.BIGINT;
            } else if (inColType == Type.BOOLEAN) {
                outType = Type.TINYINT;
            }
            if (dialect instanceof ImpalaSQLDialect) {
                if (inColType == Type.TINYINT) {
                    outType = Type.SMALLINT;
                } else if (inColType == Type.SMALLINT) {
                    outType = Type.INT;
                } else if (inColType == Type.INT) {
                    outType = Type.BIGINT;
                }
            }
            return outType;
        }

        public int[] getLagValues() {
            return WindowRecipePayloadParams.splitToIntArray(this.lagValues);
        }

        public int[] getLeadValues() {
            return WindowRecipePayloadParams.splitToIntArray(this.leadValues);
        }

        public int aggrCount() {
            assert (this.column != null);
            int c2 = 0;
            if (this.min) {
                ++c2;
            }
            if (this.max) {
                ++c2;
            }
            if (this.count) {
                ++c2;
            }
            if (this.countDistinct) {
                ++c2;
            }
            if (this.sum) {
                ++c2;
            }
            if (this.stddev) {
                ++c2;
            }
            if (this.avg) {
                ++c2;
            }
            if (this.first) {
                ++c2;
            }
            if (this.last) {
                ++c2;
            }
            if (this.concat) {
                ++c2;
            }
            if (this.first) {
                ++c2;
            }
            if (this.last) {
                ++c2;
            }
            if (this.lead) {
                ++c2;
            }
            if (this.lag) {
                ++c2;
            }
            if (this.leadDiff) {
                ++c2;
            }
            if (this.lagDiff) {
                ++c2;
            }
            return c2;
        }

        public WindowValue withColumn(String column) {
            this.column = column;
            return this;
        }

        public WindowValue withValue() {
            this.value = true;
            return this;
        }
    }

    public static class Order {
        public String column;
        public boolean desc;

        public Order() {
        }

        public Order(String column, boolean desc) {
            this.column = column;
            this.desc = desc;
        }
    }

    public static enum DateDiffUnit {
        YEAR("y"),
        MONTH("M"),
        WEEK("w"),
        DAY("d"),
        HOUR("h"),
        MINUTE("m"),
        SECOND("s");

        protected String suffix;

        private DateDiffUnit(String suffix) {
            this.suffix = suffix;
        }
    }

    public static enum WindowLimitMode {
        ROWS,
        RANGE;

    }
}

