/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DatabricksVolumeDatasetHandler;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class DatabricksVolumeDatasetTestHandler
extends FSLikeDatasetTestHandler {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.input.databricksVolume");

    public DatabricksVolumeDatasetTestHandler(AuthCtx authCtx, DatabricksVolumeDatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) {
        super(authCtx, handlerForData, handlerForName, dataset);
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult ret) throws Exception {
        DatabricksVolumeConnection conn;
        BuiltinFSDatasets.DatabricksVolumeDatasetConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.DatabricksVolumeDatasetConfig.class);
        try {
            DSSConnection rawConn = ConnectionsDAO.get().getMandatoryConnection(this.handlerForData.authCtx, config.connection);
            if (rawConn instanceof DatabricksConnection) {
                conn = ((DatabricksConnection)rawConn).asDatabricksVolumeConnection();
            } else if (rawConn instanceof DatabricksVolumeConnection) {
                conn = (DatabricksVolumeConnection)rawConn;
            } else {
                throw new IOException("Unexpected connection type " + rawConn.type);
            }
            try (FSTestProvider testProvider = FSProviderFactory.getTestProvider(this.handlerForData.authCtx, "DatabricksVolume", config, conn);){
                ret.connectionMetadata.putAll(testProvider.test(false));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Databricks connection connection test failed", (Throwable)e);
            ret.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
        if (StringUtils.isNotBlank((String)conn.params.chvolume) || StringUtils.isNotBlank((String)config.volume)) {
            try {
                InputSplit sampleSplit = this.handlerForData.getSampleSplit();
                if (sampleSplit instanceof StreamsInputSplit) {
                    ret.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
                }
                ret.connectionOK = true;
                return sampleSplit;
            }
            catch (Exception e) {
                logger.info((Object)"Connection test failed", (Throwable)e);
                ret.connectionError = new SerializedError((Throwable)e, false);
                return null;
            }
        }
        ret.connectionError = new SerializedError((Throwable)new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Databricks volume not specified"), false);
        return null;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) throws Exception {
        DatabricksVolumeDatasetHandler handler = (DatabricksVolumeDatasetHandler)this.handlerForData;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try {
            if (handler.getProvider().stat(newDatasetName) != null) {
                ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_MANAGED_UNSAFE_NAME, "Objects already already exists at '%s', they may get overwritten", new Object[]{newDatasetName});
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to check if the new dataset name is safe", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Failed to check if the new dataset name is safe, there could be a problem with the database: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }
}

