/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.docextraction.DocExtractionKernelPool;
import com.dataiku.dip.docextraction.DocExtractionUtils;
import com.dataiku.dip.docextraction.Screenshotter;
import com.dataiku.dip.docextraction.ScreenshotterService;
import com.dataiku.dip.docextraction.StructuredContent;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.docextraction.VLMExtractor;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.StructuredExtractorResponseOrError;
import com.dataiku.dip.docextraction.common.chunks.VlmExtractionChunk;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.kernel.DSSKernelUtils;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMAuditHelper;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMMeshClient;
import com.dataiku.dip.llm.online.LLMMeshClientFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.commons.codec.binary.Hex;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.io.ByteStreams;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

@Service
public class DocExtractionService {
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ComputeResourceUsageReportingService cruReportingService;
    @Autowired
    private ScreenshotterService screenshotterService;
    @Autowired
    private DocExtractionKernelPool docExtractionKernelPool;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    public static final String STRUCTURED_EXTRACTION = "structured-extraction";
    public static final String DOCX_HEADING_LEVEL_CORRECTION = "dku.docextraction.structured.docxHeadingLevelCorrection";
    public static final String DEFAULT_IMAGE_CLASSIFICATION_FILTERED_CLASSES = "bar_code,icon,logo,qr_code,signature,stamp";
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.docextraction");

    public Screenshotter.ScreenshotterResponseOrError extractScreenshotsFromManagedFolderDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.ManagedFolderDocumentRef documentRef, Screenshotter.ScreenshotterSettings settings) throws Exception {
        return this.screenshotterService.extractScreenshotsFromManagedFolderDocumentRef(authCtx, projectKey, documentRef, settings);
    }

    public Screenshotter.ScreenshotterResponseOrError extractScreenshotsFromLocalFileDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.LocalFileDocumentRef document, Screenshotter.ScreenshotterSettings settings) throws Exception {
        return this.screenshotterService.extractScreenshotsFromLocalFileDocumentRef(authCtx, projectKey, document, settings);
    }

    public Screenshotter.ScreenshotterResponseOrError extractScreenshotsFromTmpDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.TmpDocumentRef document, Screenshotter.ScreenshotterSettings settings) throws Exception {
        return this.screenshotterService.extractScreenshotsFromTmpDocumentRef(authCtx, projectKey, document, settings);
    }

    public StructuredExtractor.StructuredExtractionResponseOrError runStructuredExtractorFromManagedFolderDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.ManagedFolderDocumentRef document, StructuredExtractor.StructuredExtractorSettings settings) throws Exception {
        File tmpFile;
        ManagedFolder mf;
        try (Transaction t = this.transactionService.beginRead();){
            AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, document.managedFolderId);
            mf = this.managedFoldersService.getMandatoryUnsafe(managedFolderLoc);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
            handler.getProvider();
            EnrichedInputStream docStream = handler.getInputStream(document.filePath);
            try (InputStream inputStream = docStream.rawStream();){
                File tmpFolder = DSSTempUtils.getTempFolderWithSpecifiName((String)"docextraction", (String)STRUCTURED_EXTRACTION);
                tmpFile = File.createTempFile("doc" + FilenameUtils.getBaseName((String)docStream.getFilename()), "." + FilenameUtils.getExtension((String)docStream.getFilename()), tmpFolder);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tmpFile);
            }
        }
        try (InputStream fileStream = DKUFileUtils.readWithAutoDecompress((File)tmpFile);){
            StructuredExtractor.StructuredExtractionResponseOrError structuredExtractionResponseOrError = this.runStructuredExtractorFromInputStream(authCtx, projectKey, tmpFile, fileStream, document.filePath, settings);
            return structuredExtractionResponseOrError;
        }
    }

    public StructuredExtractorResponseOrError runStructuredExtractionFromManagedFolderAndFlattenToTextChunks(AuthCtx authCtx, String projectKey, InputRefs.ManagedFolderDocumentRef document, StructuredExtractor.StructuredExtractorSettings settings, boolean useSeparatedChunksForImages) throws Exception {
        StructuredExtractor.StructuredExtractionResponseOrError structuredExtractionResponseOrError = this.runStructuredExtractorFromManagedFolderDocumentRef(authCtx, projectKey, document, settings);
        if (structuredExtractionResponseOrError.ok) {
            return StructuredExtractorResponseOrError.fromSuccess(StructuredExtractor.flattenTreeAndMergeContinuousSectionContent(structuredExtractionResponseOrError.content, useSeparatedChunksForImages));
        }
        return StructuredExtractorResponseOrError.fromError(new Exception(structuredExtractionResponseOrError.errorMessage));
    }

    public StructuredExtractor.StructuredExtractionResponseOrError runStructuredExtractorFromLocalFileDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.LocalFileDocumentRef document, StructuredExtractor.StructuredExtractorSettings settings) throws Exception {
        File docFile;
        String ext = FilenameUtils.getExtension((String)document.multipartFile.getOriginalFilename());
        try {
            File tmpFolder = DSSTempUtils.getTempFolderWithSpecifiName((String)"docextraction", (String)STRUCTURED_EXTRACTION);
            docFile = File.createTempFile("doc" + FilenameUtils.getBaseName((String)document.multipartFile.getOriginalFilename()), "." + ext, tmpFolder);
            FileUtils.copyInputStreamToFile((InputStream)document.multipartFile.getInputStream(), (File)docFile);
        }
        catch (IOException e) {
            throw new IOException("Cannot write the file to tmp folder", e);
        }
        try (InputStream fileStream = DKUFileUtils.readWithAutoDecompress((File)docFile);){
            StructuredExtractor.StructuredExtractionResponseOrError structuredExtractionResponseOrError = this.runStructuredExtractorFromInputStream(authCtx, projectKey, docFile, fileStream, document.multipartFile.getOriginalFilename(), settings);
            return structuredExtractionResponseOrError;
        }
    }

    public StructuredExtractor.StructuredExtractionResponseOrError runStructuredExtractorFromInputStream(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, String fileName, StructuredExtractor.StructuredExtractorSettings settings) throws Exception {
        String ext = FilenameUtils.getExtension((String)fileName).toLowerCase();
        ErrorContext.check((boolean)StringUtils.isNotBlank((String)ext), (String)"File extension cannot be blank");
        ErrorContext.check((settings.maxSectionDepth >= 0 ? 1 : 0) != 0, (String)"Max section depth cannot be strictly lower than 0");
        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Starting structured extraction"));
        if (settings.imageHandlingMode == StructuredExtractor.ImageHandlingMode.OCR && settings.ocrSettings == null) {
            logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "ImageHandlingMode is set to OCR but OCRSettings is null, will ignore images"));
            settings.imageHandlingMode = StructuredExtractor.ImageHandlingMode.IGNORE;
        } else if (settings.imageHandlingMode == StructuredExtractor.ImageHandlingMode.VLM_ANNOTATE) {
            if (settings.vlmAnnotationSettings == null || StringUtils.isBlank((String)settings.vlmAnnotationSettings.llmId)) {
                throw new IllegalArgumentException("ImageHandlingMode is set to VLM_ANNOTATE but VLMAnnotationSettings is null or llmID is not set");
            }
            settings.vlmAnnotationSettings.llmPrompt = StringUtils.defaultIfBlank((String)settings.vlmAnnotationSettings.llmPrompt, (String)StructuredExtractor.getVlmDefaultAnnotationPrompt(null));
        }
        switch (ext) {
            case "jpeg": 
            case "jpg": 
            case "png": {
                ErrorContext.check((settings.imageHandlingMode == StructuredExtractor.ImageHandlingMode.OCR ? 1 : 0) != 0, (String)"OCR must be enabled to process images");
                return this.structuredExtractionWithDocExtractionKernelPool(authCtx, projectKey, tmpFile, fileStream, fileName, settings);
            }
            case "html": {
                if (settings.imageHandlingMode == StructuredExtractor.ImageHandlingMode.OCR) {
                    logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "OCR is enabled for this HTML file, but it is not supported and will be ignored"));
                }
                if (settings.imageHandlingMode == StructuredExtractor.ImageHandlingMode.VLM_ANNOTATE) {
                    logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Vlm captioning is enabled for this HTML file, but it is not supported and will be ignored"));
                }
                settings.imageHandlingMode = StructuredExtractor.ImageHandlingMode.IGNORE;
                settings.ocrSettings = null;
                return this.structuredExtractionWithDocExtractionKernelPool(authCtx, projectKey, tmpFile, fileStream, fileName, settings);
            }
            case "pptx": 
            case "docx": 
            case "pdf": {
                return this.structuredExtractionWithDocExtractionKernelPool(authCtx, projectKey, tmpFile, fileStream, fileName, settings);
            }
            case "md": {
                String markdown = this.detectEncodingAndBuildStringFromInputStream(fileStream);
                StructuredContent root = StructuredExtractor.runMarkdownStructuredExtraction(markdown, settings.maxSectionDepth);
                return StructuredExtractor.StructuredExtractionResponseOrError.fromSuccess(root);
            }
            case "txt": {
                String txt = this.detectEncodingAndBuildStringFromInputStream(fileStream);
                return StructuredExtractor.StructuredExtractionResponseOrError.fromSuccess(StructuredExtractor.runTxtStructuredExtraction(txt));
            }
        }
        throw new UnsupportedMediaTypeStatusException("Cannot perform structured extraction file:" + fileName + " because ." + ext + " files are not supported");
    }

    private ManagedFolder getManagedFolder(String projectKey, String documentRef) throws IOException {
        ManagedFolder mf;
        AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, documentRef);
        if (TransactionContext.hasAttachedTransaction()) {
            mf = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(managedFolderLoc);
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                mf = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(managedFolderLoc);
            }
        }
        return mf;
    }

    private void performVLMAnnotationsOnInlinedImages(AuthCtx authCtx, StructuredContent content, String projectKey, String fileName, StructuredExtractor.StructuredExtractorSettings settings) throws Exception {
        Params params = AbstractSQLConnection.CustomDatabaseProperty.toParams(settings.dkuProperties);
        Params dkuAppParams = DKUApp.getParams();
        List<String> filteredClasses = DSSKernelUtils.getCSVParamAsListWithFallback(params, dkuAppParams, "dku.docextraction.structured.imageClassificationFiltering.classes", DEFAULT_IMAGE_CLASSIFICATION_FILTERED_CLASSES);
        double threshold = DSSKernelUtils.getDoubleParamWithFallback(params, dkuAppParams, "dku.docextraction.structured.imageClassificationFiltering.threshold", 0.8);
        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Images classified as [" + String.join((CharSequence)", ", filteredClasses) + "] with confidence >= " + threshold + " will be filtered out for VLM annotation"));
        Queue<String> annotations = this.runVLMQueriesForAnnotationsOnImages(authCtx, projectKey, content, fileName, settings.vlmAnnotationSettings, settings.imageValidation, filteredClasses, threshold);
        this.enrichStructuredContentWithVLMAnnotations(content, annotations);
    }

    private void storeImagesInManagedFolder(StructuredContent content, AuthCtx authCtx, String projectKey, File tmpFile, String fileName, String outputManagedFolderId) throws Exception {
        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Storing detected images in managed folder "));
        ManagedFolder outputMf = this.getManagedFolder(projectKey, outputManagedFolderId);
        String digest = Hex.encodeHexString((byte[])DocExtractionUtils.computeDigestFromFile(tmpFile).digest());
        try (ManagedFolderHandler handler = (ManagedFolderHandler)outputMf.buildHandler(authCtx);){
            AtomicInteger imageIndex = new AtomicInteger(1);
            this.writeImageFromStructuredContent(content, handler, outputManagedFolderId, fileName, digest, imageIndex);
        }
    }

    private StructuredExtractor.StructuredExtractionResponseOrError structuredExtractionWithDocExtractionKernelPool(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, String fileName, StructuredExtractor.StructuredExtractorSettings settings) throws Exception {
        int timeoutInMinutes = DKUApp.getParams().getIntParam("dku.docextraction.structured.timeoutInMinutes", Integer.valueOf(240));
        DocExtractionKernelPool.StructuredContentResponse doclingExtractionResult = this.docExtractionKernelPool.structuredExtractWithDocling(authCtx, projectKey, settings, fileStream, fileName, timeoutInMinutes);
        if (doclingExtractionResult.ok) {
            if (settings.imageHandlingMode == StructuredExtractor.ImageHandlingMode.VLM_ANNOTATE) {
                this.performVLMAnnotationsOnInlinedImages(authCtx, doclingExtractionResult.resp, projectKey, fileName, settings);
            }
            if (StringUtils.isNotBlank((String)settings.outputManagedFolderId)) {
                this.storeImagesInManagedFolder(doclingExtractionResult.resp, authCtx, projectKey, tmpFile, fileName, settings.outputManagedFolderId);
            }
            if (settings.maxSectionDepth != 0 && FilenameUtils.getExtension((String)fileName).equalsIgnoreCase("docx") && AbstractSQLConnection.CustomDatabaseProperty.toParams(settings.dkuProperties).getBoolParam(DOCX_HEADING_LEVEL_CORRECTION, true)) {
                logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Applying DOCX heading level correction by increasing maxSectionDepth by 1, this can be disabled by setting the recipe property 'dku.docextraction.structured.docxHeadingLevelCorrection' to false"));
                StructuredExtractor.flattenContentDeeperThanMaxSectionDepth(doclingExtractionResult.resp, settings.maxSectionDepth + 1);
            } else {
                StructuredExtractor.flattenContentDeeperThanMaxSectionDepth(doclingExtractionResult.resp, settings.maxSectionDepth);
            }
            return StructuredExtractor.StructuredExtractionResponseOrError.fromSuccess(doclingExtractionResult.resp);
        }
        return StructuredExtractor.StructuredExtractionResponseOrError.fromError(new Exception("Failed to convert document using docling because of python exception: " + doclingExtractionResult.error));
    }

    private void writeImageFromStructuredContent(StructuredContent content, ManagedFolderHandler managedFolderHandler, String managedFolderID, String originalFilePath, String fileDigest, AtomicInteger imageIdx) throws Exception {
        if (content == null) {
            return;
        }
        if (content.getType().equals("image")) {
            StructuredContent.Image contentAsImage = (StructuredContent.Image)content;
            if (!(contentAsImage.imageRef instanceof InputRefs.SingleInlineImage)) {
                logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Image content does not have an inline image ref, skipping image saving"));
                return;
            }
            String extension = DocExtractionService.getExtensionFromMimeType(contentAsImage.mimeType);
            if (extension == null) {
                logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Cannot determine image extension from mime type " + contentAsImage.mimeType + ", skipping image saving"));
                return;
            }
            int index = imageIdx.getAndIncrement();
            String outputImagePath = PathUtils.concatLNT((String[])new String[]{originalFilePath, "images-" + fileDigest, "image_" + DocExtractionUtils.padPageNumber(index) + "." + extension});
            byte[] imageBytes = Base64.getDecoder().decode(((InputRefs.SingleInlineImage)contentAsImage.imageRef).content);
            try (ByteArrayInputStream in = new ByteArrayInputStream(imageBytes);
                 OutputStream out = managedFolderHandler.getOutputStream(outputImagePath);){
                logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Writing " + outputImagePath));
                ByteStreams.copy((InputStream)in, (OutputStream)out);
            }
            catch (Exception e) {
                throw new Exception(DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Cannot write extracted image to managed folder"), e);
            }
            contentAsImage.imageRef = new InputRefs.SingleManagedFolderImageRef(managedFolderID, outputImagePath);
        } else {
            if (content.content == null) {
                return;
            }
            for (StructuredContent child : content.content) {
                this.writeImageFromStructuredContent(child, managedFolderHandler, managedFolderID, originalFilePath, fileDigest, imageIdx);
            }
        }
    }

    private static String getExtensionFromMimeType(String mimeType) {
        HashMap<String, String> mimeToExt = new HashMap<String, String>();
        mimeToExt.put("image/png", "png");
        mimeToExt.put("image/jpeg", "jpeg");
        mimeToExt.put("image/jpg", "jpg");
        mimeToExt.put("image/gif", "gif");
        mimeToExt.put("image/webp", "webp");
        mimeToExt.put("image/bmp", "bmp");
        return (String)mimeToExt.get(mimeType.toLowerCase());
    }

    private void enrichStructuredContentWithVLMAnnotations(StructuredContent content, Queue<String> annotations) throws Exception {
        if (content == null) {
            return;
        }
        if (content.getType().equals("image")) {
            StructuredContent.Image contentAsImage = (StructuredContent.Image)content;
            contentAsImage.description = annotations.poll();
        } else {
            if (content.content == null) {
                return;
            }
            for (StructuredContent child : content.content) {
                this.enrichStructuredContentWithVLMAnnotations(child, annotations);
            }
        }
    }

    @VisibleForTesting
    protected ImageTraversalResult buildVLMAnnotationOnImageQueries(StructuredContent content, StructuredExtractor.VLMAnnotationSettings settings, String fileName, boolean filterOutUselessImages, List<String> imageClassToFilter, double thresholdForClassification) {
        if (content == null) {
            return ImageTraversalResult.EMPTY;
        }
        if (content.getType().equals("image")) {
            StructuredContent.Image contentAsImage = (StructuredContent.Image)content;
            FilteredImages selfCount = FilteredImages.EMPTY;
            if (filterOutUselessImages && contentAsImage.classificationData != null && StringUtils.isNotBlank((String)contentAsImage.classificationData.className) && contentAsImage.classificationData.confidence >= thresholdForClassification && imageClassToFilter.contains(contentAsImage.classificationData.className)) {
                logger.debug((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Skipping VLM annotation for image classified as " + contentAsImage.classificationData.className + " with confidence " + contentAsImage.classificationData.confidence));
                selfCount = FilteredImages.forClass(contentAsImage.classificationData.className);
                return new ImageTraversalResult(Collections.singletonList(null), selfCount);
            }
            InputRefs.SingleImageRef singleImageRef = contentAsImage.imageRef;
            if (!(singleImageRef instanceof InputRefs.SingleInlineImage)) {
                logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Image content does not have an inline image ref, skipping VLM annotation"));
                return new ImageTraversalResult(Collections.singletonList(null), selfCount);
            }
            InputRefs.SingleInlineImage singleInlineImage = (InputRefs.SingleInlineImage)singleImageRef;
            String mimeType = singleInlineImage.mimeType;
            String inline = singleInlineImage.content;
            if (StringUtils.isBlank((String)mimeType)) {
                logger.warn((Object)"Image content does not have a mime type, skipping VLM annotation");
                return new ImageTraversalResult(Collections.singletonList(null), selfCount);
            }
            if (!mimeType.equals("image/png") && !mimeType.equals("image/jpg")) {
                try {
                    DocExtractionService.convertImageToPng(mimeType, inline, contentAsImage, fileName);
                }
                catch (Exception e) {
                    logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Cannot convert image from mime type " + contentAsImage.mimeType + " to PNG, skipping image for VLM annotation"), (Throwable)e);
                    return new ImageTraversalResult(Collections.singletonList(null), selfCount);
                }
            }
            ArrayList<LLMClient.ChatMessagePart> parts = new ArrayList<LLMClient.ChatMessagePart>();
            ArrayList<LLMClient.ChatMessage> messages = new ArrayList<LLMClient.ChatMessage>();
            messages.add(new LLMClient.ChatMessage("system", Collections.singletonList(new LLMClient.ChatMessagePart().withText(settings.llmPrompt))));
            if (StringUtils.isNotBlank((String)contentAsImage.caption)) {
                messages.add(new LLMClient.ChatMessage("system", Collections.singletonList(new LLMClient.ChatMessagePart().withText("To help you understand the image, here is the caption of the image: "))));
                messages.add(new LLMClient.ChatMessage("user", Collections.singletonList(new LLMClient.ChatMessagePart().withText(contentAsImage.caption))));
            }
            parts.add(new LLMClient.ChatMessagePart().withInlineImage(singleInlineImage.content, contentAsImage.mimeType));
            messages.add(new LLMClient.ChatMessage("user", parts));
            LLMClient.SingleCompletionQuery query = new LLMClient.SingleCompletionQuery();
            query.messages = messages;
            return new ImageTraversalResult(Collections.singletonList(query), selfCount);
        }
        if (content.content == null) {
            return ImageTraversalResult.EMPTY;
        }
        ImageTraversalResult aggregatedResult = ImageTraversalResult.EMPTY;
        for (StructuredContent child : content.content) {
            aggregatedResult = aggregatedResult.combine(this.buildVLMAnnotationOnImageQueries(child, settings, fileName, filterOutUselessImages, imageClassToFilter, thresholdForClassification));
        }
        return aggregatedResult;
    }

    private static void convertImageToPng(String mimeType, String inline, StructuredContent.Image contentAsImage, String fileName) throws Exception {
        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "The image mime type " + mimeType + " is likely not supported by VLM for annotation, will attempt conversion to png for VLM compatibility."));
        String cleanBase64 = inline;
        if (inline.contains(",")) {
            cleanBase64 = inline.substring(inline.indexOf(",") + 1);
        }
        byte[] imageBytes = Base64.getDecoder().decode(cleanBase64);
        try (ByteArrayInputStream in = new ByteArrayInputStream(imageBytes);){
            BufferedImage image = ImageIO.read(in);
            if (image == null) {
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Cannot read image for conversion, skipping image for VLM annotation"));
                throw new Exception("Cannot read image for conversion, skipping image for VLM annotation");
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", outputStream);
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Done converting image to PNG"));
            ((InputRefs.SingleInlineImage)contentAsImage.imageRef).content = Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
    }

    private Queue<String> runVLMQueriesForAnnotationsOnImages(AuthCtx authCtx, String projectKey, StructuredContent content, String fileName, StructuredExtractor.VLMAnnotationSettings settings, boolean filterOutUselessImages, List<String> imageClassToFilter, double thresholdForClassification) throws Exception {
        LLMStructuredRef llmStructuredRef = LLMStructuredRef.decodeId(settings.llmId);
        GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings(authCtx, projectKey, llmStructuredRef);
        GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings(connectionGuardrailsPipelineSettings, null);
        ImageTraversalResult imageTraversalResult = this.buildVLMAnnotationOnImageQueries(content, settings, fileName, filterOutUselessImages, imageClassToFilter, thresholdForClassification);
        if (imageTraversalResult.filteredImages.countsByClass.isEmpty()) {
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "No images were filtered out during classification step"));
        } else {
            String detailedCounts = imageTraversalResult.filteredImages.countsByClass.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining(", "));
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "Images were filtered out during classification step: " + detailedCounts + "."));
        }
        List<LLMClient.SingleCompletionQuery> queries = imageTraversalResult.queries;
        List<LLMClient.SingleCompletionQuery> queriesWithoutNulls = queries.stream().filter(Objects::nonNull).toList();
        if (queriesWithoutNulls.isEmpty()) {
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "No images found for VLM annotation, skipping VLM annotation step"));
            return new LinkedList<String>();
        }
        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(fileName, "About to send " + queriesWithoutNulls.size() + " queries to VLM for description"));
        LinkedList<String> annotations = new LinkedList<String>();
        try (LLMMeshClient llmClient = LLMMeshClientFactory.get(authCtx, projectKey, llmStructuredRef, guardrailsPipelineSettings, null, queriesWithoutNulls.size());){
            EnrichedLLMStructuredRef enrichedRef = llmClient.getEnrichedRef();
            List<LLMClient.SimpleCompletionResponseOrError> responses = llmClient.completeQueries(queriesWithoutNulls, new LLMClient.CompletionSettings());
            ComputeResourceUsage cru = llmClient.getTotalCRU(ComputeResourceUsage.LLMUsageType.COMPLETION);
            if (cru != null) {
                this.cruReportingService.reportComplete(cru);
            }
            for (int recordIdx = 0; recordIdx < responses.size(); ++recordIdx) {
                LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded(this.auditTrailService, enrichedRef, llmClient.getConnection(), queriesWithoutNulls.get(recordIdx), responses.get(recordIdx));
            }
            for (LLMClient.SimpleCompletionResponseOrError response : responses) {
                if (!response.ok) {
                    throw new IOException("Got error from LLM while processing request: " + response.errorMessage);
                }
                annotations.offer(response.text);
            }
            LinkedList<String> annotationsWithNulls = new LinkedList<String>();
            for (LLMClient.SingleCompletionQuery query : queries) {
                if (query == null) {
                    annotationsWithNulls.add(null);
                    continue;
                }
                annotationsWithNulls.add((String)annotations.poll());
            }
            LinkedList<String> linkedList = annotationsWithNulls;
            return linkedList;
        }
    }

    /*
     * Exception decompiling
     */
    private String detectEncodingAndBuildStringFromInputStream(InputStream stream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<? extends VlmExtractionChunk> runVLMextractor(AuthCtx authCtx, String projectKey, VLMExtractor.VLMExtractorRequest request) throws Exception {
        Pair<List<LLMClient.SingleCompletionQuery>, List<VlmExtractionChunk>> singleCompletionQueriesToVlmChunks = this.validateSettingsAndBuildCompletionQueries(authCtx, projectKey, request);
        List singleCompletionQueries = (List)singleCompletionQueriesToVlmChunks.first;
        List chunks = (List)singleCompletionQueriesToVlmChunks.second;
        LLMStructuredRef llmStructuredRef = LLMStructuredRef.decodeId(request.settings.llmId);
        GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings(authCtx, projectKey, llmStructuredRef);
        GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings(connectionGuardrailsPipelineSettings, null);
        try (LLMMeshClient llmClient = LLMMeshClientFactory.get(authCtx, projectKey, llmStructuredRef, guardrailsPipelineSettings, null, singleCompletionQueries.size());){
            EnrichedLLMStructuredRef enrichedRef = llmClient.getEnrichedRef();
            ErrorContext.check((boolean)enrichedRef.supportsImageInputs, (String)("Provided model: " + request.settings.llmId + " does not support image inputs"));
            List<LLMClient.SimpleCompletionResponseOrError> responses = llmClient.completeQueries(singleCompletionQueries, new LLMClient.CompletionSettings());
            ComputeResourceUsage cru = llmClient.getTotalCRU(ComputeResourceUsage.LLMUsageType.COMPLETION);
            if (cru != null) {
                this.cruReportingService.reportComplete(cru);
            }
            for (int recordIdx = 0; recordIdx < responses.size(); ++recordIdx) {
                LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded(this.auditTrailService, enrichedRef, llmClient.getConnection(), (LLMClient.SingleCompletionQuery)singleCompletionQueries.get(recordIdx), responses.get(recordIdx));
            }
            assert (chunks.size() == responses.size());
            int i = 0;
            for (LLMClient.SimpleCompletionResponseOrError response : responses) {
                if (!response.ok) {
                    throw new IOException("Got error from LLM while processing request: " + response.errorMessage);
                }
                ((VlmExtractionChunk)chunks.get((int)i)).promptOutput = response.text;
                ++i;
            }
            List list = chunks;
            return list;
        }
    }

    private ExceptionUtils.ThrowingBiFunction<Integer, Integer, List<InputRefs.SingleInlineImage>, Exception> generateInlineImageGetterFromImagesRef(final AuthCtx authCtx, final String projectKey, final InputRefs.ImagesRef imagesRef) {
        return new ExceptionUtils.ThrowingBiFunction<Integer, Integer, List<InputRefs.SingleInlineImage>, Exception>(){

            public List<InputRefs.SingleInlineImage> apply(Integer i, Integer end) throws Exception {
                if (imagesRef instanceof InputRefs.ManagedFolderImagesRef) {
                    InputRefs.ManagedFolderImagesRef managedFolderImagesRef = (InputRefs.ManagedFolderImagesRef)imagesRef;
                    List<String> currentImagePaths = managedFolderImagesRef.imagesPaths.subList(i, end);
                    return DocExtractionService.this.getInlineImages(authCtx, projectKey, managedFolderImagesRef.managedFolderId, currentImagePaths);
                }
                if (imagesRef instanceof InputRefs.InlineImagesRef) {
                    InputRefs.InlineImagesRef inlineImagesRef = (InputRefs.InlineImagesRef)imagesRef;
                    return inlineImagesRef.inlineImages.subList(i, end);
                }
                throw new IllegalArgumentException("Cannot extract images from ImagesRef");
            }
        };
    }

    @VisibleForTesting
    protected Pair<List<LLMClient.SingleCompletionQuery>, List<VlmExtractionChunk>> validateSettingsAndBuildCompletionQueries(AuthCtx authCtx, String projectKey, VLMExtractor.VLMExtractorRequest request) throws Exception {
        int windowOverlap;
        int windowSize;
        Integer imageCount = request.inputs.imagesRef.getImageCount();
        ErrorContext.check((imageCount > 0 ? 1 : 0) != 0, (String)"At least one image is required for vlm extraction");
        ErrorContext.check((request.settings.windowSize != 0 ? 1 : 0) != 0, (String)"Window size cannot be equal to 0");
        ErrorContext.check((request.settings.windowSize >= -1 ? 1 : 0) != 0, (String)"Window size cannot be lower than -1");
        if (request.settings.windowSize == -1) {
            windowSize = imageCount;
            windowOverlap = 0;
        } else {
            ErrorContext.check((request.settings.windowSize > request.settings.windowOverlap ? 1 : 0) != 0, (String)"Window overlap cannot be greater or equal to window size");
            if (request.settings.windowSize >= imageCount) {
                windowSize = imageCount;
                windowOverlap = 0;
            } else {
                ErrorContext.check((request.settings.windowOverlap >= 0 ? 1 : 0) != 0, (String)"Window overlap cannot be strictly lower than 0");
                windowSize = request.settings.windowSize;
                windowOverlap = request.settings.windowOverlap;
            }
        }
        ArrayList<LLMClient.SingleCompletionQuery> completionQueries = new ArrayList<LLMClient.SingleCompletionQuery>();
        ArrayList<VlmExtractionChunk> vlmChunks = new ArrayList<VlmExtractionChunk>();
        ExceptionUtils.ThrowingBiFunction<Integer, Integer, List<InputRefs.SingleInlineImage>, Exception> inlineImageRefFromIndex = this.generateInlineImageGetterFromImagesRef(authCtx, projectKey, request.inputs.imagesRef);
        for (int i = 0; i < imageCount; i += windowSize - windowOverlap) {
            int end = Math.min(i + windowSize, imageCount);
            List<String> storedImagePaths = null;
            InputRefs.ImagesRef imagesRef = request.inputs.imagesRef;
            if (imagesRef instanceof InputRefs.ManagedFolderImagesRef) {
                InputRefs.ManagedFolderImagesRef managedFolderImagesRef = (InputRefs.ManagedFolderImagesRef)imagesRef;
                storedImagePaths = managedFolderImagesRef.imagesPaths.subList(i, end);
            }
            vlmChunks.add(VlmExtractionChunk.build(request.settings.windowSize, i + 1, end, storedImagePaths));
            completionQueries.add(this.buildVLMSingleCompletionQueryFromInlineImages((List)inlineImageRefFromIndex.apply((Object)i, (Object)end), request.settings.llmPrompt));
            if (end == imageCount) break;
        }
        return new Pair(completionQueries, vlmChunks);
    }

    private LLMClient.SingleCompletionQuery buildVLMSingleCompletionQueryFromInlineImages(List<InputRefs.SingleInlineImage> inlineImages, String prompt) {
        ArrayList<LLMClient.ChatMessagePart> parts = new ArrayList<LLMClient.ChatMessagePart>();
        ArrayList<LLMClient.ChatMessage> messages = new ArrayList<LLMClient.ChatMessage>();
        for (InputRefs.SingleInlineImage image : inlineImages) {
            parts.add(new LLMClient.ChatMessagePart().withInlineImage(image.content, image.mimeType));
        }
        messages.add(new LLMClient.ChatMessage("system", Collections.singletonList(new LLMClient.ChatMessagePart().withText(prompt))));
        messages.add(new LLMClient.ChatMessage("user", parts));
        LLMClient.SingleCompletionQuery query = new LLMClient.SingleCompletionQuery();
        query.messages = messages;
        return query;
    }

    protected List<InputRefs.SingleInlineImage> getInlineImages(AuthCtx authCtx, String projectKey, String folderId, List<String> imagePaths) throws Exception {
        ManagedFolder mf;
        ArrayList<InputRefs.SingleInlineImage> res = new ArrayList<InputRefs.SingleInlineImage>();
        try (Transaction t = this.transactionService.beginRead();){
            AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, folderId);
            mf = this.managedFoldersService.getMandatoryUnsafe(managedFolderLoc);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
            for (String imagePath : imagePaths) {
                Callable<InputStream> previewImage = () -> handler.getInputStream(imagePath).rawStream();
                InputStream img = previewImage.call();
                try {
                    byte[] sourceBytes = IOUtils.toByteArray((InputStream)img);
                    MimeTypeUtils.MimeType fullMimeType = MimeTypeUtils.fromExtension((String)FilenameUtils.getExtension((String)imagePath));
                    String mimeType = Optional.ofNullable(fullMimeType).map(obj -> obj.mimeType).orElse(null);
                    res.add(new InputRefs.SingleInlineImage(Base64.getEncoder().encodeToString(sourceBytes), mimeType));
                }
                finally {
                    if (img == null) continue;
                    img.close();
                }
            }
        }
        return res;
    }

    public record ImageTraversalResult(List<LLMClient.SingleCompletionQuery> queries, FilteredImages filteredImages) {
        public static final ImageTraversalResult EMPTY = new ImageTraversalResult(List.of(), FilteredImages.EMPTY);

        public ImageTraversalResult combine(ImageTraversalResult other) {
            ArrayList<LLMClient.SingleCompletionQuery> combinedList = new ArrayList<LLMClient.SingleCompletionQuery>(this.queries.size() + other.queries.size());
            combinedList.addAll(this.queries);
            combinedList.addAll(other.queries);
            FilteredImages combinedImages = this.filteredImages.combine(other.filteredImages);
            return new ImageTraversalResult(combinedList, combinedImages);
        }
    }

    public record FilteredImages(Map<String, Integer> countsByClass) {
        public static final FilteredImages EMPTY = new FilteredImages(Map.of());

        public FilteredImages {
            countsByClass = Map.copyOf(countsByClass);
        }

        public FilteredImages combine(FilteredImages other) {
            HashMap<String, Integer> combinedMap = new HashMap<String, Integer>(this.countsByClass.size() + other.countsByClass.size());
            combinedMap.putAll(this.countsByClass);
            other.countsByClass().forEach((key, value) -> combinedMap.merge((String)key, (Integer)value, Integer::sum));
            return new FilteredImages(combinedMap);
        }

        public static FilteredImages forClass(String imageClass) {
            if (imageClass == null || imageClass.isBlank()) {
                return EMPTY;
            }
            return new FilteredImages(Map.of(imageClass, 1));
        }
    }
}

