/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.computations.univariate;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Quantiles
extends Computation.UnivariateComputation {
    public static final String TYPE = "quantiles";
    public List<Double> freqs = new ArrayList<Double>();
    @Nullable
    public Double confidence;

    public Quantiles(String column) {
        this.column = column;
    }

    public Quantiles(String column, List<Double> freqs) {
        this.column = column;
        this.freqs = freqs;
    }

    public Quantiles(String column, List<Double> freqs, Double confidence) {
        this.column = column;
        this.freqs = freqs;
        this.confidence = confidence;
    }

    private Quantiles() {
    }

    public static class QuantilesResult
    extends AvailableResult {
        public List<QuantileDesc> quantiles;

        public QuantileDesc getMand(double freq) {
            for (QuantileDesc q : this.quantiles) {
                if (q.freq != freq) continue;
                return q;
            }
            throw new RuntimeException("Quantile not found in results: " + freq);
        }

        public QuantilesResult(List<QuantileDesc> quantiles) {
            this.quantiles = quantiles;
        }

        public QuantilesResult(QuantileDesc ... quantiles) {
            this.quantiles = Lists.newArrayList((Object[])quantiles);
        }

        private QuantilesResult() {
        }
    }

    @UIModel
    public static class QuantileDesc
    extends ImmutableValueObject {
        public double quantile;
        public double freq;
        @Nullable
        public Double lower;
        @Nullable
        public Double upper;

        private QuantileDesc() {
        }

        public QuantileDesc(double quantile, double freq, @Nullable Double lower, @Nullable Double upper) {
            this.quantile = quantile;
            this.freq = freq;
            this.lower = lower;
            this.upper = upper;
        }
    }
}

