/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.expressions;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.refine.expr.Evaluable;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.grel.ast.ControlCallExpr;
import com.google.refine.grel.ast.FieldAccessorExpr;
import com.google.refine.grel.ast.FunctionCallExpr;
import com.google.refine.grel.ast.LiteralExpr;
import com.google.refine.grel.ast.OperatorCallExpr;
import com.google.refine.grel.ast.VariableExpr;
import java.util.ArrayList;
import java.util.List;

public class GrelToQueryTranslator
extends GrelTranslator {
    private static final ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    private Schema schema;

    public GrelToQueryTranslator(GrelTranslator.GrelMapping mapping) {
        super(mapping);
    }

    public GrelToQueryTranslator(GrelTranslator.GrelMapping mapping, Schema schema) {
        super(mapping);
        this.schema = schema;
    }

    public GrelToQueryTranslator(GrelTranslator.GrelMapping mapping, ControlFunctionRegistry registry) {
        super(mapping, registry);
    }

    private ExpressionBuilder evaluableToExpression(OperatorCallExpr ev) {
        String grelName = ev._op;
        return this.buildOperatorExpression(grelName, ev._args);
    }

    private void gatherUsedColumns(OperatorCallExpr ev, List<String> lst) {
        String grelName = ev._op;
        this.gatherUsedColumnsOperatorExpression(grelName, ev._args, lst);
    }

    private ExpressionBuilder evaluableToExpression(FunctionCallExpr ev) {
        String grelName = this.getGrelName(ev._function);
        return this.buildOperatorExpression(grelName, ev._args);
    }

    private void gatherUsedColumns(FunctionCallExpr ev, List<String> lst) {
        String grelName = this.getGrelName(ev._function);
        this.gatherUsedColumnsOperatorExpression(grelName, ev._args, lst);
    }

    private ExpressionBuilder evaluableToExpression(ControlCallExpr ev) {
        String grelName = this.getGrelName(ev._control);
        return this.buildOperatorExpression(grelName, ev._args);
    }

    private void gatherUsedColumns(ControlCallExpr ev, List<String> lst) {
        String grelName = this.getGrelName(ev._control);
        this.gatherUsedColumnsOperatorExpression(grelName, ev._args, lst);
    }

    private ExpressionBuilder buildOperatorExpression(String grelName, Evaluable[] evaluableArgs) {
        GrelTranslator.GrelMapping.DynamicOp dynamicOp = this.mapping.getDynamicOp(grelName);
        if (dynamicOp != null) {
            ExpressionBuilder[] args = new ExpressionBuilder[evaluableArgs.length];
            for (int i = 0; i < evaluableArgs.length; ++i) {
                args[i] = this.evaluableToExpression(evaluableArgs[i]);
            }
            return dynamicOp.translate(grelName, evaluableArgs, args);
        }
        QueryUtils.OperatorType dssOpType = this.mapping.getOperatorDssName(grelName, evaluableArgs);
        if (dssOpType == null) {
            throw new IllegalArgumentException("Function or operator \"" + grelName + "\" is not supported.");
        }
        Object[] args = new ExpressionBuilder[evaluableArgs.length];
        for (int i = 0; i < evaluableArgs.length; ++i) {
            args[i] = this.evaluableToExpression(evaluableArgs[i]);
        }
        Object[] dssArgs = this.mapping.getOperatorDssArgs(grelName, (ExpressionBuilder[])args);
        ExpressionBuilder opExpr = ef.op(dssOpType, dssArgs);
        opExpr.expr.outputType.dssType = QueryUtils.getKnownOutputType(dssOpType, args, (ExpressionBuilder[])dssArgs);
        return opExpr;
    }

    private void gatherUsedColumnsOperatorExpression(String grelName, Evaluable[] evaluableArgs, List<String> lst) {
        for (Evaluable evaluableArg : evaluableArgs) {
            this.gatherUsedColumnsRec(evaluableArg, lst);
        }
    }

    private ExpressionBuilder evaluableToExpression(LiteralExpr ev) {
        return ef.cst(ev._value);
    }

    private void gatherUsedColumns(LiteralExpr ev, List<String> lst) {
    }

    private ExpressionBuilder evaluableToExpression(VariableExpr ev) {
        SchemaColumn column;
        String columnName = this.originalExpression.makeAcceptable(ev._name);
        ExpressionBuilder eb = this.schema != null ? ef.col(columnName, (column = this.schema.getColumn(columnName)) != null ? column.getType() : null) : ef.col(columnName);
        SchemaColumn sc = this.originalExpression.getSchemaColumnIfKnown(ev._name);
        if (sc != null) {
            eb.expr.outputType.dssType = sc.getType();
        }
        return eb;
    }

    private void gatherUsedColumns(VariableExpr ev, List<String> lst) {
        String columnName = this.originalExpression.makeAcceptable(ev._name);
        lst.add(columnName);
    }

    private ExpressionBuilder evaluableToExpression(FieldAccessorExpr ev) {
        if (ev._inner instanceof VariableExpr) {
            String tableName = ((VariableExpr)ev._inner)._name;
            String columnName = this.originalExpression.makeAcceptable(ev._fieldName);
            return ef.col(tableName, columnName);
        }
        throw new NotImplementedException();
    }

    private void gatherUsedColumns(FieldAccessorExpr ev, List<String> lst) {
        if (ev._inner instanceof VariableExpr) {
            String columnName = this.originalExpression.makeAcceptable(ev._fieldName);
            lst.add(columnName);
        }
    }

    protected ExpressionBuilder evaluableToExpression(Evaluable ev) {
        if (ev instanceof OperatorCallExpr) {
            return this.evaluableToExpression((OperatorCallExpr)ev);
        }
        if (ev instanceof LiteralExpr) {
            return this.evaluableToExpression((LiteralExpr)ev);
        }
        if (ev instanceof VariableExpr) {
            return this.evaluableToExpression((VariableExpr)ev);
        }
        if (ev instanceof FunctionCallExpr) {
            return this.evaluableToExpression((FunctionCallExpr)ev);
        }
        if (ev instanceof ControlCallExpr) {
            return this.evaluableToExpression((ControlCallExpr)ev);
        }
        if (ev instanceof FieldAccessorExpr) {
            return this.evaluableToExpression((FieldAccessorExpr)ev);
        }
        assert (false);
        return null;
    }

    protected void gatherUsedColumnsRec(Evaluable ev, List<String> lst) {
        if (ev instanceof OperatorCallExpr) {
            this.gatherUsedColumns((OperatorCallExpr)ev, lst);
        } else if (ev instanceof LiteralExpr) {
            this.gatherUsedColumns((LiteralExpr)ev, lst);
        } else if (ev instanceof VariableExpr) {
            this.gatherUsedColumns((VariableExpr)ev, lst);
        } else if (ev instanceof FunctionCallExpr) {
            this.gatherUsedColumns((FunctionCallExpr)ev, lst);
        } else if (ev instanceof ControlCallExpr) {
            this.gatherUsedColumns((ControlCallExpr)ev, lst);
        } else if (ev instanceof FieldAccessorExpr) {
            this.gatherUsedColumns((FieldAccessorExpr)ev, lst);
        } else assert (false);
    }

    public GrelTranslator.TranslationResult<String> translateToString(Expression expression, boolean translateFully) {
        GrelTranslator.TranslationResult<ExpressionBuilder> query = this.translateToQuery(expression, translateFully);
        String translation = null;
        if (query.result != null) {
            translation = this.mapping.translateToString(((ExpressionBuilder)query.result).expr);
        }
        return new GrelTranslator.TranslationResult<Object>(translation, query.isFullyTranslated);
    }

    public GrelTranslator.TranslationResult<ExpressionBuilder> translateToQuery(Expression expression, boolean translateFully) {
        this.translateFully = translateFully;
        this.isFullyTranslated = this.preprocessExpression(expression);
        if (this.root == null) {
            return new GrelTranslator.TranslationResult<Object>(null, this.isFullyTranslated);
        }
        ExpressionBuilder queryExpression = this.evaluableToExpression(this.root);
        return new GrelTranslator.TranslationResult<ExpressionBuilder>(queryExpression, this.isFullyTranslated);
    }

    public List<String> getUsedColumns(Expression expression, boolean translateFully) {
        ArrayList<String> ret = new ArrayList<String>();
        this.translateFully = translateFully;
        this.isFullyTranslated = this.preprocessExpression(expression);
        if (this.root == null) {
            return ret;
        }
        this.gatherUsedColumnsRec(this.root, ret);
        return ret;
    }
}

