/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.hive.HiveCodes;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class SerdeAccessUtils {
    private static Class<?> serdeClassCache = null;
    private final Class<?> serdeClass = SerdeAccessUtils.getSerdeBaseClass();
    private Method initializeMethod;
    private Method getSerializedClassMethod;
    private Method getObjectInspectorMethod;
    private Method serializeMethod;
    private Method deserializeMethod;
    private static Logger logger = Logger.getLogger((String)"dip.hive.serde.utils");

    private static Class<?> getSerdeBaseClass() {
        if (serdeClassCache == null) {
            try {
                serdeClassCache = SerdeAccessUtils.class.getClassLoader().loadClass("org.apache.hadoop.hive.serde2.SerDe");
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"The old org.apache.hadoop.hive.serde2.SerDe is not available", (Throwable)e);
                try {
                    serdeClassCache = SerdeAccessUtils.class.getClassLoader().loadClass("org.apache.hadoop.hive.serde2.AbstractSerDe");
                }
                catch (ClassNotFoundException e2) {
                    logger.error((Object)"The new org.apache.hadoop.hive.serde2.AbstractSerDe is not available either", (Throwable)e);
                    throw new CodedRuntimeException((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_SERDE_CLASS_NOT_AVAILABLE, "No hive base serde class available");
                }
            }
        }
        return serdeClassCache;
    }

    public boolean isSerde(Object serde) {
        return this.serdeClass.isAssignableFrom(serde.getClass());
    }

    public void initialize(Object serde, Configuration configuration, Properties properties) throws SerDeException {
        try {
            this.fetchInitializeMethod();
            this.initializeMethod.invoke(serde, configuration, properties);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SerDeException("Failed to get and call initialize", (Throwable)e);
        }
    }

    public Class<? extends Writable> getSerializedClass(Object serde) {
        try {
            this.fetchGetSerializedClassMethod();
            return (Class)this.getSerializedClassMethod.invoke(serde, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_SERDE_CLASS_NOT_AVAILABLE, "Serde class found but failed to getSerializedClass", (Throwable)e);
        }
    }

    public ObjectInspector getObjectInspector(Object serde) throws SerDeException {
        try {
            this.fetchGetObjectInspectorMethod();
            return (ObjectInspector)this.getObjectInspectorMethod.invoke(serde, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SerDeException("Failed to get and call getObjectInspector", (Throwable)e);
        }
    }

    public Writable serialize(Object serde, Object row, ObjectInspector inspector) throws SerDeException {
        try {
            this.fetchSerializeMethod();
            return (Writable)this.serializeMethod.invoke(serde, row, inspector);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SerDeException("Failed to get and call serialize", (Throwable)e);
        }
    }

    public Object deserialize(Object serde, Writable value) throws SerDeException {
        try {
            this.fetchDeserializeMethod();
            return this.deserializeMethod.invoke(serde, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SerDeException("Failed to get and call deserialize", (Throwable)e);
        }
    }

    private void fetchInitializeMethod() throws NoSuchMethodException {
        if (this.initializeMethod == null) {
            this.initializeMethod = this.serdeClass.getMethod("initialize", Configuration.class, Properties.class);
        }
    }

    private void fetchGetSerializedClassMethod() throws NoSuchMethodException {
        if (this.getSerializedClassMethod == null) {
            this.getSerializedClassMethod = this.serdeClass.getMethod("getSerializedClass", new Class[0]);
        }
    }

    private void fetchGetObjectInspectorMethod() throws NoSuchMethodException {
        if (this.getObjectInspectorMethod == null) {
            this.getObjectInspectorMethod = this.serdeClass.getMethod("getObjectInspector", new Class[0]);
        }
    }

    private void fetchSerializeMethod() throws NoSuchMethodException {
        if (this.serializeMethod == null) {
            this.serializeMethod = this.serdeClass.getMethod("serialize", Object.class, ObjectInspector.class);
        }
    }

    private void fetchDeserializeMethod() throws NoSuchMethodException {
        if (this.deserializeMethod == null) {
            this.deserializeMethod = this.serdeClass.getMethod("deserialize", Writable.class);
        }
    }
}

