/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet.datetime;

import com.dataiku.dip.input.formats.parquet.datetime.DateFormatSymbolsEx;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LocaleUtil {
    protected static Map<String, LocaleData> locales = new HashMap<String, LocaleData>();

    protected static LocaleData lookupLocaleData(String code) {
        LocaleData localeData = locales.get(code);
        if (localeData == null) {
            String[] data = LocaleUtil.decodeLocaleCode(code);
            localeData = new LocaleData(new Locale(data[0], data[1], data[2]));
            locales.put(code, localeData);
        }
        return localeData;
    }

    protected static LocaleData lookupLocaleData(Locale locale) {
        return LocaleUtil.lookupLocaleData(LocaleUtil.resolveLocaleCode(locale));
    }

    public static Locale getLocale(String language, String country, String variant) {
        LocaleData localeData = LocaleUtil.lookupLocaleData(LocaleUtil.resolveLocaleCode(language, country, variant));
        return localeData.locale;
    }

    public static Locale getLocale(String language, String country) {
        return LocaleUtil.getLocale(language, country, null);
    }

    public static Locale getLocale(String languageCode) {
        LocaleData localeData = LocaleUtil.lookupLocaleData(languageCode);
        return localeData.locale;
    }

    public static String resolveLocaleCode(String lang, String country, String variant) {
        StringBuilder code = new StringBuilder(lang);
        if (!StringUtils.isEmpty((CharSequence)country)) {
            code.append('_').append(country);
            if (!StringUtils.isEmpty((CharSequence)variant)) {
                code.append('_').append(variant);
            }
        }
        return code.toString();
    }

    public static String resolveLocaleCode(Locale locale) {
        return LocaleUtil.resolveLocaleCode(locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public static String[] decodeLocaleCode(String localeCode) {
        String[] result = new String[3];
        String[] data = LocaleUtil.splitc(localeCode, '_');
        result[0] = data[0];
        result[2] = "";
        result[1] = "";
        if (data.length >= 2) {
            result[1] = data[1];
            if (data.length >= 3) {
                result[2] = data[2];
            }
        }
        return result;
    }

    public static String[] splitc(String src, char delimiter) {
        if (src.length() == 0) {
            return new String[]{""};
        }
        char[] srcc = src.toCharArray();
        int maxparts = srcc.length + 1;
        int[] start = new int[maxparts];
        int[] end = new int[maxparts];
        int count = 0;
        start[0] = 0;
        int s = 0;
        if (srcc[0] == delimiter) {
            end[0] = 0;
            ++count;
            s = LocaleUtil.findFirstDiff(srcc, 1, delimiter);
            if (s == -1) {
                return new String[]{"", ""};
            }
            start[1] = s;
        }
        while (true) {
            int e;
            if ((e = LocaleUtil.findFirstEqual(srcc, s, delimiter)) == -1) {
                end[count] = srcc.length;
                break;
            }
            end[count] = e;
            ++count;
            s = LocaleUtil.findFirstDiff(srcc, e, delimiter);
            if (s == -1) {
                start[count] = end[count] = srcc.length;
                break;
            }
            start[count] = s;
        }
        String[] result = new String[++count];
        for (int i = 0; i < count; ++i) {
            result[i] = src.substring(start[i], end[i]);
        }
        return result;
    }

    public static int findFirstEqual(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] != match) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] == match) continue;
            return i;
        }
        return -1;
    }

    public static DateFormatSymbolsEx getDateFormatSymbols(Locale locale) {
        LocaleData localeData = LocaleUtil.lookupLocaleData(locale);
        DateFormatSymbolsEx dfs = localeData.dateFormatSymbols;
        if (dfs == null) {
            localeData.dateFormatSymbols = dfs = new DateFormatSymbolsEx(locale);
        }
        return dfs;
    }

    public static NumberFormat getNumberFormat(Locale locale) {
        LocaleData localeData = LocaleUtil.lookupLocaleData(locale);
        NumberFormat nf = localeData.numberFormat;
        if (nf == null) {
            localeData.numberFormat = nf = NumberFormat.getInstance(locale);
        }
        return nf;
    }

    static class LocaleData {
        final Locale locale;
        DateFormatSymbolsEx dateFormatSymbols;
        NumberFormat numberFormat;

        LocaleData(Locale locale) {
            this.locale = locale;
        }
    }
}

