/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.tracker;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class GithubIssueNumberSniffer {
    private Set<String> toClose = Sets.newHashSet();
    private Set<String> toComment = Sets.newHashSet();

    public void sniff(String message) {
        HashSet closingVerbs = Sets.newHashSet((Object[])new String[]{"close", "closes", "closed", "fix", "fixes", "fixed", "resolve", "resolves", "resolved"});
        String closingVerbsPattern = "(" + Joiner.on((String)"|").join((Iterable)closingVerbs) + ")";
        Pattern issueNumberSeriePattern = Pattern.compile(closingVerbsPattern + "?\\s*#([0-9]+(,\\s?#?[0-9]+)*)", 2);
        Matcher issueNumberSerieMatcher = issueNumberSeriePattern.matcher(message);
        int pos = 0;
        while (issueNumberSerieMatcher.find(pos)) {
            String[] rawIssues = issueNumberSerieMatcher.group(2).split(",");
            HashSet issues = Sets.newHashSet();
            for (String rawIssue : rawIssues) {
                if ((rawIssue = rawIssue.trim()).startsWith("#")) {
                    rawIssue = rawIssue.substring(1);
                }
                issues.add(rawIssue);
            }
            if (StringUtils.isNotBlank((String)issueNumberSerieMatcher.group(1))) {
                this.toClose.addAll(issues);
            } else {
                this.toComment.addAll(issues);
            }
            pos = issueNumberSerieMatcher.end();
        }
    }

    public Set<String> getIssuesToClose() {
        return Sets.newHashSet(this.toClose);
    }

    public Set<String> getIssuesToComment() {
        return Sets.newHashSet(this.toComment);
    }
}

