/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class PromptDef {
    public PromptStudio.PromptMode promptMode;
    protected List<PromptStudio.PromptTemplateInput> promptTemplateInputs = new ArrayList<PromptStudio.PromptTemplateInput>();
    public String structuredPromptPrefix;
    public String structuredPromptSuffix;
    public String structuredPromptOutputName;
    public List<PromptStudio.StructuredPromptTemplateExample> structuredPromptExamples = new ArrayList<PromptStudio.StructuredPromptTemplateExample>();
    protected List<PromptStudio.PromptTemplateInput> textPromptTemplateInputs = new ArrayList<PromptStudio.PromptTemplateInput>();
    public String textPromptTemplate;
    public String textPromptSystemTemplate;
    public String rawPromptText;
    public String chatSystemMessage;
    public boolean streamingDisabled = false;
    public JsonObject chatContext;
    @JSON.FileTransient
    public Map<String, PromptStudio.ConversationMessage> chatMessages = new HashMap<String, PromptStudio.ConversationMessage>();
    @JSON.FileTransient
    public PromptStudio.ConversationMessage lastUserMessage;
    public String singleInputColumn;
    @Nullable
    public String imageFolderId;
    public GuardrailsPipelineSettings guardrailsPipelineSettings = new GuardrailsPipelineSettings();
    public PromptStudio.ResultValidation resultValidation = new PromptStudio.ResultValidation();
    public PromptStudio.PromptTemplateQueriesSource promptTemplateQueriesSource;

    public PromptDef() {
    }

    private PromptDef(PromptStudio.PromptMode mode, PromptStudio.PromptTemplateQueriesSource source) {
        this.promptMode = mode;
        this.promptTemplateQueriesSource = source;
    }

    public static PromptDef forRecipe() {
        return new PromptDef(PromptStudio.PromptMode.PROMPT_TEMPLATE_STRUCTURED, PromptStudio.PromptTemplateQueriesSource.DATASET);
    }

    public static PromptDef forEndpoint() {
        return new PromptDef(PromptStudio.PromptMode.PROMPT_TEMPLATE_STRUCTURED, PromptStudio.PromptTemplateQueriesSource.INLINE);
    }

    public List<PromptStudio.PromptTemplateInput> getInputs(PromptStudio.PromptMode mode) {
        switch (mode) {
            case PROMPT_TEMPLATE_STRUCTURED: {
                return this.promptTemplateInputs;
            }
            case PROMPT_TEMPLATE_TEXT: {
                return this.textPromptTemplateInputs;
            }
        }
        throw new IllegalArgumentException("Prompt mode does not use inputs: " + String.valueOf((Object)this.promptMode));
    }

    public List<PromptStudio.PromptTemplateInput> getInputs() {
        return this.getInputs(this.promptMode);
    }

    public String getInputName(PromptStudio.PromptTemplateInput input) {
        if (PromptStudio.PromptTemplateQueriesSource.DATASET.equals((Object)this.promptTemplateQueriesSource)) {
            return input.datasetColumnName;
        }
        if (PromptStudio.PromptTemplateQueriesSource.INLINE.equals((Object)this.promptTemplateQueriesSource)) {
            return input.name;
        }
        throw new IllegalStateException("Unknown source for prompt queries: " + String.valueOf((Object)this.promptTemplateQueriesSource));
    }

    public PromptStudio.PromptTemplateInput getInputByName(String inputName) {
        return this.getInputs().stream().filter(input -> inputName.equals(input.name)).findAny().orElse(null);
    }

    public static PromptDef copy(PromptDef originPrompt) {
        PromptDef newRecipePrompt = new PromptDef(originPrompt.promptMode, originPrompt.promptTemplateQueriesSource);
        newRecipePrompt.promptTemplateInputs = originPrompt.getInputs(PromptStudio.PromptMode.PROMPT_TEMPLATE_STRUCTURED);
        newRecipePrompt.structuredPromptPrefix = originPrompt.structuredPromptPrefix;
        newRecipePrompt.structuredPromptSuffix = originPrompt.structuredPromptSuffix;
        newRecipePrompt.structuredPromptOutputName = originPrompt.structuredPromptOutputName;
        newRecipePrompt.structuredPromptExamples = originPrompt.structuredPromptExamples;
        newRecipePrompt.textPromptTemplate = originPrompt.textPromptTemplate;
        newRecipePrompt.textPromptSystemTemplate = originPrompt.textPromptSystemTemplate;
        newRecipePrompt.textPromptTemplateInputs = originPrompt.getInputs(PromptStudio.PromptMode.PROMPT_TEMPLATE_TEXT);
        newRecipePrompt.resultValidation = originPrompt.resultValidation;
        newRecipePrompt.chatMessages = originPrompt.chatMessages;
        newRecipePrompt.lastUserMessage = originPrompt.lastUserMessage;
        newRecipePrompt.chatSystemMessage = originPrompt.chatSystemMessage;
        newRecipePrompt.guardrailsPipelineSettings = originPrompt.guardrailsPipelineSettings;
        return newRecipePrompt;
    }
}

