/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.scoring.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public class PartitioningUtils {
    public static String encode(String partitionId) {
        return PartitioningUtils.encode(partitionId, false);
    }

    public static String encode(String partitionId, boolean keepDashes) {
        return StringUtils.escape((String)partitionId, (Pattern)(keepDashes ? StringUtils.KEEP_ALPHANUM_DASHES : StringUtils.KEEP_ALPHANUM));
    }

    public static String decode(String partitionId) {
        return StringUtils.unescape((String)partitionId);
    }

    public static boolean isSingleDimension(PartitioningScheme scheme) {
        return scheme.isPartitioned() && scheme.getDimensionNames().size() == 1;
    }

    public static boolean isSingleTimeDimension(PartitioningScheme scheme) {
        if (PartitioningUtils.isSingleDimension(scheme)) {
            Dimension d = scheme.getSingleDimension();
            return d instanceof TimeDimension;
        }
        return false;
    }

    public static List<Partition> sort(List<Partition> list, final boolean reverse) {
        Collections.sort(list, new Comparator<Partition>(){

            @Override
            public int compare(Partition o1, Partition o2) {
                return reverse ? o2.id().compareTo(o1.id()) : o1.id().compareTo(o2.id());
            }
        });
        return list;
    }

    public static List<String> sortIdsList(List<String> list, final boolean reverse) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return reverse ? o2.compareTo(o1) : o1.compareTo(o2);
            }
        });
        return list;
    }

    public static List<String> toIds(List<Partition> list) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Partition p : list) {
            ret.add(p.id());
        }
        return ret;
    }
}

