/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregatorImpl;
import com.dataiku.dip.utils.NotImplementedException;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TDoubleHashSet;
import java.io.IOException;
import java.util.ArrayList;

public abstract class UnaggregatedMeasureFlushableAggregatorImpl
extends FlushableAggregatorImpl<TDoubleArrayList, ArrayList<String>> {
    public TDoubleArrayList[] uaData;
    public TIntArrayList[] uaDataCounts;
    public double[] uaDataNegativeExtents;
    public double[] uaDataPositiveExtents;
    private int maxValuesPerTensorElement;

    protected UnaggregatedMeasureFlushableAggregatorImpl(double[] data, long[] nonNullCounts, String column, int maxValues, int passNumber) {
        super(data, nonNullCounts, column, passNumber);
        this.uaData = new TDoubleArrayList[data.length];
        this.uaDataCounts = new TIntArrayList[data.length];
        this.uaDataNegativeExtents = new double[data.length];
        this.uaDataPositiveExtents = new double[data.length];
        this.maxValuesPerTensorElement = maxValues;
    }

    protected UnaggregatedMeasureFlushableAggregatorImpl(double[] data, long[] nonNullCounts, String column, int maxValues) {
        super(data, nonNullCounts, column);
        this.uaData = new TDoubleArrayList[data.length];
        this.uaDataCounts = new TIntArrayList[data.length];
        this.uaDataNegativeExtents = new double[data.length];
        this.uaDataPositiveExtents = new double[data.length];
        this.maxValuesPerTensorElement = maxValues;
    }

    protected abstract void handleExtent(double var1, int var3);

    @Override
    public boolean handle(double value, int loc) throws IOException {
        boolean handled = super.handle(value, loc);
        if (handled) {
            TDoubleArrayList tDoubleArray = this.doubleStore.computeIfAbsent(loc, x -> new TDoubleArrayList());
            tDoubleArray.add(value);
            this.data[loc] = 1.0;
        }
        return handled;
    }

    @Override
    public boolean handle(Object value, int loc) throws IOException {
        throw new NotImplementedException("Cannot handle unaggregated measure on non numeric values");
    }

    @Override
    public void onEnd(boolean storeLocation) throws IOException {
        super.onEnd(storeLocation);
        if (!this.hasBeenFlushed() && this.doubleStore != null) {
            this.doubleStore.forEach(this::computeOutputData);
        }
    }

    @Override
    public void readValues(int loc, FlushableAggregator.Visitor visitor) throws IOException {
        if (this.doubleStore != null && !this.doubleStore.isEmpty()) {
            TDoubleArrayList values = (TDoubleArrayList)this.doubleStore.get(loc);
            if (values == null) {
                return;
            }
            visitor.beginRead(loc, values.size());
            TDoubleIterator iterator = values.iterator();
            while (iterator.hasNext()) {
                visitor.handleDouble(iterator.next());
            }
            visitor.endRead(loc);
            return;
        }
        super.readValues(loc, visitor);
    }

    @Override
    public void handleString(String value) {
        throw new NotImplementedException("Cannot handle unaggregated measure on non numeric values");
    }

    @Override
    public void handleDouble(double value) {
        if (this.doubleValues == null) {
            this.doubleValues = new TDoubleArrayList();
            this.stringValues = null;
        }
        ((TDoubleArrayList)this.doubleValues).add(value);
    }

    @Override
    public void endRead(int location) {
        if (this.doubleValues != null) {
            this.computeOutputData(location, (TDoubleArrayList)this.doubleValues);
        }
    }

    private void computeOutputData(int location, TDoubleArrayList values) {
        values.sort();
        TDoubleArrayList binData = new TDoubleArrayList();
        TIntArrayList binDataCounts = new TIntArrayList();
        TDoubleHashSet uniqueValues = new TDoubleHashSet();
        for (int i = 0; i < values.size(); ++i) {
            double value = values.get(values.size() - 1 - i);
            if (uniqueValues.add(value)) {
                binData.add(value);
                binDataCounts.add(1);
                this.handleExtent(value, location);
            } else {
                binDataCounts.set(binDataCounts.size() - 1, binDataCounts.get(binDataCounts.size() - 1) + 1);
            }
            if (uniqueValues.size() >= this.maxValuesPerTensorElement) break;
        }
        this.uaData[location] = binData;
        this.uaDataCounts[location] = binDataCounts;
    }
}

