/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.executors.FacetHybridExecutor;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class FacetsHybridExecutor
implements Callable<List<FilterFacet>> {
    private final Future<ColumnMapper> colMappingFuture;
    private final ExecutionContext ctx;
    private final Future<BasicStatsBuilder.BasicStats> basicStatsFuture;
    private final Future<BasicStatsBuilder.BasicStats> globalStatsFuture;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.charts.sql.facets");

    public FacetsHybridExecutor(ExecutionContext ctx, Future<ColumnMapper> colMappingFuture, Future<BasicStatsBuilder.BasicStats> basicStatsFuture, Future<BasicStatsBuilder.BasicStats> globalStatsFuture) {
        this.colMappingFuture = colMappingFuture;
        this.basicStatsFuture = basicStatsFuture;
        this.globalStatsFuture = globalStatsFuture;
        this.ctx = ctx;
    }

    @Override
    public List<FilterFacet> call() throws Exception {
        logger.debug((Object)"Starting task: Facets");
        try {
            ArrayList<FilterFacet> arrayList;
            block14: {
                FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Building facet(s)...", (double)this.ctx.req.filters.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                try {
                    ArrayList<Future<FilterFacet>> futures = new ArrayList<Future<FilterFacet>>();
                    ArrayList<FilterFacet> facetFilters = new ArrayList<FilterFacet>();
                    for (int facetIdx = 0; facetIdx < this.ctx.req.filters.size(); ++facetIdx) {
                        FacetHybridExecutor executor;
                        RowFilter rowFilter = (RowFilter)this.ctx.req.filters.get(facetIdx);
                        if (rowFilter.useMinimalUi) continue;
                        ArrayList<RowFilter> otherFilters = new ArrayList<RowFilter>();
                        for (RowFilter orf : this.ctx.req.filters) {
                            if (orf == rowFilter || !orf.active) continue;
                            otherFilters.add(orf);
                        }
                        if (this.ctx.singleThreadExecution) {
                            executor = new FacetHybridExecutor(this.ctx, this.colMappingFuture, this.basicStatsFuture, this.globalStatsFuture, rowFilter, otherFilters, facetIdx, (FutureProgressState)state);
                            facetFilters.add(executor.call());
                            continue;
                        }
                        executor = new FacetHybridExecutor(this.ctx, this.colMappingFuture, this.basicStatsFuture, this.globalStatsFuture, rowFilter, otherFilters, facetIdx, (FutureProgressState)state);
                        Future<FilterFacet> futureFacet = this.ctx.threadPool.submit(executor);
                        futures.add(futureFacet);
                    }
                    if (!this.ctx.singleThreadExecution) {
                        for (Future future : futures) {
                            facetFilters.add((FilterFacet)future.get());
                        }
                    }
                    arrayList = facetFilters;
                    if (state == null) break block14;
                }
                catch (Throwable throwable) {
                    if (state != null) {
                        try {
                            state.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                state.close();
            }
            return arrayList;
        }
        finally {
            logger.debug((Object)"Done task: Facets");
        }
    }
}

