/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.utils;

import gnu.trove.TLongCollection;
import gnu.trove.list.array.TLongArrayList;

public class NullableLongArrayList
extends TLongArrayList {
    private static final long serialVersionUID = 981725346657057622L;

    public NullableLongArrayList() {
        this.no_entry_value = Long.MIN_VALUE;
    }

    public NullableLongArrayList(NullableLongArrayList copyFrom) {
        super((TLongCollection)copyFrom);
        this.no_entry_value = copyFrom.no_entry_value;
    }

    public void addNullable(Long val) {
        if (val == null) {
            this.add(this.no_entry_value);
        } else if (val != this.no_entry_value) {
            this.add(val);
        } else {
            int i;
            boolean isValid = false;
            long newNoEntryValue = this.no_entry_value;
            block0: while (!isValid) {
                ++newNoEntryValue;
                isValid = true;
                for (i = 0; i < this.size(); ++i) {
                    if (this.get(i) != newNoEntryValue) continue;
                    isValid = false;
                    continue block0;
                }
            }
            for (i = 0; i < this.size(); ++i) {
                if (this.get(i) != this.no_entry_value) continue;
                this.set(i, newNoEntryValue);
            }
            this.no_entry_value = newNoEntryValue;
            this.add(val);
        }
    }

    public Long getNullable(int idx) {
        long v = this.get(idx);
        if (v == this.no_entry_value) {
            return null;
        }
        return v;
    }

    public long min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        long min = Long.MAX_VALUE;
        for (int i = 0; i < this._pos; ++i) {
            if (this._data[i] >= min || this._data[i] == this.no_entry_value) continue;
            min = this._data[i];
        }
        return min;
    }

    public long max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this._pos; ++i) {
            if (this._data[i] <= max || this._data[i] == this.no_entry_value) continue;
            max = this._data[i];
        }
        return max;
    }

    public NullableLongArrayList clone() {
        return new NullableLongArrayList(this);
    }
}

