/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.apps;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.projects.apps.CustomAppTemplateDesc;
import com.dataiku.dip.projects.apps.LoadedCustomAppTemplate;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.fromapp.AppRecipeMeta;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomAppTemplatesService
extends AbstractElementService<CustomAppTemplateDesc, LoadedCustomAppTemplate> {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.plugins.apps");

    @Override
    public String getFolderName() {
        return "apps";
    }

    @Override
    public String getPrefix() {
        return "app";
    }

    @Override
    protected String getCodeExtension(LoadedCustomAppTemplate desc) {
        return "none";
    }

    @Override
    protected void removeElement(LoadedCustomAppTemplate desc) {
        String elementType = desc.getType();
        try {
            AppManifest manifest = this.getPluginAppManifest(elementType);
            if (manifest != null && manifest.useAsRecipeSettings != null) {
                logger.info((Object)("Deregistering recipe-app " + elementType));
                AppRecipeMeta arm = new AppRecipeMeta(elementType, manifest);
                RecipeRegistry.deregister(arm);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to register recipe types from plugin app", (Throwable)e);
        }
    }

    @Override
    public String makeType(String pluginId, String elementId) {
        return "PLUGIN_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedCustomAppTemplate load(String elementType, String pluginId, String elementId, File file) throws IOException {
        CustomAppTemplateDesc customAppTemplateDesc = (CustomAppTemplateDesc)JSON.parseFile((File)file, CustomAppTemplateDesc.class);
        boolean isUsedAsRecipe = false;
        try {
            AppManifest manifest = this.getPluginAppManifest(pluginId, elementId);
            if (manifest != null && manifest.useAsRecipeSettings != null) {
                logger.info((Object)("Registering recipe-app " + elementType));
                isUsedAsRecipe = true;
                AppRecipeMeta arm = new AppRecipeMeta(elementType, manifest);
                RecipeRegistry.register(arm);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to register recipe types from plugin app", (Throwable)e);
        }
        return new LoadedCustomAppTemplate(elementId, pluginId, elementType, customAppTemplateDesc, isUsedAsRecipe);
    }

    @Override
    public Class<CustomAppTemplateDesc> getDescClass() {
        return CustomAppTemplateDesc.class;
    }

    @Override
    public Class<LoadedCustomAppTemplate> getLoadedDescClass() {
        return LoadedCustomAppTemplate.class;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomAppTemplateDesc customAppTemplateDesc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                this.genericValidateMeta(customAppTemplateDesc.meta);
                return this.messages;
            }
        }.validate();
    }

    private LoadedCustomAppTemplate getTemplate(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        return (LoadedCustomAppTemplate)this.loadedDescs.get(elementType);
    }

    public File getProjectArchive(String elementType) {
        LoadedCustomAppTemplate loadedTemplate = this.getTemplate(elementType);
        return this.getProjectArchive(loadedTemplate.getOwnerPluginId(), loadedTemplate.getId());
    }

    public File getProjectArchive(String pluginId, String elementId) {
        File pluginDir = this.pluginsService.getActualPluginFolder(pluginId);
        File exporterDirectory = new File(new File(pluginDir, this.getFolderName()), elementId);
        return new File(exporterDirectory, "project.zip");
    }

    public File getAppImage(String elementType, boolean fullImage) {
        String appImageName;
        LoadedCustomAppTemplate loadedTemplate = this.getTemplate(elementType);
        String string = appImageName = fullImage ? loadedTemplate.desc.appFullImageFilename : loadedTemplate.desc.appImageFilename;
        if (StringUtils.isBlank((String)appImageName)) {
            return null;
        }
        File resourceDirectory = this.pluginsService.getPluginResourceFolder(loadedTemplate.getOwnerPluginId());
        return new File(resourceDirectory, appImageName);
    }

    @Nullable
    public String getOwnerPluginId(String elementType) {
        LoadedCustomAppTemplate loadedTemplate = this.getTemplate(elementType);
        return loadedTemplate != null ? loadedTemplate.getOwnerPluginId() : null;
    }

    private AppManifest getPluginAppManifest(String type) throws IOException {
        File archiveFile = this.getProjectArchive(type);
        if (!archiveFile.exists()) {
            logger.error((Object)("Project archive for plugin app " + type + " not found : " + String.valueOf(archiveFile)));
            return null;
        }
        return this.getPluginAppManifest(archiveFile, type);
    }

    private AppManifest getPluginAppManifest(String pluginId, String elementId) throws IOException {
        File archiveFile = this.getProjectArchive(pluginId, elementId);
        if (!archiveFile.exists()) {
            logger.error((Object)("Project archive for plugin app " + pluginId + " " + elementId + " not found : " + String.valueOf(archiveFile)));
            return null;
        }
        return this.getPluginAppManifest(archiveFile, pluginId + " " + elementId);
    }

    private AppManifest getPluginAppManifest(File archiveFile, String type) throws IOException {
        try (ZipFile archive = new ZipFile(archiveFile);){
            ZipEntry appManifestEntry = archive.getEntry("project_config/app-manifest.json");
            if (appManifestEntry == null) {
                logger.error((Object)("App manifest missing from plugin app's project archive : " + type));
                AppManifest appManifest = null;
                return appManifest;
            }
            AppManifest appManifest = (AppManifest)JSON.parse((InputStream)archive.getInputStream(appManifestEntry), AppManifest.class);
            return appManifest;
        }
    }
}

