/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.sanitycheck.detectors.ContainerExecInformation;
import com.dataiku.dip.sanitycheck.detectors.DockerImageInformation;
import com.dataiku.dip.sanitycheck.detectors.ExecutionException;
import com.dataiku.dip.sanitycheck.detectors.InstallationInformation;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.html.HtmlEscapers;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class CodeEnvDetector
implements SanityCheckDetectorBase {
    private static final HrefContext HREF_CONTEXT = new HrefContext("");
    private final DesignNodeCodeEnvsService designNodeCodeEnvsService;
    private final AutomationNodeCodeEnvsService automationNodeCodeEnvsService;
    private final InstallationInformation installationInformation;
    private final DockerImageInformation dockerImageInformation;
    private final ContainerExecInformation containerExecInformation;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.codeenvdetector");

    @Autowired
    CodeEnvDetector(DesignNodeCodeEnvsService designNodeCodeEnvsService, AutomationNodeCodeEnvsService automationNodeCodeEnvsService, InstallationInformation installationInformation, DockerImageInformation dockerImageInformation, ContainerExecInformation containerExecInformation) {
        this.designNodeCodeEnvsService = designNodeCodeEnvsService;
        this.automationNodeCodeEnvsService = automationNodeCodeEnvsService;
        this.installationInformation = installationInformation;
        this.dockerImageInformation = dockerImageInformation;
        this.containerExecInformation = containerExecInformation;
    }

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (exclusionList.containsAll(Arrays.stream(Codes.values()).map(InfoMessage.MessageCode::getCode).collect(Collectors.toList()))) {
            return messages;
        }
        ImageCreationDateCache imageCreationDateCache = new ImageCreationDateCache();
        try {
            this.generateCodeEnvFacadesToBeChecked().flatMap(codeEnvFacade -> this.generateCodeEnvImageOlderThanBaseImage((CodeEnvFacade)codeEnvFacade, imageCreationDateCache)).forEach(arg_0 -> ((SanityCheckInfoMessages)messages).addMessage(arg_0));
        }
        catch (InternalException e) {
            logger.warn((Object)"Sanity check failed", (Throwable)e);
            messages.addMessage(this.createFatalMessage(e));
        }
        return messages;
    }

    private Stream<InfoMessage> generateCodeEnvImageOlderThanBaseImage(CodeEnvFacade codeEnvFacade, ImageCreationDateCache imageCreationDateCache) {
        try {
            Set baseImagesIdYoungerThanCodeEnvImageSet = this.containerExecInformation.computeBaseImageIdAndType(codeEnvFacade.getEnvDesc(), codeEnvFacade.getName()).stream().flatMap(baseImageIdAndType -> {
                Optional<Instant> baseImageCreationDate = imageCreationDateCache.getCreationDate(baseImageIdAndType.baseImageId);
                Optional<Instant> codeEnvBaseCreationDate = imageCreationDateCache.getCreationDateForCodeEnvImage(codeEnvFacade, baseImageIdAndType.baseImageType);
                boolean isBaseImageYoungerThanCodeEnvImage = baseImageCreationDate.isPresent() && codeEnvBaseCreationDate.isPresent() && codeEnvBaseCreationDate.get().isBefore(baseImageCreationDate.get());
                return isBaseImageYoungerThanCodeEnvImage ? Stream.of(baseImageIdAndType.baseImageId) : Stream.of(new String[0]);
            }).collect(Collectors.toSet());
            if (baseImagesIdYoungerThanCodeEnvImageSet.isEmpty()) {
                return Stream.empty();
            }
            return Stream.of(InfoMessage.warning((InfoMessage.MessageCode)Codes.WARN_MISC_CODE_ENV_IMAGE_OUT_OF_DATE, (String)String.format("The %s Code Env is using image(s) older than the respective base images: %s", this.generateCodeEnvLink(codeEnvFacade), HtmlEscapers.htmlEscaper().escape(String.join((CharSequence)",", baseImagesIdYoungerThanCodeEnvImageSet)))));
        }
        catch (IOException e) {
            logger.warn((Object)"Sanity check failed", (Throwable)e);
            return Stream.of(this.createFatalMessage(e));
        }
    }

    private Stream<CodeEnvFacade> generateCodeEnvFacadesToBeChecked() {
        try {
            switch (this.installationInformation.getNodeType()) {
                case DESIGN: {
                    return this.designNodeCodeEnvsService.listCodeEnvs().stream().map(this::buildDesignerNodeCodeEnvFacade);
                }
                case AUTOMATION: {
                    return this.automationNodeCodeEnvsService.listCodeEnvs().stream().flatMap(this::buildAutomationNodeCodeEnvFacades);
                }
            }
            return Stream.empty();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private CodeEnvFacade buildDesignerNodeCodeEnvFacade(final CodeEnvModel.CodeEnvListItem codeEnv) {
        return new CodeEnvFacade(){

            @Override
            @Nullable
            public String getVersion() {
                return null;
            }

            @Override
            public String getName() {
                return codeEnv.envName;
            }

            @Override
            public CodeEnvModel.EnvLang getEnvLang() {
                return codeEnv.envLang;
            }

            @Override
            public CodeEnvModel.AbstractEnvDesc getEnvDesc() {
                try {
                    return CodeEnvDetector.this.designNodeCodeEnvsService.getEnvDesc(codeEnv.envLang, codeEnv.envName);
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }

            @Override
            public ApplicationConfigurator.DSSNodeType getDSSNodeType() {
                return ApplicationConfigurator.DSSNodeType.DESIGN;
            }
        };
    }

    private Stream<CodeEnvFacade> buildAutomationNodeCodeEnvFacades(CodeEnvModel.CodeEnvListItem codeEnv) {
        try {
            CodeEnvModel.AutomationUIEnv<?> env = this.automationNodeCodeEnvsService.getEnvForUI(codeEnv.envLang, codeEnv.envName, false);
            switch (env.deploymentMode) {
                case AUTOMATION_SINGLE: {
                    return Optional.ofNullable(env.currentVersion).map(pythonEnvVersion -> this.buildCodeEnvFacade(codeEnv, (CodeEnvModel.AbstractAutomationUIEnvVersion<?>)pythonEnvVersion)).stream();
                }
                case AUTOMATION_VERSIONED: {
                    return env.versions.stream().map(pythonEnvVersion -> this.buildCodeEnvFacade(codeEnv, (CodeEnvModel.AbstractAutomationUIEnvVersion<?>)pythonEnvVersion));
                }
            }
            return Stream.empty();
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    private CodeEnvFacade buildCodeEnvFacade(final CodeEnvModel.CodeEnvListItem codeEnv, final CodeEnvModel.AbstractAutomationUIEnvVersion<?> envVersion) {
        return new CodeEnvFacade(){

            @Override
            @Nullable
            public String getVersion() {
                return envVersion.versionId;
            }

            @Override
            public String getName() {
                return codeEnv.envName;
            }

            @Override
            public CodeEnvModel.EnvLang getEnvLang() {
                return codeEnv.envLang;
            }

            @Override
            public CodeEnvModel.AbstractEnvDesc getEnvDesc() {
                try {
                    return CodeEnvDetector.this.automationNodeCodeEnvsService.getEnvDesc(codeEnv.envName, codeEnv.envLang, Optional.ofNullable(envVersion.versionId));
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }

            @Override
            public ApplicationConfigurator.DSSNodeType getDSSNodeType() {
                return ApplicationConfigurator.DSSNodeType.AUTOMATION;
            }
        };
    }

    private String generateCodeEnvLink(CodeEnvFacade codeEnvFacade) {
        return this.generateHtmlLink(HREF_CONTEXT.codeEnv(codeEnvFacade.getDSSNodeType(), codeEnvFacade.getEnvLang(), codeEnvFacade.getName()), codeEnvFacade.getName());
    }

    private String generateHtmlLink(String url, String linkText) {
        return String.format("<a href=\"%s\">%s</a>", url, HtmlEscapers.htmlEscaper().escape(linkText));
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_MISC_CODE_ENV_IMAGE_OUT_OF_DATE("Code Envs - Images out of date", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }

    private class ImageCreationDateCache {
        Map<String, Optional<Instant>> imageIdToCreationDateMap = new HashMap<String, Optional<Instant>>();

        private ImageCreationDateCache() {
        }

        Optional<Instant> getCreationDateForCodeEnvImage(CodeEnvFacade codeEnvFacade, ContainerExecUtils.BaseImageType baseImageType) {
            try {
                return CodeEnvDetector.this.containerExecInformation.getImageTag(baseImageType, codeEnvFacade.getEnvLang(), codeEnvFacade.getName(), codeEnvFacade.getVersion()).flatMap(this::getCreationDate);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }

        Optional<Instant> getCreationDate(String imageId) {
            return this.imageIdToCreationDateMap.computeIfAbsent(imageId, key -> {
                try {
                    return CodeEnvDetector.this.dockerImageInformation.getCreationDate(imageId);
                }
                catch (ExecutionException e) {
                    throw new InternalException(e);
                }
            });
        }
    }

    private static class InternalException
    extends RuntimeException {
        InternalException(Throwable throwable) {
            super(throwable);
        }
    }

    private static interface CodeEnvFacade {
        @CheckForNull
        public String getVersion();

        public String getName();

        public CodeEnvModel.EnvLang getEnvLang();

        public CodeEnvModel.AbstractEnvDesc getEnvDesc();

        public ApplicationConfigurator.DSSNodeType getDSSNodeType();
    }
}

