/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.scheduler.TicketBasedCustomPythonRunner;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.LoadedPythonPluginStep;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.PythonPluginStepsService;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PythonPluginStepRunner
implements StepRunner {
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private InsecureProcessesLaunchService insecureProcessesLaunchService;
    @Autowired
    private PythonPluginStepsService pythonPluginStepsService;
    private final Step step;
    private final PythonPluginStepParams params;
    private final LoadedPythonPluginStep desc;
    private final String pluginId;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.plugin.step");

    public PythonPluginStepRunner(Step step, String pluginId, LoadedPythonPluginStep desc, PythonPluginStepParams params) {
        this.step = step;
        this.pluginId = pluginId;
        this.desc = desc;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.getName()));
        Scenario scenario = stepRun.getScenarioRun().getScenario();
        File runFolder = ScenarioRunContext.scenarioRunFolder(scenario.getProjectKey(), scenario.getId(), stepRun.getScenarioRun().getRunId());
        File pythonRunFolder = DKUFileUtils.getWithin((File)runFolder, (String[])new String[]{"plugin-step-" + this.step.getName()});
        DKUFileUtils.mkdirs((File)pythonRunFolder);
        TicketBasedCustomPythonRunner pythonRunner = new TicketBasedCustomPythonRunner(this.apiTicketService, this.insecureProcessesLaunchService, "scenario_plugin_step:" + scenario.getProjectKey() + "." + scenario.getId(), stepRun.getScenarioRun().getRunAsUser(), pythonRunFolder, stepRun, false);
        HashMap extraEnv = Maps.newHashMap();
        HashMap fileBasedEnv = Maps.newHashMap();
        extraEnv.put("DKU_CURRENT_PROJECT_KEY", scenario.getProjectKey());
        if (stepRun.getScenarioRun().getTrigger() != null) {
            fileBasedEnv.put("DKU_CURRENT_SCENARIO_TRIGGER_FILE", JSON.json((Object)stepRun.getScenarioRun().getTrigger()));
        }
        String code = this.pythonPluginStepsService.getCode(this.desc.stepType);
        pythonRunner.addPythonLib("plugin-python-lib", this.pythonPluginStepsService.getLibFolder(this.desc.stepType));
        extraEnv.put("DKU_PLUGIN_CONFIG", JSON.json((Object)this.pythonPluginStepsService.getExpandedPluginSettings(this.desc.stepType, stepRun.getScenarioRun().getRunAsUser(), scenario.getProjectKey(), this.params.config)));
        this.pythonPluginStepsService.putResourceFolderEnvironmentVariable(extraEnv, this.desc.stepType, true, "DKU_PLUGIN_RESOURCES");
        extraEnv.put("DKU_PLUGIN_STEP_CONFIG", JSON.json((Object)this.params.config));
        pythonRunner.run(code, extraEnv, fileBasedEnv, scenario.getProjectKey(), this.pluginId, null, stepReportItem, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_SCENARIO);
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class PythonPluginStepParams
    extends NonFatalStepParams
    implements StepParams {
        public JsonObject config = new JsonObject();
    }

    public static class PythonPluginStepMeta
    implements StepMeta,
    IPluginifiedMeta {
        private final LoadedPythonPluginStep desc;
        private final String pluginId;

        public PythonPluginStepMeta(String pluginId, LoadedPythonPluginStep desc, PythonPluginStepsService pythonPluginStepsService) {
            this.pluginId = pluginId;
            this.desc = desc;
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return PythonPluginStepParams.class;
        }

        @Override
        public String getType() {
            return this.desc.stepType;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new PythonPluginStepRunner(step, this.pluginId, this.desc, step.getParamsAs(PythonPluginStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "custom python";
        }

        @Override
        public String buildId(Step step) {
            String base = null;
            if (this.desc.desc.meta != null) {
                base = this.desc.desc.meta.label;
            }
            if (StringUtils.isBlank(base)) {
                base = this.desc.getType();
            }
            PythonPluginStepParams params = step.getParamsAs(PythonPluginStepParams.class);
            return base + "_" + DKUtils.md5Base64((String)JSON.json((Object)params.config));
        }

        @Override
        public IElementLoadedDesc getLoadedDesc() {
            return this.desc;
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    }
}

